/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.InsufficientInformationException;
import org.opennms.netmgt.collectd.CollectableService;
import org.opennms.netmgt.collectd.CollectorUpdates;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionInstrumentation;
import org.opennms.netmgt.collection.api.LocationAwareCollectorClient;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.api.ServiceCollectorRegistry;
import org.opennms.netmgt.collection.core.CollectionSpecification;
import org.opennms.netmgt.collection.core.DefaultCollectdInstrumentation;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.collectd.CollectdConfiguration;
import org.opennms.netmgt.config.collectd.Collector;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.config.dao.outages.api.ReadablePollOutagesDao;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.events.api.model.IParm;
import org.opennms.netmgt.events.api.model.IValue;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.model.AbstractEntityVisitor;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Scheduler;
import org.opennms.netmgt.snmp.InetAddrUtils;
import org.opennms.netmgt.threshd.api.ThresholdingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class Collectd
extends AbstractServiceDaemon
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(Collectd.class);
    private static CollectionInstrumentation s_instrumentation = null;
    static final String LOG4J_CATEGORY = "collectd";
    private final Map<String, ServiceCollector> m_collectors = new HashMap<String, ServiceCollector>(4);
    private final List<CollectableService> m_collectableServices;
    private volatile Scheduler m_scheduler;
    @Autowired
    private volatile CollectdConfigFactory m_collectdConfigFactory;
    @Autowired
    private volatile IpInterfaceDao m_ifaceDao;
    @Autowired
    private volatile FilterDao m_filterDao;
    @Autowired
    private volatile ServiceCollectorRegistry m_serviceCollectorRegistry;
    @Autowired
    private volatile LocationAwareCollectorClient m_locationAwareCollectorClient;
    private final SchedulingCompletedFlag m_schedulingCompletedFlag = new SchedulingCompletedFlag();
    private volatile EventIpcManager m_eventIpcManager;
    @Autowired
    private volatile TransactionTemplate m_transTemplate;
    @Autowired
    private volatile NodeDao m_nodeDao;
    @Autowired
    private PersisterFactory m_persisterFactory;
    @Autowired
    private ThresholdingService m_thresholdingService;
    @Autowired
    private ReadablePollOutagesDao pollOutagesDao;

    public static CollectionInstrumentation instrumentation() {
        if (s_instrumentation == null) {
            String className = System.getProperty("org.opennms.collectd.instrumentationClass", DefaultCollectdInstrumentation.class.getName());
            try {
                s_instrumentation = (CollectionInstrumentation)ClassUtils.forName((String)className, (ClassLoader)Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (Throwable e) {
                s_instrumentation = new DefaultCollectdInstrumentation();
            }
        }
        return s_instrumentation;
    }

    public Collectd() {
        super(LOG4J_CATEGORY);
        this.m_collectableServices = Collections.synchronizedList(new LinkedList());
    }

    protected void onInit() {
        Assert.notNull((Object)this.m_collectdConfigFactory, (String)"collectdConfigFactory must not be null");
        Assert.notNull((Object)this.m_eventIpcManager, (String)"eventIpcManager must not be null");
        Assert.notNull((Object)this.m_transTemplate, (String)"transTemplate must not be null");
        Assert.notNull((Object)this.m_ifaceDao, (String)"ifaceDao must not be null");
        Assert.notNull((Object)this.m_nodeDao, (String)"nodeDao must not be null");
        Assert.notNull((Object)this.m_filterDao, (String)"filterDao must not be null");
        LOG.debug("init: Initializing collection daemon");
        Collectd.instrumentation();
        this.instantiateCollectors();
        this.getScheduler().schedule(0L, this.ifScheduler());
        this.installMessageSelectors();
    }

    private void installMessageSelectors() {
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/nodes/nodeGainedService");
        ueiList.add("uei.opennms.org/nodes/primarySnmpInterfaceChanged");
        ueiList.add("uei.opennms.org/nodes/reinitializePrimarySnmpInterface");
        ueiList.add("uei.opennms.org/nodes/interfaceReparented");
        ueiList.add("uei.opennms.org/nodes/nodeDeleted");
        ueiList.add("uei.opennms.org/nodes/duplicateNodeDeleted");
        ueiList.add("uei.opennms.org/nodes/interfaceDeleted");
        ueiList.add("uei.opennms.org/nodes/serviceDeleted");
        ueiList.add("uei.opennms.org/internal/schedOutagesChanged");
        ueiList.add("uei.opennms.org/internal/configureSNMP");
        ueiList.add("uei.opennms.org/internal/thresholdConfigChange");
        ueiList.add("uei.opennms.org/internal/reloadDaemonConfig");
        ueiList.add("uei.opennms.org/nodes/nodeCategoryMembershipChanged");
        ueiList.add("uei.opennms.org/nodes/nodeLocationChanged");
        this.getEventIpcManager().addEventListener((EventListener)this, ueiList);
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.m_eventIpcManager = eventIpcManager;
    }

    public EventIpcManager getEventIpcManager() {
        return this.m_eventIpcManager;
    }

    public ThresholdingService getThresholdingService() {
        return this.m_thresholdingService;
    }

    public void setThresholdingService(ThresholdingService thresholdingService) {
        this.m_thresholdingService = thresholdingService;
    }

    private ReadyRunnable ifScheduler() {
        ReadyRunnable interfaceScheduler = new ReadyRunnable(){

            public boolean isReady() {
                return true;
            }

            public void run() {
                Logging.withPrefix((String)Collectd.LOG4J_CATEGORY, () -> {
                    try {
                        Collectd.this.scheduleExistingInterfaces();
                    }
                    finally {
                        Collectd.this.setSchedulingCompleted(true);
                    }
                });
            }
        };
        return interfaceScheduler;
    }

    private void createScheduler() {
        Logging.withPrefix((String)LOG4J_CATEGORY, () -> {
            try {
                LOG.debug("init: Creating collectd scheduler");
                this.setScheduler((Scheduler)new LegacyScheduler("Collectd", this.m_collectdConfigFactory.getCollectdConfig().getThreads().intValue()));
            }
            catch (RuntimeException e) {
                LOG.error("init: Failed to create collectd scheduler", (Throwable)e);
                throw e;
            }
        });
    }

    protected void onStart() {
        try {
            LOG.debug("start: Starting collectd scheduler");
            this.getScheduler().start();
        }
        catch (RuntimeException e) {
            LOG.error("start: Failed to start scheduler", (Throwable)e);
            throw e;
        }
    }

    protected void onStop() {
        this.getScheduler().stop();
        this.deinstallMessageSelectors();
        this.setScheduler(null);
    }

    protected void onPause() {
        this.getScheduler().pause();
    }

    protected void onResume() {
        this.getScheduler().resume();
    }

    private void scheduleExistingInterfaces() {
        Collectd.instrumentation().beginScheduleExistingInterfaces();
        try {
            this.m_transTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                public void doInTransactionWithoutResult(TransactionStatus status) {
                    for (String name : Collectd.this.getCollectorNames()) {
                        Collectd.this.scheduleInterfacesWithService(name);
                    }
                }
            });
        }
        finally {
            Collectd.instrumentation().endScheduleExistingInterfaces();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleInterfacesWithService(String svcName) {
        Collectd.instrumentation().beginScheduleInterfacesWithService(svcName);
        try {
            LOG.info("scheduleInterfacesWithService: svcName = {}", (Object)svcName);
            Collection<OnmsIpInterface> ifsWithServices = this.findInterfacesWithService(svcName);
            for (OnmsIpInterface iface : ifsWithServices) {
                this.scheduleInterface(iface, svcName, true);
            }
        }
        finally {
            Collectd.instrumentation().endScheduleInterfacesWithService(svcName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<OnmsIpInterface> findInterfacesWithService(String svcName) {
        Collectd.instrumentation().beginFindInterfacesWithService(svcName);
        int count = -1;
        try {
            List ifaces = this.m_ifaceDao.findByServiceType(svcName);
            count = ifaces.size();
            List list = ifaces;
            return list;
        }
        finally {
            Collectd.instrumentation().endFindInterfacesWithService(svcName, count);
        }
    }

    private void scheduleInterface(int nodeId, String ipAddress, String svcName, boolean existing) {
        OnmsIpInterface iface = this.getIpInterface(nodeId, ipAddress);
        if (iface == null) {
            LOG.error("Unable to find interface with address {} on node {}", (Object)ipAddress, (Object)nodeId);
            return;
        }
        OnmsMonitoredService svc = iface.getMonitoredServiceByServiceType(svcName);
        if (svc == null) {
            LOG.error("Unable to find service {} on interface with address {} on node {}", new Object[]{svcName, ipAddress, nodeId});
            return;
        }
        this.scheduleInterface(iface, svc.getServiceType().getName(), existing);
    }

    private void scheduleNode(int nodeId, final boolean existing) {
        OnmsNode node = this.m_nodeDao.getHierarchy(Integer.valueOf(nodeId));
        node.visit((EntityVisitor)new AbstractEntityVisitor(){

            public void visitMonitoredService(OnmsMonitoredService monSvc) {
                Collectd.this.scheduleInterface(monSvc.getIpInterface(), monSvc.getServiceName(), existing);
            }
        });
    }

    private OnmsIpInterface getIpInterface(int nodeId, String ipAddress) {
        OnmsNode node = (OnmsNode)this.m_nodeDao.load((Serializable)Integer.valueOf(nodeId));
        return node.getIpInterfaceByIpAddress(ipAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleInterface(OnmsIpInterface iface, String svcName, boolean existing) {
        String ipAddress = InetAddressUtils.str((InetAddress)iface.getIpAddress());
        if (ipAddress == null) {
            LOG.warn("Unable to schedule interface {}, could not determine IP address.", (Object)iface);
            return;
        }
        Collectd.instrumentation().beginScheduleInterface(iface.getNode().getId().intValue(), ipAddress, svcName);
        try {
            Collection<CollectionSpecification> matchingSpecs = this.getSpecificationsForInterface(iface, svcName);
            LOG.debug("scheduleInterface: found {} matching specs for interface: {}", (Object)matchingSpecs.size(), (Object)iface);
            for (CollectionSpecification spec : matchingSpecs) {
                if (!existing && this.alreadyScheduled(iface, spec)) {
                    LOG.debug("scheduleInterface: svc/pkgName {}/{} already in collectable service list, skipping.", (Object)iface, (Object)spec);
                    continue;
                }
                try {
                    LOG.debug("scheduleInterface: now scheduling interface: {}/{}", (Object)iface, (Object)svcName);
                    CollectableService cSvc = null;
                    cSvc = new CollectableService(iface, this.m_ifaceDao, spec, this.getScheduler(), this.m_schedulingCompletedFlag, this.m_transTemplate.getTransactionManager(), this.m_persisterFactory, this.m_thresholdingService);
                    this.m_collectableServices.add(cSvc);
                    this.getScheduler().schedule(0L, cSvc.getReadyRunnable());
                    LOG.debug("scheduleInterface: {}/{} collection, scheduled", (Object)iface, (Object)svcName);
                }
                catch (CollectionInitializationException e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("scheduleInterface: Unable to schedule ");
                    sb.append(iface);
                    sb.append('/');
                    sb.append(svcName);
                    sb.append(", reason: ");
                    sb.append(e.getMessage());
                    if (LOG.isTraceEnabled()) {
                        LOG.trace(sb.toString(), (Throwable)e);
                        continue;
                    }
                    LOG.info(sb.toString());
                }
                catch (Throwable t) {
                    LOG.error("scheduleInterface: Uncaught exception, failed to schedule interface {}/{}.", new Object[]{iface, svcName, t});
                }
            }
        }
        finally {
            Collectd.instrumentation().endScheduleInterface(iface.getNode().getId().intValue(), ipAddress, svcName);
        }
    }

    public Collection<CollectionSpecification> getSpecificationsForInterface(OnmsIpInterface iface, String svcName) {
        LinkedList<CollectionSpecification> matchingPkgs = new LinkedList<CollectionSpecification>();
        CollectdConfiguration collectdConfig = this.m_collectdConfigFactory.getCollectdConfig();
        for (Package wpkg : collectdConfig.getPackages()) {
            if (!wpkg.serviceInPackageAndEnabled(svcName)) {
                LOG.debug("getSpecificationsForInterface: address/service: {}/{} not scheduled, service is not enabled or does not exist in package: {}", new Object[]{iface, svcName, wpkg.getName()});
                continue;
            }
            if (wpkg.isRemote()) {
                LOG.debug("getSpecificationsForInterface: address/service: {}/{} not scheduled, package {} is a remote package.", new Object[]{iface, svcName, wpkg.getName()});
                continue;
            }
            if (!this.m_collectdConfigFactory.interfaceInPackage(iface, wpkg)) {
                LOG.debug("getSpecificationsForInterface: address/service: {}/{} not scheduled, interface does not belong to package: {}", new Object[]{iface, svcName, wpkg.getName()});
                continue;
            }
            LOG.debug("getSpecificationsForInterface: address/service: {}/{} scheduled, interface does belong to package: {}", new Object[]{iface, svcName, wpkg.getName()});
            matchingPkgs.add(new CollectionSpecification(wpkg, svcName, this.getServiceCollector(svcName), Collectd.instrumentation(), this.m_locationAwareCollectorClient, this.pollOutagesDao));
        }
        return matchingPkgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean alreadyScheduled(OnmsIpInterface iface, CollectionSpecification spec) {
        StringBuilder sb;
        String ipAddress = InetAddressUtils.str((InetAddress)iface.getIpAddress());
        if (ipAddress == null) {
            LOG.warn("Cannot determine if interface {} is already scheduled.  Unable to look up IP address.", (Object)iface);
            return false;
        }
        String svcName = spec.getServiceName();
        String pkgName = spec.getPackageName();
        boolean isScheduled = false;
        if (LOG.isDebugEnabled()) {
            sb = new StringBuilder();
            sb.append("alreadyScheduled: determining if interface: ");
            sb.append(iface);
            sb.append(" is already scheduled.");
        }
        List<CollectableService> list = this.m_collectableServices;
        synchronized (list) {
            for (CollectableService cSvc : this.m_collectableServices) {
                InetAddress addr = cSvc.getAddress();
                if (cSvc.getNodeId() != iface.getNode().getId().intValue() || !InetAddressUtils.str((InetAddress)addr).equals(ipAddress) || !cSvc.getPackageName().equals(pkgName) || !cSvc.getServiceName().equals(svcName)) continue;
                isScheduled = true;
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            sb = new StringBuilder();
            sb.append("alreadyScheduled: interface ");
            sb.append(iface);
            sb.append("already scheduled check: ");
            sb.append(isScheduled);
        }
        return isScheduled;
    }

    private void setSchedulingCompleted(boolean schedulingCompleted) {
        this.m_schedulingCompletedFlag.setSchedulingCompleted(schedulingCompleted);
    }

    private void refreshServicePackages() throws CollectionInitializationException {
        for (CollectableService thisService : this.m_collectableServices) {
            thisService.refreshPackage(this.m_collectdConfigFactory);
        }
    }

    protected List<CollectableService> getCollectableServices() {
        return this.m_collectableServices;
    }

    public void onEvent(final IEvent event) {
        Logging.withPrefix((String)this.getName(), () -> this.m_transTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                Collectd.this.onEventInTransaction(event);
            }
        }));
    }

    private void onEventInTransaction(IEvent event) {
        LOG.debug("received event, uei = {}", (Object)event.getUei());
        try {
            if (event.getUei().equals("uei.opennms.org/internal/schedOutagesChanged")) {
                this.handleScheduledOutagesChanged(event);
            } else if (event.getUei().equals("uei.opennms.org/internal/configureSNMP")) {
                this.handleConfigureSNMP(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/nodeGainedService")) {
                this.handleNodeGainedService(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/primarySnmpInterfaceChanged")) {
                this.handlePrimarySnmpInterfaceChanged(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/reinitializePrimarySnmpInterface")) {
                this.handleReinitializePrimarySnmpInterface(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/interfaceReparented")) {
                this.handleInterfaceReparented(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/nodeDeleted")) {
                this.handleNodeDeleted(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/duplicateNodeDeleted")) {
                this.handleDupNodeDeleted(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/interfaceDeleted")) {
                this.handleInterfaceDeleted(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/serviceDeleted")) {
                this.handleServiceDeleted(event);
            } else if (event.getUei().equals("uei.opennms.org/internal/reloadDaemonConfig")) {
                this.handleReloadDaemonConfig(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/nodeCategoryMembershipChanged")) {
                this.handleNodeCategoryMembershipChanged(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/nodeLocationChanged")) {
                this.handleNodeLocationChanged(event);
            }
        }
        catch (InsufficientInformationException e) {
            this.handleInsufficientInfo(e);
        }
    }

    protected void handleInsufficientInfo(InsufficientInformationException e) {
        LOG.info(e.getMessage());
    }

    private void handleDupNodeDeleted(IEvent event) throws InsufficientInformationException {
        this.handleNodeDeleted(event);
    }

    private void handleScheduledOutagesChanged(IEvent event) {
        try {
            LOG.info("Reloading Collectd config factory");
            this.m_collectdConfigFactory.reload();
            this.refreshServicePackages();
        }
        catch (Throwable e) {
            LOG.error("Failed to reload CollectdConfigFactory", e);
        }
    }

    private void deinstallMessageSelectors() {
        this.getEventIpcManager().removeEventListener((EventListener)this);
    }

    private void handleConfigureSNMP(IEvent event) {
        LOG.debug("configureSNMPHandler: processing configure SNMP event...", (Object)event);
        SnmpEventInfo info = null;
        try {
            info = new SnmpEventInfo(event);
            if (StringUtils.isBlank((String)info.getFirstIPAddress())) {
                LOG.error("configureSNMPHandler: event contained invalid firstIpAddress. {}", (Object)event);
                return;
            }
            LOG.debug("configureSNMPHandler: processing configure SNMP event: {}", (Object)info);
            SnmpPeerFactory.getInstance().define(info);
            SnmpPeerFactory.getInstance().saveCurrent();
            LOG.debug("configureSNMPHandler: process complete. {}", (Object)info);
        }
        catch (Throwable e) {
            LOG.error("configureSNMPHandler: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInterfaceDeleted(IEvent event) throws InsufficientInformationException {
        EventUtils.checkNodeId((IEvent)event);
        String ipAddr = event.getInterface();
        if (EventUtils.isNonIpInterface((String)ipAddr)) {
            LOG.debug("handleInterfaceDeleted: the deleted interface was a non-ip interface. Nothing to do here.");
            return;
        }
        Long nodeId = event.getNodeid();
        List<CollectableService> list = this.getCollectableServices();
        synchronized (list) {
            CollectableService cSvc = null;
            ListIterator<CollectableService> liter = this.getCollectableServices().listIterator();
            while (liter.hasNext()) {
                cSvc = liter.next();
                InetAddress addr = cSvc.getAddress();
                if ((long)cSvc.getNodeId() != nodeId || !InetAddrUtils.str((InetAddress)addr).equals(ipAddr)) continue;
                CollectableService collectableService = cSvc;
                synchronized (collectableService) {
                    CollectorUpdates updates = cSvc.getCollectorUpdates();
                    LOG.debug("Marking CollectableService for deletion because an interface was deleted:  Service nodeid={}, deleted node:{}service address:{}deleted interface:{}", new Object[]{cSvc.getNodeId(), nodeId, InetAddrUtils.str((InetAddress)addr), ipAddr});
                    updates.markForDeletion();
                }
                liter.remove();
            }
        }
        LOG.debug("interfaceDeletedHandler: processing of interfaceDeleted event for {}/{} completed", (Object)nodeId, (Object)ipAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInterfaceReparented(IEvent event) throws InsufficientInformationException {
        EventUtils.checkNodeId((IEvent)event);
        EventUtils.checkInterface((IEvent)event);
        LOG.debug("interfaceReparentedHandler:  processing interfaceReparented event for {}", (Object)event.getInterface());
        if (event.getInterface() == null) {
            return;
        }
        String oldNodeIdStr = null;
        String newNodeIdStr = null;
        String parmName = null;
        IValue parmValue = null;
        String parmContent = null;
        for (IParm parm : event.getParmCollection()) {
            parmName = parm.getParmName();
            parmValue = parm.getValue();
            if (parmValue == null) continue;
            parmContent = parmValue.getContent();
            if (parmName.equals("oldNodeID")) {
                oldNodeIdStr = parmContent;
                continue;
            }
            if (!parmName.equals("newNodeID")) continue;
            newNodeIdStr = parmContent;
        }
        if (oldNodeIdStr == null || newNodeIdStr == null) {
            LOG.warn("interfaceReparentedHandler: old and new nodeId parms are required, unable to process.");
            return;
        }
        OnmsIpInterface iface = null;
        List<CollectableService> list = this.getCollectableServices();
        synchronized (list) {
            CollectableService cSvc2 = null;
            for (CollectableService cSvc2 : this.getCollectableServices()) {
                InetAddress addr = cSvc2.getAddress();
                if (!addr.equals(event.getInterfaceAddress())) continue;
                CollectableService collectableService = cSvc2;
                synchronized (collectableService) {
                    LOG.debug("interfaceReparentedHandler: got a CollectableService match for {}", (Object)event.getInterface());
                    CollectorUpdates updates = cSvc2.getCollectorUpdates();
                    if (iface == null) {
                        iface = this.getIpInterface(event.getNodeid().intValue(), event.getInterface());
                    }
                    updates.markForReparenting(oldNodeIdStr, newNodeIdStr, iface);
                    LOG.debug("interfaceReparentedHandler: marking {} for reparenting for service SNMP.", (Object)event.getInterface());
                }
            }
        }
        LOG.debug("interfaceReparentedHandler: processing of interfaceReparented event for interface {} completed.", (Object)event.getInterface());
    }

    private void handleNodeDeleted(IEvent event) throws InsufficientInformationException {
        EventUtils.checkNodeId((IEvent)event);
        Long nodeId = event.getNodeid();
        this.unscheduleNodeAndMarkForDeletion(nodeId);
        LOG.debug("nodeDeletedHandler: processing of nodeDeleted event for nodeid {} completed.", (Object)nodeId);
    }

    private void handleNodeCategoryMembershipChanged(IEvent event) throws InsufficientInformationException {
        EventUtils.checkNodeId((IEvent)event);
        Long nodeId = event.getNodeid();
        this.unscheduleNodeAndMarkForDeletion(nodeId);
        LOG.debug("nodeCategoryMembershipChanged: unscheduling nodeid {} completed.", (Object)nodeId);
        this.scheduleNode(nodeId.intValue(), true);
    }

    private void handleNodeLocationChanged(IEvent event) throws InsufficientInformationException {
        EventUtils.checkNodeId((IEvent)event);
        Long nodeId = event.getNodeid();
        this.unscheduleNodeAndMarkForDeletion(nodeId);
        LOG.debug("nodeLocationChanged: unscheduling nodeid {} completed.", (Object)nodeId);
        this.scheduleNode(nodeId.intValue(), true);
    }

    private void rebuildScheduler() {
        HashSet<String> configuredCollectors = new HashSet<String>();
        for (Object collector : this.m_collectdConfigFactory.getCollectdConfig().getCollectors()) {
            String svcName = collector.getService();
            configuredCollectors.add(svcName);
            if (this.getServiceCollector(svcName) != null) continue;
            try {
                LOG.debug("rebuildScheduler: Loading collector {}, classname {}", (Object)svcName, (Object)collector.getClassName());
                Class<?> cc = Class.forName(collector.getClassName());
                ServiceCollector sc = (ServiceCollector)cc.newInstance();
                sc.initialize();
                this.setServiceCollector(svcName, sc);
            }
            catch (Throwable t) {
                LOG.warn("rebuildScheduler: Failed to load collector {} for service {}", new Object[]{collector.getClassName(), svcName, t});
            }
        }
        ArrayList<String> blackList = new ArrayList<String>();
        for (String collectorName : this.getCollectorNames()) {
            if (configuredCollectors.contains(collectorName)) continue;
            blackList.add(collectorName);
        }
        for (String collectorName : blackList) {
            LOG.info("rebuildScheduler: removing collector for {}, it is no longer required", (Object)collectorName);
            this.m_collectors.remove(collectorName);
        }
        Collection nodeIds = this.m_nodeDao.getNodeIds();
        this.m_filterDao.flushActiveIpAddressListCache();
        for (Integer nodeId : nodeIds) {
            this.unscheduleNodeAndMarkForDeletion(new Long(nodeId.intValue()));
            this.scheduleNode(nodeId, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unscheduleNodeAndMarkForDeletion(Long nodeId) {
        List<CollectableService> list = this.getCollectableServices();
        synchronized (list) {
            CollectableService cSvc = null;
            ListIterator<CollectableService> liter = this.getCollectableServices().listIterator();
            while (liter.hasNext()) {
                cSvc = liter.next();
                if ((long)cSvc.getNodeId() != nodeId) continue;
                CollectableService collectableService = cSvc;
                synchronized (collectableService) {
                    CollectorUpdates updates = cSvc.getCollectorUpdates();
                    LOG.debug("Marking CollectableService for deletion because a node was deleted:  Service nodeid={}, deleted node:{}", (Object)cSvc.getNodeId(), (Object)nodeId);
                    updates.markForDeletion();
                }
                liter.remove();
            }
        }
    }

    private void handleNodeGainedService(IEvent event) throws InsufficientInformationException {
        EventUtils.checkNodeId((IEvent)event);
        EventUtils.checkInterface((IEvent)event);
        EventUtils.checkService((IEvent)event);
        this.scheduleForCollection(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReloadDaemonConfig(IEvent event) {
        String collectionDaemonName = "Collectd";
        boolean isCollection = false;
        for (IParm parm : event.getParmCollection()) {
            if (!"daemonName".equals(parm.getParmName()) || !"Collectd".equalsIgnoreCase(parm.getValue().getContent())) continue;
            isCollection = true;
            break;
        }
        if (isCollection) {
            String targetFile = ConfigFileConstants.getFileName((int)ConfigFileConstants.DATA_COLLECTION_CONF_FILE_NAME);
            boolean isDataCollectionConfig = false;
            for (IParm parm : event.getParmCollection()) {
                if (!"configFile".equals(parm.getParmName()) || !targetFile.equalsIgnoreCase(parm.getValue().getContent())) continue;
                isDataCollectionConfig = true;
                break;
            }
            EventBuilder ebldr = null;
            if (isDataCollectionConfig) {
                try {
                    DataCollectionConfigFactory.reload();
                    ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", "Collectd");
                    ebldr.addParam("daemonName", "Collectd");
                    ebldr.addParam("configFile", targetFile);
                }
                catch (Throwable e) {
                    LOG.error("handleReloadDaemonConfig: Error reloading/processing datacollection configuration: {}", (Object)e.getMessage(), (Object)e);
                    ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", "Collectd");
                    ebldr.addParam("daemonName", "Collectd");
                    ebldr.addParam("configFile", targetFile);
                    ebldr.addParam("reason", e.getMessage());
                }
                finally {
                    if (ebldr != null) {
                        this.getEventIpcManager().sendNow(ebldr.getEvent());
                    }
                }
            } else {
                String cfgFile = ConfigFileConstants.getFileName((int)ConfigFileConstants.COLLECTD_CONFIG_FILE_NAME);
                try {
                    this.m_collectdConfigFactory.reload();
                    this.rebuildScheduler();
                    ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", "Collectd");
                    ebldr.addParam("daemonName", "Collectd");
                    ebldr.addParam("configFile", cfgFile);
                }
                catch (Throwable e) {
                    LOG.error("handleReloadDaemonConfig: Error reloading/processing collectd configuration: {}", (Object)e.getMessage(), (Object)e);
                    ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", "Collectd");
                    ebldr.addParam("daemonName", "Collectd");
                    ebldr.addParam("configFile", cfgFile);
                    ebldr.addParam("reason", e.getMessage());
                }
                finally {
                    if (ebldr != null) {
                        this.getEventIpcManager().sendNow(ebldr.getEvent());
                    }
                }
            }
        }
    }

    private void scheduleForCollection(IEvent event) {
        this.m_filterDao.flushActiveIpAddressListCache();
        this.scheduleInterface(event.getNodeid().intValue(), event.getInterface(), event.getService(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePrimarySnmpInterfaceChanged(IEvent event) throws InsufficientInformationException {
        EventUtils.checkNodeId((IEvent)event);
        EventUtils.checkInterface((IEvent)event);
        LOG.debug("primarySnmpInterfaceChangedHandler:  processing primary SNMP interface changed event...");
        if (!event.getService().equals("SNMP")) {
            return;
        }
        String oldPrimaryIfAddr = null;
        String parmName = null;
        IValue parmValue = null;
        String parmContent = null;
        for (IParm parm : event.getParmCollection()) {
            parmName = parm.getParmName();
            parmValue = parm.getValue();
            if (parmValue == null) continue;
            parmContent = parmValue.getContent();
            if (!parmName.equals("oldPrimarySnmpAddress")) continue;
            oldPrimaryIfAddr = parmContent;
        }
        if (oldPrimaryIfAddr != null) {
            List<CollectableService> list = this.getCollectableServices();
            synchronized (list) {
                CollectableService cSvc = null;
                ListIterator<CollectableService> liter = this.getCollectableServices().listIterator();
                while (liter.hasNext()) {
                    cSvc = liter.next();
                    InetAddress addr = cSvc.getAddress();
                    String addrString = InetAddressUtils.str((InetAddress)addr);
                    if (addrString == null || !addrString.equals(oldPrimaryIfAddr)) continue;
                    CollectableService collectableService = cSvc;
                    synchronized (collectableService) {
                        CollectorUpdates updates = cSvc.getCollectorUpdates();
                        updates.markForDeletion();
                        LOG.debug("primarySnmpInterfaceChangedHandler: marking {} as deleted for service SNMP.", (Object)oldPrimaryIfAddr);
                    }
                    liter.remove();
                }
            }
        }
        this.scheduleForCollection(event);
        LOG.debug("primarySnmpInterfaceChangedHandler: processing of primarySnmpInterfaceChanged event for nodeid {} completed.", (Object)event.getNodeid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReinitializePrimarySnmpInterface(IEvent event) throws InsufficientInformationException {
        EventUtils.checkNodeId((IEvent)event);
        EventUtils.checkInterface((IEvent)event);
        Long nodeid = event.getNodeid();
        String ipAddress = event.getInterface();
        OnmsIpInterface iface = null;
        List<CollectableService> list = this.getCollectableServices();
        synchronized (list) {
            for (CollectableService cSvc : this.getCollectableServices()) {
                InetAddress addr = cSvc.getAddress();
                String addrString = InetAddressUtils.str((InetAddress)addr);
                LOG.debug("Comparing CollectableService ip address = {} and event ip interface = {}", (Object)addrString, (Object)ipAddress);
                if (addrString == null || !addrString.equals(ipAddress) || cSvc.getNodeId() != nodeid.intValue()) continue;
                CollectableService collectableService = cSvc;
                synchronized (collectableService) {
                    if (iface == null) {
                        iface = this.getIpInterface(nodeid.intValue(), ipAddress);
                    }
                    CollectorUpdates updates = cSvc.getCollectorUpdates();
                    updates.markForReinitialization(iface);
                    LOG.debug("reinitializePrimarySnmpInterfaceHandler: marking {} for reinitialization for service SNMP.", (Object)ipAddress);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleServiceDeleted(IEvent event) throws InsufficientInformationException {
        EventUtils.checkNodeId((IEvent)event);
        EventUtils.checkInterface((IEvent)event);
        EventUtils.checkService((IEvent)event);
        Long nodeId = event.getNodeid();
        String ipAddr = event.getInterface();
        String svcName = event.getService();
        List<CollectableService> list = this.getCollectableServices();
        synchronized (list) {
            CollectableService cSvc = null;
            ListIterator<CollectableService> liter = this.getCollectableServices().listIterator();
            while (liter.hasNext()) {
                cSvc = liter.next();
                InetAddress addr = cSvc.getAddress();
                if ((long)cSvc.getNodeId() != nodeId || !InetAddrUtils.str((InetAddress)addr).equals(ipAddr) || !cSvc.getServiceName().equals(svcName)) continue;
                CollectableService collectableService = cSvc;
                synchronized (collectableService) {
                    CollectorUpdates updates = cSvc.getCollectorUpdates();
                    LOG.debug("Marking CollectableService for deletion because a service was deleted:  Service nodeid={}, deleted node:{}, service address:{}, deleted interface:{}, service servicename:{}, deleted service name:{}, event source {}", new Object[]{cSvc.getNodeId(), nodeId, InetAddrUtils.str((InetAddress)addr), ipAddr, cSvc.getServiceName(), svcName, event.getSource()});
                    updates.markForDeletion();
                }
                liter.remove();
            }
        }
        LOG.debug("serviceDeletedHandler: processing of serviceDeleted event for {}/{}/{} completed.", new Object[]{nodeId, ipAddr, svcName});
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public Scheduler getScheduler() {
        if (this.m_scheduler == null) {
            this.createScheduler();
        }
        return this.m_scheduler;
    }

    void setCollectdConfigFactory(CollectdConfigFactory collectdConfigFactory) {
        this.m_collectdConfigFactory = collectdConfigFactory;
    }

    void setIpInterfaceDao(IpInterfaceDao ifSvcDao) {
        this.m_ifaceDao = ifSvcDao;
    }

    void setFilterDao(FilterDao dao) {
        this.m_filterDao = dao;
    }

    public void setServiceCollectorRegistry(ServiceCollectorRegistry serviceCollectorRegistry) {
        this.m_serviceCollectorRegistry = serviceCollectorRegistry;
    }

    public void setLocationAwareCollectorClient(LocationAwareCollectorClient locationAwareCollectorClient) {
        this.m_locationAwareCollectorClient = locationAwareCollectorClient;
    }

    void setTransactionTemplate(TransactionTemplate transTemplate) {
        this.m_transTemplate = transTemplate;
    }

    void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public void setServiceCollector(String svcName, ServiceCollector collector) {
        this.m_collectors.put(svcName, collector);
    }

    public ServiceCollector getServiceCollector(String svcName) {
        return this.m_collectors.get(svcName);
    }

    public PersisterFactory getPersisterFactory() {
        return this.m_persisterFactory;
    }

    public void setPersisterFactory(PersisterFactory persisterFactory) {
        this.m_persisterFactory = persisterFactory;
    }

    public Set<String> getCollectorNames() {
        return this.m_collectors.keySet();
    }

    private void instantiateCollectors() {
        LOG.debug("instantiateCollectors: Loading collectors");
        List collectors = this.m_collectdConfigFactory.getCollectdConfig().getCollectors();
        for (Collector collector : collectors) {
            String svcName = collector.getService();
            try {
                LOG.debug("instantiateCollectors: Loading collector {}, classname {}", (Object)svcName, (Object)collector.getClassName());
                ServiceCollector sc = this.m_serviceCollectorRegistry.getCollectorByClassName(collector.getClassName());
                if (sc == null) {
                    throw new IllegalArgumentException(String.format("No collector found with class name '%s'. Available collectors include: %s", collector.getClassName(), this.m_serviceCollectorRegistry.getCollectorClassNames()));
                }
                sc.initialize();
                this.setServiceCollector(svcName, sc);
            }
            catch (Throwable t) {
                LOG.warn("instantiateCollectors: Failed to load collector {} for service {}", new Object[]{collector.getClassName(), svcName, t});
            }
        }
    }

    public static String getLoggingCategory() {
        return LOG4J_CATEGORY;
    }

    public long getCollectableServiceCount() {
        return this.m_collectableServices.size();
    }

    @VisibleForTesting
    public void setPollOutagesDao(ReadablePollOutagesDao pollOutagesDao) {
        this.pollOutagesDao = Objects.requireNonNull(pollOutagesDao);
    }

    static class SchedulingCompletedFlag {
        volatile boolean m_schedulingCompleted = false;

        SchedulingCompletedFlag() {
        }

        public synchronized void setSchedulingCompleted(boolean schedulingCompleted) {
            this.m_schedulingCompleted = schedulingCompleted;
        }

        public synchronized boolean isSchedulingCompleted() {
            return this.m_schedulingCompleted;
        }
    }
}

