/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.joesnmp;

import java.net.SocketException;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpException;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.opennms.netmgt.snmp.joesnmp.JoeSnmpAgentConfig;
import org.opennms.netmgt.snmp.joesnmp.JoeSnmpValue;
import org.opennms.protocols.snmp.SnmpHandler;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpPduBulk;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpSMI;
import org.opennms.protocols.snmp.SnmpSession;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpVarBind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoeSnmpWalker
extends SnmpWalker {
    private static final transient Logger LOG = LoggerFactory.getLogger(JoeSnmpWalker.class);
    private JoeSnmpResponseHandler m_handler;
    private SnmpPeer m_peer;
    private SnmpSession m_session;
    private JoeSnmpAgentConfig m_agentConfig;

    public JoeSnmpWalker(JoeSnmpAgentConfig agentConfig, String name, CollectionTracker tracker) {
        super(agentConfig.getAddress(), name, agentConfig.getMaxVarsPerPdu(), agentConfig.getMaxRepetitions(), agentConfig.getRetries(), tracker);
        this.m_agentConfig = agentConfig;
        this.m_peer = this.getPeer(agentConfig);
        this.m_handler = new JoeSnmpResponseHandler();
    }

    private SnmpPeer getPeer(JoeSnmpAgentConfig agentConfig) {
        SnmpPeer peer = new SnmpPeer(agentConfig.getAddress());
        peer.getParameters().setVersion(agentConfig.getVersion());
        peer.getParameters().setReadCommunity(agentConfig.getReadCommunity());
        peer.getParameters().setVersion(agentConfig.getVersion());
        peer.setPort(agentConfig.getPort());
        peer.setRetries(agentConfig.getRetries());
        peer.setTimeout(agentConfig.getTimeout());
        return peer;
    }

    public void start() {
        LOG.debug("Walking {} for {} using version {} with config: {}", new Object[]{this.getName(), this.getAddress(), SnmpSMI.getVersionString((int)this.getVersion()), this.m_agentConfig});
        super.start();
    }

    protected SnmpWalker.WalkerPduBuilder createPduBuilder(int maxVarsPerPdu) {
        return this.getVersion() == 0 ? new GetNextBuilder(maxVarsPerPdu) : new GetBulkBuilder(maxVarsPerPdu);
    }

    protected void sendNextPdu(SnmpWalker.WalkerPduBuilder pduBuilder) throws SnmpException {
        JoeSnmpPduBuilder joePduBuilder = (JoeSnmpPduBuilder)pduBuilder;
        if (this.m_session == null) {
            try {
                this.m_session = new SnmpSession(this.m_peer);
            }
            catch (SocketException e) {
                throw new SnmpException("Failed to create session to peer " + this.m_peer.toString(), (Throwable)e);
            }
        }
        LOG.debug("Sending tracker pdu of size {}", (Object)joePduBuilder.getPdu().getLength());
        this.m_session.send(joePduBuilder.getPdu(), (SnmpHandler)this.m_handler);
    }

    protected int getVersion() {
        return this.m_peer.getParameters().getVersion();
    }

    public void close() {
        if (this.m_session != null) {
            this.m_session.close();
            this.m_session = null;
        }
    }

    public class JoeSnmpResponseHandler
    implements SnmpHandler {
        public void snmpReceivedPdu(SnmpSession session, int command, SnmpPduPacket pdu) {
            try {
                SnmpPduRequest response = (SnmpPduRequest)pdu;
                LOG.debug("Received a tracker pdu from {} of size {} errorStatus = {}, errorIndex = {}", new Object[]{JoeSnmpWalker.this.getAddress(), pdu.getLength(), response.getErrorStatus(), response.getErrorIndex()});
                if (!JoeSnmpWalker.this.processErrors(response.getErrorStatus(), response.getErrorIndex())) {
                    for (int i = 0; i < response.getLength(); ++i) {
                        SnmpVarBind vb = response.getVarBindAt(i);
                        SnmpObjId receivedOid = SnmpObjId.get((int[])vb.getName().getIdentifiers());
                        JoeSnmpValue val = new JoeSnmpValue(vb.getValue());
                        JoeSnmpWalker.this.processResponse(receivedOid, (SnmpValue)val);
                    }
                }
                JoeSnmpWalker.this.buildAndSendNextPdu();
            }
            catch (Throwable e) {
                JoeSnmpWalker.this.handleFatalError(e);
            }
        }

        public void snmpInternalError(SnmpSession session, int err, SnmpSyntax pdu) {
            JoeSnmpWalker.this.handleError(JoeSnmpWalker.this.getName() + ": snmpInternalError: " + err + " for: " + JoeSnmpWalker.this.getAddress());
        }

        public void snmpTimeoutError(SnmpSession session, SnmpSyntax pdu) {
            JoeSnmpWalker.this.handleTimeout(JoeSnmpWalker.this.getName() + ": snmpTimeoutError for: " + JoeSnmpWalker.this.getAddress());
        }
    }

    public class GetBulkBuilder
    extends JoeSnmpPduBuilder {
        private SnmpPduBulk m_bulkPdu;

        public GetBulkBuilder(int maxVarsPerPdu) {
            super(maxVarsPerPdu);
            this.reset();
        }

        public void reset() {
            this.m_bulkPdu = new SnmpPduBulk();
            this.m_bulkPdu.setRequestId(SnmpPduPacket.nextSequence());
        }

        @Override
        public SnmpPduPacket getPdu() {
            return this.m_bulkPdu;
        }

        public void addOid(SnmpObjId snmpObjId) {
            SnmpVarBind varBind = new SnmpVarBind(new SnmpObjectId(snmpObjId.getIds()));
            this.m_bulkPdu.addVarBind(varBind);
        }

        public void setNonRepeaters(int numNonRepeaters) {
            this.m_bulkPdu.setNonRepeaters(numNonRepeaters);
        }

        public void setMaxRepetitions(int maxRepetitions) {
            this.m_bulkPdu.setMaxRepititions(maxRepetitions);
        }
    }

    public static class GetNextBuilder
    extends JoeSnmpPduBuilder {
        private SnmpPduRequest m_nextPdu = null;

        private GetNextBuilder(int maxVarsPerPdu) {
            super(maxVarsPerPdu);
            this.reset();
        }

        public void reset() {
            this.m_nextPdu = new SnmpPduRequest(161);
            this.m_nextPdu.setRequestId(SnmpPduPacket.nextSequence());
        }

        @Override
        public SnmpPduPacket getPdu() {
            return this.m_nextPdu;
        }

        public void addOid(SnmpObjId snmpObjId) {
            SnmpVarBind varBind = new SnmpVarBind(new SnmpObjectId(snmpObjId.getIds()));
            this.m_nextPdu.addVarBind(varBind);
        }

        public void setNonRepeaters(int numNonRepeaters) {
        }

        public void setMaxRepetitions(int maxRepetitions) {
        }
    }

    public static abstract class JoeSnmpPduBuilder
    extends SnmpWalker.WalkerPduBuilder {
        public JoeSnmpPduBuilder(int maxVarsPerPdu) {
            super(maxVarsPerPdu);
        }

        public abstract SnmpPduPacket getPdu();
    }
}

