/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.Type;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OnmsNode;

@Entity
@Table(name="bridgeStpLink")
@Filter(name="authorizedOnly", condition="exists (select distinct x.nodeid from node x join category_node cn on x.nodeid = cn.nodeid join category_group cg on cn.categoryId = cg.categoryId where x.nodeid = nodeid and cg.groupId in (:userGroups))")
public class BridgeStpLink
implements Serializable {
    private static final long serialVersionUID = -5550390569444249173L;
    private Integer m_id;
    private OnmsNode m_node;
    private Integer m_stpPort;
    private Integer m_stpPortPriority;
    private BridgeDot1dStpPortState m_stpPortState;
    private BridgeDot1dStpPortEnable m_stpPortEnable;
    private Integer m_stpPortPathCost;
    private Integer m_designatedCost;
    private String m_designatedRoot;
    private String m_designatedBridge;
    private String m_designatedPort;
    private Date m_bridgeStpLinkCreateTime = new Date();
    private Date m_bridgeStpLinkLastPollTime;
    private Integer m_stpPortIfIndex;
    private String m_stpPortIfName;
    private Integer m_vlan;

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @Column(name="stpPort", nullable=false)
    public Integer getStpPort() {
        return this.m_stpPort;
    }

    public void setStpPort(Integer bridgePort) {
        this.m_stpPort = bridgePort;
    }

    @Column(name="stpPortPriority", nullable=false)
    public Integer getStpPortPriority() {
        return this.m_stpPortPriority;
    }

    public void setStpPortPriority(Integer stpPortPriority) {
        this.m_stpPortPriority = stpPortPriority;
    }

    @Column(name="stpPortState", nullable=false)
    @Type(type="org.opennms.netmgt.enlinkd.model.BridgeDot1dStpPortStateUserType")
    public BridgeDot1dStpPortState getStpPortState() {
        return this.m_stpPortState;
    }

    public void setStpPortState(BridgeDot1dStpPortState stpPortState) {
        this.m_stpPortState = stpPortState;
    }

    @Column(name="stpPortEnable", nullable=false)
    @Type(type="org.opennms.netmgt.enlinkd.model.BridgeDot1dStpPortEnableUserType")
    public BridgeDot1dStpPortEnable getStpPortEnable() {
        return this.m_stpPortEnable;
    }

    public void setStpPortEnable(BridgeDot1dStpPortEnable stpPortEnable) {
        this.m_stpPortEnable = stpPortEnable;
    }

    @Column(name="stpPortPathCost", nullable=false)
    public Integer getStpPortPathCost() {
        return this.m_stpPortPathCost;
    }

    public void setStpPortPathCost(Integer stpPortPathCost) {
        this.m_stpPortPathCost = stpPortPathCost;
    }

    @Column(name="stpPortIfIndex", nullable=true)
    public Integer getStpPortIfIndex() {
        return this.m_stpPortIfIndex;
    }

    public void setStpPortIfIndex(Integer bridgePortIfIndex) {
        this.m_stpPortIfIndex = bridgePortIfIndex;
    }

    @Column(name="stpPortIfName", length=32, nullable=true)
    public String getStpPortIfName() {
        return this.m_stpPortIfName;
    }

    public void setStpPortIfName(String bridgePortIfName) {
        this.m_stpPortIfName = bridgePortIfName;
    }

    @Column(name="vlan", nullable=true)
    public Integer getVlan() {
        return this.m_vlan;
    }

    public void setVlan(Integer vlan) {
        this.m_vlan = vlan;
    }

    @Column(name="designatedRoot", length=16, nullable=false)
    public String getDesignatedRoot() {
        return this.m_designatedRoot;
    }

    @Transient
    public String getDesignatedRootAddress() {
        return InetAddressUtils.getBridgeAddressFromStpBridgeId((String)this.m_designatedRoot);
    }

    public void setDesignatedRoot(String designatedRoot) {
        this.m_designatedRoot = designatedRoot;
    }

    @Column(name="designatedCost", nullable=false)
    public Integer getDesignatedCost() {
        return this.m_designatedCost;
    }

    public void setDesignatedCost(Integer designatedCost) {
        this.m_designatedCost = designatedCost;
    }

    @Column(name="designatedBridge", length=16, nullable=true)
    public String getDesignatedBridge() {
        return this.m_designatedBridge;
    }

    @Transient
    public String getDesignatedBridgeAddress() {
        return InetAddressUtils.getBridgeAddressFromStpBridgeId((String)this.m_designatedBridge);
    }

    public void setDesignatedBridge(String macAddress) {
        this.m_designatedBridge = macAddress;
    }

    @Column(name="designatedPort", length=4, nullable=false)
    public String getDesignatedPort() {
        return this.m_designatedPort;
    }

    @Transient
    public int getDesignatedBridgePortNum() {
        return InetAddressUtils.getBridgeDesignatedPortNumber((String)this.m_designatedPort);
    }

    public void setDesignatedPort(String bridgePort) {
        this.m_designatedPort = bridgePort;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="bridgeStpLinkCreateTime", nullable=false)
    public Date getBridgeStpLinkCreateTime() {
        return this.m_bridgeStpLinkCreateTime;
    }

    public void setBridgeStpLinkCreateTime(Date bridgeLinkCreateTime) {
        this.m_bridgeStpLinkCreateTime = bridgeLinkCreateTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="bridgeStpLinkLastPollTime", nullable=false)
    public Date getBridgeStpLinkLastPollTime() {
        return this.m_bridgeStpLinkLastPollTime;
    }

    public void setBridgeStpLinkLastPollTime(Date bridgeLinkLastPollTime) {
        this.m_bridgeStpLinkLastPollTime = bridgeLinkLastPollTime;
    }

    public String toString() {
        Integer nodeid = null;
        if (this.m_node != null) {
            nodeid = this.m_node.getId();
        }
        return new ToStringBuilder((Object)this).append("Nodeid", (Object)nodeid).append("stpPortState", (Object)this.m_stpPortState).append("stpPortEnable", (Object)this.m_stpPortEnable).append("stpPort", (Object)this.m_stpPort).append("stpPortIfIndex", (Object)this.m_stpPortIfIndex).append("stpPortIfName", (Object)this.m_stpPortIfName).append("vlan", (Object)this.m_vlan).append("designatedRoot", (Object)this.m_designatedRoot).append("designatedCost", (Object)this.m_designatedCost).append("designatedBridge", (Object)this.m_designatedBridge).append("designatedPort", (Object)this.m_designatedPort).append("m_bridgeStpLinkCreateTime", (Object)this.m_bridgeStpLinkCreateTime).append("m_bridgeStpLinkLastPollTime", (Object)this.m_bridgeStpLinkLastPollTime).toString();
    }

    public void merge(BridgeStpLink element) {
        if (element == null) {
            return;
        }
        this.setStpPortState(element.getStpPortState());
        this.setStpPortEnable(element.getStpPortEnable());
        this.setStpPortIfIndex(element.getStpPortIfIndex());
        this.setStpPortIfName(element.getStpPortIfName());
        this.setVlan(element.getVlan());
        this.setDesignatedRoot(element.getDesignatedRoot());
        this.setDesignatedCost(element.getDesignatedCost());
        this.setDesignatedBridge(element.getDesignatedBridge());
        this.setDesignatedPort(element.getDesignatedPort());
        this.setBridgeStpLinkLastPollTime(element.getBridgeStpLinkCreateTime());
    }

    public static enum BridgeDot1dStpPortEnable {
        DOT1D_STP_PORT_ENABLED(1),
        DOT1D_STP_PORT_DISABLED(2);

        private int m_type;
        private static final Map<Integer, String> s_stpPortenableMap;

        private BridgeDot1dStpPortEnable(int type) {
            this.m_type = type;
        }

        public static String getTypeString(Integer code) {
            if (s_stpPortenableMap.containsKey(code)) {
                return s_stpPortenableMap.get(code);
            }
            return null;
        }

        public Integer getValue() {
            return this.m_type;
        }

        public static BridgeDot1dStpPortEnable get(Integer code) {
            if (code == null) {
                throw new IllegalArgumentException("Cannot create Dot1dStpPortEnable from null code");
            }
            switch (code) {
                case 1: {
                    return DOT1D_STP_PORT_ENABLED;
                }
                case 2: {
                    return DOT1D_STP_PORT_DISABLED;
                }
            }
            throw new IllegalArgumentException("Cannot create Dot1dStpPortEnable from code " + code);
        }

        static {
            s_stpPortenableMap = new HashMap<Integer, String>();
            s_stpPortenableMap.put(1, "enabled");
            s_stpPortenableMap.put(2, "disabled");
        }
    }

    public static enum BridgeDot1dStpPortState {
        DOT1D_STP_PORT_STATUS_DISABLED(1),
        DOT1D_STP_PORT_STATUS_BLOCKING(2),
        DOT1D_STP_PORT_STATUS_LISTENING(3),
        DOT1D_STP_PORT_STATUS_LEARNING(4),
        DOT1D_STP_PORT_STATUS_FORWARDING(5),
        DOT1D_STP_PORT_STATUS_BROKEN(6);

        private int m_type;
        private static final Map<Integer, String> s_stpPortStatusMap;

        private BridgeDot1dStpPortState(int type) {
            this.m_type = type;
        }

        public static String getTypeString(Integer code) {
            if (s_stpPortStatusMap.containsKey(code)) {
                return s_stpPortStatusMap.get(code);
            }
            return null;
        }

        public Integer getValue() {
            return this.m_type;
        }

        public static BridgeDot1dStpPortState get(Integer code) {
            if (code == null) {
                throw new IllegalArgumentException("Cannot create Dot1dStpPortState from null code");
            }
            switch (code) {
                case 1: {
                    return DOT1D_STP_PORT_STATUS_DISABLED;
                }
                case 2: {
                    return DOT1D_STP_PORT_STATUS_BLOCKING;
                }
                case 3: {
                    return DOT1D_STP_PORT_STATUS_LISTENING;
                }
                case 4: {
                    return DOT1D_STP_PORT_STATUS_LEARNING;
                }
                case 5: {
                    return DOT1D_STP_PORT_STATUS_FORWARDING;
                }
                case 6: {
                    return DOT1D_STP_PORT_STATUS_BROKEN;
                }
            }
            throw new IllegalArgumentException("Cannot create Dot1dStpPortState from code " + code);
        }

        static {
            s_stpPortStatusMap = new HashMap<Integer, String>();
            s_stpPortStatusMap.put(1, "disabled");
            s_stpPortStatusMap.put(2, "blocking");
            s_stpPortStatusMap.put(3, "listening");
            s_stpPortStatusMap.put(4, "learning");
            s_stpPortStatusMap.put(5, "forwarding");
            s_stpPortStatusMap.put(6, "broken");
        }
    }
}

