/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.Type;
import org.opennms.netmgt.model.OnmsNode;

@Entity
@Table(name="bridgeElement")
@Filter(name="authorizedOnly", condition="exists (select distinct x.nodeid from node x join category_node cn on x.nodeid = cn.nodeid join category_group cg on cn.categoryId = cg.categoryId where x.nodeid = nodeid and cg.groupId in (:userGroups))")
public class BridgeElement
implements Serializable {
    private static final long serialVersionUID = -3137257592300016141L;
    private Integer m_id;
    private OnmsNode m_node;
    private String m_baseBridgeAddress;
    private Integer m_baseNumPorts;
    private BridgeDot1dBaseType m_baseType;
    private BridgeDot1dStpProtocolSpecification m_stpProtocolSpecification;
    private Integer m_stpPriority;
    private String m_stpDesignatedRoot;
    private Integer m_stpRootCost;
    private Integer m_stpRootPort;
    private Integer m_vlan;
    private String m_vlanname;
    private Date m_bridgeNodeCreateTime = new Date();
    private Date m_bridgeNodeLastPollTime;

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @Column(name="baseBridgeAddress", length=12, nullable=false)
    public String getBaseBridgeAddress() {
        return this.m_baseBridgeAddress;
    }

    public void setBaseBridgeAddress(String baseBridgeAddress) {
        this.m_baseBridgeAddress = baseBridgeAddress;
    }

    @Column(name="baseNumPorts", nullable=false)
    public Integer getBaseNumPorts() {
        return this.m_baseNumPorts;
    }

    public void setBaseNumPorts(Integer baseNumPorts) {
        this.m_baseNumPorts = baseNumPorts;
    }

    @Column(name="baseType", nullable=false)
    @Type(type="org.opennms.netmgt.enlinkd.model.BridgeDot1dBaseTypeUserType")
    public BridgeDot1dBaseType getBaseType() {
        return this.m_baseType;
    }

    public void setBaseType(BridgeDot1dBaseType baseType) {
        this.m_baseType = baseType;
    }

    @Column(name="vlan", nullable=true)
    public Integer getVlan() {
        return this.m_vlan;
    }

    public void setVlan(Integer vlan) {
        this.m_vlan = vlan;
    }

    @Column(name="vlanname", length=64, nullable=true)
    public String getVlanname() {
        return this.m_vlanname;
    }

    public void setVlanname(String vlanname) {
        this.m_vlanname = vlanname;
    }

    @Column(name="stpProtocolSpecification", nullable=true)
    @Type(type="org.opennms.netmgt.enlinkd.model.BridgeDot1dStpProtocolSpecificationUserType")
    public BridgeDot1dStpProtocolSpecification getStpProtocolSpecification() {
        return this.m_stpProtocolSpecification;
    }

    public void setStpProtocolSpecification(BridgeDot1dStpProtocolSpecification stpProtocolSpecification) {
        this.m_stpProtocolSpecification = stpProtocolSpecification;
    }

    @Column(name="stpPriority", nullable=true)
    public Integer getStpPriority() {
        return this.m_stpPriority;
    }

    public void setStpPriority(Integer stpPriority) {
        this.m_stpPriority = stpPriority;
    }

    @Column(name="stpDesignatedRoot", length=16, nullable=true)
    public String getStpDesignatedRoot() {
        return this.m_stpDesignatedRoot;
    }

    public void setStpDesignatedRoot(String stpDesignatedRoot) {
        this.m_stpDesignatedRoot = stpDesignatedRoot;
    }

    @Column(name="stpRootCost", nullable=true)
    public Integer getStpRootCost() {
        return this.m_stpRootCost;
    }

    public void setStpRootCost(Integer stpRootCost) {
        this.m_stpRootCost = stpRootCost;
    }

    @Column(name="stpRootPort", nullable=true)
    public Integer getStpRootPort() {
        return this.m_stpRootPort;
    }

    public void setStpRootPort(Integer stpRootPort) {
        this.m_stpRootPort = stpRootPort;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="bridgeNodeCreateTime", nullable=false)
    public Date getBridgeNodeCreateTime() {
        return this.m_bridgeNodeCreateTime;
    }

    public void setBridgeNodeCreateTime(Date bridgeNodeCreateTime) {
        this.m_bridgeNodeCreateTime = bridgeNodeCreateTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="bridgeNodeLastPollTime", nullable=false)
    public Date getBridgeNodeLastPollTime() {
        return this.m_bridgeNodeLastPollTime;
    }

    public void setBridgeNodeLastPollTime(Date bridgeNodeLastPollTime) {
        this.m_bridgeNodeLastPollTime = bridgeNodeLastPollTime;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("Nodeid", (Object)this.m_node.getId()).append("baseBridgeAddress", (Object)this.m_baseBridgeAddress).append("baseNumPorts", (Object)this.m_baseNumPorts).append("baseType", (Object)BridgeDot1dBaseType.getTypeString(this.m_baseType.getValue())).append("stpProtocolSpecification", (Object)this.m_stpProtocolSpecification).append("stpPriority", (Object)this.m_stpPriority).append("stpDesignatedRoot", (Object)this.m_stpDesignatedRoot).append("stpRootCost", (Object)this.m_stpRootCost).append("m_stpRootPort", (Object)this.m_stpRootPort).append("vlan", (Object)this.m_vlan).append("vlanname", (Object)this.m_vlanname).append("m_bridgeNodeCreateTime", (Object)this.m_bridgeNodeCreateTime).append("m_bridgeNodeLastPollTime", (Object)this.m_bridgeNodeLastPollTime).toString();
    }

    public void merge(BridgeElement element) {
        if (element == null) {
            return;
        }
        this.setBaseBridgeAddress(element.getBaseBridgeAddress());
        this.setBaseNumPorts(element.getBaseNumPorts());
        this.setBaseType(element.getBaseType());
        this.setStpProtocolSpecification(element.getStpProtocolSpecification());
        this.setStpPriority(element.getStpPriority());
        this.setStpDesignatedRoot(element.getStpDesignatedRoot());
        this.setStpRootCost(element.getStpRootCost());
        this.setStpRootPort(element.getStpRootPort());
        this.setBridgeNodeLastPollTime(element.getBridgeNodeCreateTime());
    }

    public static enum BridgeDot1dBaseType {
        DOT1DBASETYPE_UNKNOWN(1),
        DOT1DBASETYPE_TRANSPARENT_ONLY(2),
        DOT1DBASETYPE_SOURCEROUTE_ONLY(3),
        DOT1DBASETYPE_SRT(4);

        private int m_type;
        protected static final Map<Integer, String> s_typeMap;

        private BridgeDot1dBaseType(int type) {
            this.m_type = type;
        }

        public static String getTypeString(Integer code) {
            if (s_typeMap.containsKey(code)) {
                return s_typeMap.get(code);
            }
            return null;
        }

        public Integer getValue() {
            return this.m_type;
        }

        public static BridgeDot1dBaseType get(Integer code) {
            if (code == null) {
                throw new IllegalArgumentException("Cannot create Dot1dBaseType from null code");
            }
            switch (code) {
                case 1: {
                    return DOT1DBASETYPE_UNKNOWN;
                }
                case 2: {
                    return DOT1DBASETYPE_TRANSPARENT_ONLY;
                }
                case 3: {
                    return DOT1DBASETYPE_SOURCEROUTE_ONLY;
                }
                case 4: {
                    return DOT1DBASETYPE_SRT;
                }
            }
            throw new IllegalArgumentException("Cannot create Dot1dBaseType from code " + code);
        }

        static {
            s_typeMap = new HashMap<Integer, String>();
            s_typeMap.put(1, "unknown");
            s_typeMap.put(2, "transparent-only");
            s_typeMap.put(3, "sourceroute-only");
            s_typeMap.put(4, "srt");
        }
    }

    public static enum BridgeDot1dStpProtocolSpecification {
        DOT1D_STP_PROTOCOL_SPECIFICATION_UNKNOWN(1),
        DOT1D_STP_PROTOCOL_SPECIFICATION_DECLB100(2),
        DOT1D_STP_PROTOCOL_SPECIFICATION_IEEE8021D(3),
        DOT1D_STP_PROTOCOL_SPECIFICATION_IEEE8021M(4),
        DOT1D_STP_PROTOCOL_SPECIFICATION_IEEE8021AQ(5);

        private int m_type;
        protected static final Map<Integer, String> s_typeMap;

        private BridgeDot1dStpProtocolSpecification(int type) {
            this.m_type = type;
        }

        public static String getTypeString(Integer code) {
            if (s_typeMap.containsKey(code)) {
                return s_typeMap.get(code);
            }
            return "other-vendor-specific";
        }

        public Integer getValue() {
            return this.m_type;
        }

        public static BridgeDot1dStpProtocolSpecification get(Integer code) {
            if (code == null) {
                throw new IllegalArgumentException("Cannot create Dot1dStpProtocolSpecification from null code");
            }
            if (code <= 0) {
                throw new IllegalArgumentException("Cannot create Dot1dStpProtocolSpecification from" + code + " code");
            }
            switch (code) {
                case 1: {
                    return DOT1D_STP_PROTOCOL_SPECIFICATION_UNKNOWN;
                }
                case 2: {
                    return DOT1D_STP_PROTOCOL_SPECIFICATION_DECLB100;
                }
                case 3: {
                    return DOT1D_STP_PROTOCOL_SPECIFICATION_IEEE8021D;
                }
                case 4: {
                    return DOT1D_STP_PROTOCOL_SPECIFICATION_IEEE8021M;
                }
                case 5: {
                    return DOT1D_STP_PROTOCOL_SPECIFICATION_IEEE8021AQ;
                }
            }
            throw new IllegalArgumentException("Cannot create Dot1dStpProtocolSpecification from" + code + " code");
        }

        static {
            s_typeMap = new HashMap<Integer, String>();
            s_typeMap.put(1, "unknown");
            s_typeMap.put(2, "decLb100");
            s_typeMap.put(3, "ieee802.1d");
            s_typeMap.put(4, "ieee802.1m");
            s_typeMap.put(5, "ieee802.1aq");
        }
    }
}

