/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.dao.api.ApplicationStatus;
import org.opennms.netmgt.dao.api.MonitoredServiceStatusEntity;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.dao.util.ReductionKeyHelper;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsSeverity;
import org.springframework.orm.hibernate3.HibernateCallback;

public class ApplicationDaoHibernate
extends AbstractDaoHibernate<OnmsApplication, Integer>
implements ApplicationDao {
    public ApplicationDaoHibernate() {
        super(OnmsApplication.class);
    }

    public OnmsApplication findByName(String name) {
        return (OnmsApplication)this.findUnique("from OnmsApplication as app where app.name = ?", name);
    }

    public List<ApplicationStatus> getApplicationStatus() {
        return this.getApplicationStatus(this.findAll());
    }

    public List<ApplicationStatus> getApplicationStatus(List<OnmsApplication> applications) {
        ArrayList<ApplicationStatus> statusList = new ArrayList<ApplicationStatus>();
        for (OnmsApplication application : applications) {
            HashSet reductionKeys = new HashSet();
            for (OnmsMonitoredService eachService : application.getMonitoredServices()) {
                reductionKeys.addAll(ReductionKeyHelper.getReductionKeys((OnmsMonitoredService)eachService));
            }
            if (!reductionKeys.isEmpty()) {
                CriteriaBuilder builder = new CriteriaBuilder(OnmsAlarm.class);
                builder.in("reductionKey", reductionKeys);
                HibernateCallback callback = this.buildHibernateCallback(builder.toCriteria());
                List alarms = (List)this.getHibernateTemplate().execute(callback);
                Optional maxSeverity = alarms.stream().reduce((leftAlarm, rightAlarm) -> {
                    if (leftAlarm.getSeverity().isGreaterThan(rightAlarm.getSeverity())) {
                        return leftAlarm;
                    }
                    return rightAlarm;
                });
                if (maxSeverity.isPresent()) {
                    statusList.add(new ApplicationStatus(application, ((OnmsAlarm)maxSeverity.get()).getSeverity()));
                    continue;
                }
                statusList.add(new ApplicationStatus(application, OnmsSeverity.NORMAL));
                continue;
            }
            statusList.add(new ApplicationStatus(application, OnmsSeverity.NORMAL));
        }
        return statusList;
    }

    public List<MonitoredServiceStatusEntity> getAlarmStatus() {
        return this.getAlarmStatus(this.findAll());
    }

    public List<MonitoredServiceStatusEntity> getAlarmStatus(List<OnmsApplication> applications) {
        Objects.requireNonNull(applications);
        List<OnmsMonitoredService> services = applications.stream().flatMap(application -> application.getMonitoredServices().stream()).collect(Collectors.toList());
        return this.getAlarmStatusForServices(services);
    }

    private List<MonitoredServiceStatusEntity> getAlarmStatusForServices(List<OnmsMonitoredService> services) {
        Objects.requireNonNull(services);
        if (services.isEmpty()) {
            return Lists.newArrayList();
        }
        Set reductionKeys = services.stream().flatMap(service -> ReductionKeyHelper.getReductionKeys((OnmsMonitoredService)service).stream()).collect(Collectors.toSet());
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select distinct alarm.node.id, min(alarm.lastEventTime), max(alarm.severity), (count(*) - count(alarm.alarmAckTime)) ");
        sqlBuilder.append("from OnmsAlarm alarm ");
        sqlBuilder.append("where alarm.severity > 3 and alarm.alarmAckTime is null and alarm.reductionKey in :keys ");
        sqlBuilder.append("group by alarm.node.id");
        List nodeIdToSeverityMapping = this.getHibernateTemplate().findByNamedParam(sqlBuilder.toString(), new String[]{"keys"}, new Object[]{reductionKeys.toArray()});
        ArrayList<MonitoredServiceStatusEntity> entityList = new ArrayList<MonitoredServiceStatusEntity>();
        for (Object[] eachRow : nodeIdToSeverityMapping) {
            MonitoredServiceStatusEntity entity = new MonitoredServiceStatusEntity(((Integer)eachRow[0]).intValue(), (Date)eachRow[1], (OnmsSeverity)eachRow[2], ((Long)eachRow[3]).longValue());
            entityList.add(entity);
        }
        return entityList;
    }
}

