/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.soa.filter;

import java.util.LinkedList;
import org.opennms.core.soa.Filter;
import org.opennms.core.soa.filter.AndFilter;
import org.opennms.core.soa.filter.EqFilter;
import org.opennms.core.soa.filter.GreaterThanFilter;
import org.opennms.core.soa.filter.LessThanFilter;
import org.opennms.core.soa.filter.NotFilter;
import org.opennms.core.soa.filter.OrFilter;
import org.opennms.core.soa.filter.PatternMatchingFilter;
import org.opennms.core.soa.filter.PresenceFilter;

public class FilterParser {
    private Lexer m_lexer;

    public Filter parse(String filterString) {
        this.m_lexer = new Lexer(filterString);
        return this.filter();
    }

    private Filter filter() {
        this.skipWhitespace();
        this.match("(");
        Filter filter = this.filterComp();
        this.skipWhitespace();
        this.match(")");
        return filter;
    }

    private Filter filterComp() {
        this.skipWhitespace();
        String token = this.m_lexer.peekToken();
        if ("&".equals(token)) {
            return this.and();
        }
        if ("|".equals(token)) {
            return this.or();
        }
        if ("!".equals(token)) {
            return this.not();
        }
        return this.operation();
    }

    private Filter and() {
        this.match("&");
        LinkedList<Filter> filters = this.filterList();
        return new AndFilter(filters);
    }

    private Filter or() {
        this.match("|");
        LinkedList<Filter> filters = this.filterList();
        return new OrFilter(filters);
    }

    private Filter not() {
        this.match("!");
        Filter filter = this.filter();
        return new NotFilter(filter);
    }

    private LinkedList<Filter> filterList() {
        Filter filter = this.filter();
        this.skipWhitespace();
        String token = this.m_lexer.peekToken();
        LinkedList<Filter> filters = "(".equals(token) ? this.filterList() : new LinkedList();
        filters.addFirst(filter);
        return filters;
    }

    private Filter operation() {
        String attribute = this.matchAttribute();
        this.skipWhitespace();
        String operation = this.m_lexer.peekToken();
        if (">=".equals(operation)) {
            return this.greaterThan(attribute);
        }
        if ("<=".equals(operation)) {
            return this.lessThan(attribute);
        }
        if ("=".equals(operation)) {
            return this.eq(attribute);
        }
        this.parseError("Unsupported operation " + operation);
        return null;
    }

    private Filter eq(String attribute) {
        this.match("=");
        String value = this.m_lexer.charsTil(')');
        if ("*".equals(value.trim())) {
            return new PresenceFilter(attribute);
        }
        if (!value.replace("\\*", "").contains("*")) {
            return new EqFilter(attribute, value.replaceAll("\\\\(.)", "$1"));
        }
        return new PatternMatchingFilter(attribute, value);
    }

    private void assertNotEnd(String token, String msg) {
        if (token == null) {
            this.parseError("Unexpected end of input. " + msg);
        }
    }

    private Filter lessThan(String attribute) {
        this.match("<=");
        String value = this.m_lexer.nextToken();
        this.assertNotEnd(value, "Expected a value following <=");
        return new LessThanFilter(attribute, value);
    }

    private Filter greaterThan(String attribute) {
        this.match(">=");
        String value = this.m_lexer.nextToken();
        this.assertNotEnd(value, "Expected a value following >=");
        return new GreaterThanFilter(attribute, value);
    }

    private String matchAttribute() {
        String token = this.m_lexer.nextToken();
        this.assertNotEnd(token, "Expected an attribute name.");
        String attr = token.trim();
        this.ensureAttrDoesNotContain(attr, "()&|!*=<>~");
        return attr;
    }

    private void ensureAttrDoesNotContain(String attr, String invalidChars) {
        for (int i = 0; i < invalidChars.length(); ++i) {
            char ch = invalidChars.charAt(i);
            if (!attr.contains(String.valueOf(ch))) continue;
            this.parseError("Attributes may not contain the '" + ch + "' characters");
        }
    }

    private String match(String expected) {
        String actual = this.m_lexer.nextToken();
        this.assertNotEnd(actual, "Expected " + expected);
        if (!expected.equals(actual)) {
            this.parseError("Unexpected token " + actual + ".  Expected " + expected);
            return null;
        }
        return actual;
    }

    private void skipWhitespace() {
        String token = this.m_lexer.peekToken();
        if (token != null && "".equals(token.trim())) {
            this.m_lexer.nextToken();
            token = this.m_lexer.peekToken();
        }
    }

    void parseError(String msg) {
        throw new IllegalArgumentException(msg);
    }

    private class Lexer {
        private String m_input;
        private int m_ptr;
        private String m_peekedToken;

        Lexer(String input) {
            this.m_input = input;
            this.m_ptr = 0;
            this.m_peekedToken = null;
        }

        Character nextChar() {
            if (this.m_ptr >= this.m_input.length()) {
                return null;
            }
            return Character.valueOf(this.m_input.charAt(this.m_ptr++));
        }

        Character peekChar() {
            if (this.m_ptr >= this.m_input.length()) {
                return null;
            }
            return Character.valueOf(this.m_input.charAt(this.m_ptr));
        }

        boolean isTokenStart(Character ch) {
            if (ch == null) {
                return true;
            }
            switch (ch.charValue()) {
                case '!': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '<': 
                case '=': 
                case '>': 
                case '|': {
                    return true;
                }
            }
            return false;
        }

        String readText() {
            StringBuilder bldr = new StringBuilder();
            Character ch = this.peekChar();
            while (!this.isTokenStart(ch)) {
                if (ch.charValue() == '\\') {
                    this.nextChar();
                    ch = this.nextChar();
                    if (ch == null) {
                        FilterParser.this.parseError("End of input reached after '\\'");
                    }
                }
                bldr.append(this.nextChar());
                ch = this.peekChar();
            }
            return bldr.toString();
        }

        String peekToken() {
            if (this.m_peekedToken == null) {
                this.m_peekedToken = this.nextToken();
            }
            return this.m_peekedToken;
        }

        String nextToken() {
            if (this.m_peekedToken != null) {
                String token = this.m_peekedToken;
                this.m_peekedToken = null;
                return token;
            }
            Character ch = this.nextChar();
            if (ch == null) {
                return null;
            }
            switch (ch.charValue()) {
                case '!': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '=': 
                case '|': {
                    return ch.toString();
                }
                case '<': 
                case '>': {
                    Character eq = this.nextChar();
                    if (eq == null || '=' != eq.charValue()) {
                        FilterParser.this.parseError("Expected '=' following '" + ch + "'. Note strict '>' and '<' not supported");
                        return null;
                    }
                    return String.valueOf(new char[]{ch.charValue(), eq.charValue()});
                }
            }
            StringBuilder bldr = new StringBuilder();
            bldr.append(ch);
            bldr.append(this.readText());
            return bldr.toString();
        }

        String charsTil(char token) {
            if (this.m_peekedToken != null) {
                throw new IllegalStateException("Cannot compute charTil while a peeked token exists.");
            }
            StringBuilder buf = new StringBuilder();
            boolean escaped = false;
            Character ch = this.peekChar();
            while (ch != null && (ch.charValue() != token || escaped)) {
                buf.append(this.nextChar());
                escaped = ch.charValue() == '\\' ? !escaped : false;
                ch = this.peekChar();
            }
            return buf.toString();
        }
    }
}

