/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ResourcePath
implements Iterable<String>,
Comparable<ResourcePath> {
    private static final Pattern SANITIZE_PATH_PATTERN = Pattern.compile("[^a-zA-Z0-9.-]");
    private static final String SANITIZE_PATH_PLACEHOLDER = "_";
    private final List<String> elements = new ArrayList<String>();

    public ResourcePath(String ... path) {
        for (String el : path) {
            this.elements.add(el);
        }
    }

    public ResourcePath(Iterable<String> pathElements) {
        for (String el : pathElements) {
            this.elements.add(el);
        }
    }

    public ResourcePath(ResourcePath parent, String ... path) {
        this.elements.addAll(parent.elements);
        for (String el : path) {
            this.elements.add(el);
        }
    }

    public ResourcePath(ResourcePath parent, Iterable<String> path) {
        this.elements.addAll(parent.elements);
        for (String el : path) {
            this.elements.add(el);
        }
    }

    public static ResourcePath get(String ... path) {
        return new ResourcePath(path);
    }

    public static ResourcePath get(Iterable<String> pathElements) {
        return new ResourcePath(pathElements);
    }

    public static ResourcePath get(ResourcePath parent, String ... path) {
        return new ResourcePath(parent, path);
    }

    public static ResourcePath get(ResourcePath parent, Iterable<String> path) {
        return new ResourcePath(parent, path);
    }

    public String getName() {
        int k = this.elements.size() - 1;
        return k < 0 ? null : this.elements.get(k);
    }

    public String[] elements() {
        return this.elements.toArray(new String[this.elements.size()]);
    }

    public int relativeDepth(ResourcePath child) {
        int numParentEls;
        List<String> childEls = child.elements;
        int numChildEls = childEls.size();
        if (numChildEls < (numParentEls = this.elements.size())) {
            return -1;
        }
        for (int i = 0; i < numParentEls; ++i) {
            if (this.elements.get(i).equals(childEls.get(i))) continue;
            return -1;
        }
        return numChildEls - numParentEls;
    }

    public ResourcePath getParent() {
        if (!this.hasParent()) {
            throw new UnsupportedOperationException("I am on the root level already");
        }
        return new ResourcePath(this.elements.subList(0, this.elements.size() - 1));
    }

    public boolean hasParent() {
        return this.elements.size() > 1;
    }

    @Override
    public Iterator<String> iterator() {
        return this.elements.iterator();
    }

    public String toString() {
        return ResourcePath.toString(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePath)) {
            return false;
        }
        ResourcePath other = (ResourcePath)obj;
        return !(this.elements == null ? other.elements != null : !this.elements.equals(other.elements));
    }

    @Override
    public int compareTo(ResourcePath other) {
        return this.toString().compareTo(other.toString());
    }

    public static String sanitize(String path) {
        if (path == null) {
            return null;
        }
        return SANITIZE_PATH_PATTERN.matcher(path).replaceAll(SANITIZE_PATH_PLACEHOLDER);
    }

    public static Path resourceToFilesystemPath(ResourcePath path) {
        Path result = Paths.get("", new String[0]);
        for (String e : path) {
            if (File.separatorChar == '\\') {
                e = e.replace(':', '_');
            }
            result = result.resolve(e);
        }
        return result;
    }

    public static ResourcePath fromString(String s) {
        if (s.isEmpty()) {
            return ResourcePath.get(new String[0]);
        }
        return ResourcePath.get(s.split("/"));
    }

    public static String toString(ResourcePath path) {
        return path.elements.stream().collect(Collectors.joining(File.separator));
    }
}

