/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.map;

import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastTreeMap<K, V>
extends TreeMap<K, V> {
    protected TreeMap<K, V> map = null;
    protected boolean fast = false;

    public FastTreeMap() {
        this.map = new TreeMap();
    }

    public FastTreeMap(Comparator<K> comparator) {
        this.map = new TreeMap(comparator);
    }

    public FastTreeMap(Map<K, V> map) {
        this.map = new TreeMap<K, V>(map);
    }

    public FastTreeMap(SortedMap<K, V> map) {
        this.map = new TreeMap<K, V>(map);
    }

    public boolean getFast() {
        return this.fast;
    }

    public void setFast(boolean fast) {
        this.fast = fast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        if (this.fast) {
            return this.map.get(key);
        }
        TreeMap<K, V> treeMap = this.map;
        synchronized (treeMap) {
            return this.map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        if (this.fast) {
            return this.map.size();
        }
        TreeMap<K, V> treeMap = this.map;
        synchronized (treeMap) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        if (this.fast) {
            return this.map.isEmpty();
        }
        TreeMap<K, V> treeMap = this.map;
        synchronized (treeMap) {
            return this.map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        if (this.fast) {
            return this.map.containsKey(key);
        }
        TreeMap<K, V> treeMap = this.map;
        synchronized (treeMap) {
            return this.map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        if (this.fast) {
            return this.map.containsValue(value);
        }
        TreeMap<K, V> treeMap = this.map;
        synchronized (treeMap) {
            return this.map.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Comparator<? super K> comparator() {
        if (this.fast) {
            return this.map.comparator();
        }
        TreeMap<K, V> treeMap = this.map;
        synchronized (treeMap) {
            return this.map.comparator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public K firstKey() {
        if (this.fast) {
            return this.map.firstKey();
        }
        TreeMap<K, V> treeMap = this.map;
        synchronized (treeMap) {
            return this.map.firstKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public K lastKey() {
        if (this.fast) {
            return this.map.lastKey();
        }
        TreeMap<K, V> treeMap = this.map;
        synchronized (treeMap) {
            return this.map.lastKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap temp = (TreeMap)this.map.clone();
                V result = temp.put(key, value);
                this.map = temp;
                return result;
            }
        }
        TreeMap<K, V> treeMap = this.map;
        synchronized (treeMap) {
            return this.map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> in) {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap temp = (TreeMap)this.map.clone();
                temp.putAll(in);
                this.map = temp;
            }
        }
        TreeMap<K, V> treeMap = this.map;
        synchronized (treeMap) {
            this.map.putAll(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap temp = (TreeMap)this.map.clone();
                Object result = temp.remove(key);
                this.map = temp;
                return result;
            }
        }
        TreeMap<K, V> treeMap = this.map;
        synchronized (treeMap) {
            return this.map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                this.map = new TreeMap();
            }
        }
        TreeMap<K, V> treeMap = this.map;
        synchronized (treeMap) {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map mo = (Map)o;
        if (this.fast) {
            if (mo.size() != this.map.size()) {
                return false;
            }
            for (Map.Entry<K, V> e : this.map.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                if (!(value == null ? mo.get(key) != null || !mo.containsKey(key) : !value.equals(mo.get(key)))) continue;
                return false;
            }
            return true;
        }
        TreeMap<K, V> treeMap = this.map;
        synchronized (treeMap) {
            if (mo.size() != this.map.size()) {
                return false;
            }
            for (Map.Entry<K, V> e : this.map.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                if (value == null) {
                    if (mo.get(key) == null && mo.containsKey(key)) continue;
                    return false;
                }
                if (value.equals(mo.get(key))) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        if (this.fast) {
            int h = 0;
            Iterator<Map.Entry<K, V>> i = this.map.entrySet().iterator();
            while (i.hasNext()) {
                h += ((Object)i.next()).hashCode();
            }
            return h;
        }
        TreeMap<K, V> treeMap = this.map;
        synchronized (treeMap) {
            int h = 0;
            Iterator<Map.Entry<K, V>> i = this.map.entrySet().iterator();
            while (i.hasNext()) {
                h += ((Object)i.next()).hashCode();
            }
            return h;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FastTreeMap<K, V> clone() {
        FastTreeMap<K, V> results = null;
        if (this.fast) {
            results = new FastTreeMap<K, V>(this.map);
        } else {
            TreeMap<K, V> treeMap = this.map;
            synchronized (treeMap) {
                results = new FastTreeMap<K, V>(this.map);
            }
        }
        results.setFast(this.getFast());
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedMap<K, V> headMap(K key) {
        if (this.fast) {
            return this.map.headMap(key);
        }
        TreeMap<K, V> treeMap = this.map;
        synchronized (treeMap) {
            return this.map.headMap(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        if (this.fast) {
            return this.map.subMap(fromKey, toKey);
        }
        TreeMap<K, V> treeMap = this.map;
        synchronized (treeMap) {
            return this.map.subMap(fromKey, toKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedMap<K, V> tailMap(K key) {
        if (this.fast) {
            return this.map.tailMap(key);
        }
        TreeMap<K, V> treeMap = this.map;
        synchronized (treeMap) {
            return this.map.tailMap(key);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new Values();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends CollectionView<Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        protected Collection<Map.Entry<K, V>> get(Map<K, V> map) {
            return map.entrySet();
        }

        @Override
        protected Map.Entry<K, V> iteratorNext(Map.Entry<K, V> entry) {
            return entry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values
    extends CollectionView<V> {
        private Values() {
        }

        @Override
        protected Collection<V> get(Map<K, V> map) {
            return map.values();
        }

        @Override
        protected V iteratorNext(Map.Entry<K, V> entry) {
            return entry.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends CollectionView<K>
    implements Set<K> {
        private KeySet() {
        }

        @Override
        protected Collection<K> get(Map<K, V> map) {
            return map.keySet();
        }

        @Override
        protected K iteratorNext(Map.Entry<K, V> entry) {
            return entry.getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class CollectionView<E>
    implements Collection<E> {
        protected abstract Collection<E> get(Map<K, V> var1);

        protected abstract E iteratorNext(Map.Entry<K, V> var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            if (FastTreeMap.this.fast) {
                FastTreeMap fastTreeMap = FastTreeMap.this;
                synchronized (fastTreeMap) {
                    FastTreeMap.this.map = new TreeMap();
                }
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                this.get(FastTreeMap.this.map).clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            if (FastTreeMap.this.fast) {
                FastTreeMap fastTreeMap = FastTreeMap.this;
                synchronized (fastTreeMap) {
                    TreeMap temp = (TreeMap)FastTreeMap.this.map.clone();
                    boolean r = this.get(temp).remove(o);
                    FastTreeMap.this.map = temp;
                    return r;
                }
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                return this.get(FastTreeMap.this.map).remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> o) {
            if (FastTreeMap.this.fast) {
                FastTreeMap fastTreeMap = FastTreeMap.this;
                synchronized (fastTreeMap) {
                    TreeMap temp = (TreeMap)FastTreeMap.this.map.clone();
                    boolean r = this.get(temp).removeAll(o);
                    FastTreeMap.this.map = temp;
                    return r;
                }
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                return this.get(FastTreeMap.this.map).removeAll(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> o) {
            if (FastTreeMap.this.fast) {
                FastTreeMap fastTreeMap = FastTreeMap.this;
                synchronized (fastTreeMap) {
                    TreeMap temp = (TreeMap)FastTreeMap.this.map.clone();
                    boolean r = this.get(temp).retainAll(o);
                    FastTreeMap.this.map = temp;
                    return r;
                }
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                return this.get(FastTreeMap.this.map).retainAll(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            if (FastTreeMap.this.fast) {
                return this.get(FastTreeMap.this.map).size();
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                return this.get(FastTreeMap.this.map).size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            if (FastTreeMap.this.fast) {
                return this.get(FastTreeMap.this.map).isEmpty();
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                return this.get(FastTreeMap.this.map).isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            if (FastTreeMap.this.fast) {
                return this.get(FastTreeMap.this.map).contains(o);
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                return this.get(FastTreeMap.this.map).contains(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> o) {
            if (FastTreeMap.this.fast) {
                return this.get(FastTreeMap.this.map).containsAll(o);
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                return this.get(FastTreeMap.this.map).containsAll(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] o) {
            if (FastTreeMap.this.fast) {
                return this.get(FastTreeMap.this.map).toArray(o);
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                return this.get(FastTreeMap.this.map).toArray(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            if (FastTreeMap.this.fast) {
                return this.get(FastTreeMap.this.map).toArray();
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                return this.get(FastTreeMap.this.map).toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (FastTreeMap.this.fast) {
                return ((Object)this.get(FastTreeMap.this.map)).equals(o);
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                return ((Object)this.get(FastTreeMap.this.map)).equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            if (FastTreeMap.this.fast) {
                return ((Object)this.get(FastTreeMap.this.map)).hashCode();
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                return ((Object)this.get(FastTreeMap.this.map)).hashCode();
            }
        }

        @Override
        public boolean add(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> iterator() {
            return new CollectionViewIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class CollectionViewIterator
        implements Iterator<E> {
            private Map<K, V> expected;
            private Map.Entry<K, V> lastReturned = null;
            private Iterator<Map.Entry<K, V>> iterator;

            public CollectionViewIterator() {
                this.expected = FastTreeMap.this.map;
                this.iterator = this.expected.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.expected != FastTreeMap.this.map) {
                    throw new ConcurrentModificationException();
                }
                return this.iterator.hasNext();
            }

            @Override
            public E next() {
                if (this.expected != FastTreeMap.this.map) {
                    throw new ConcurrentModificationException();
                }
                this.lastReturned = this.iterator.next();
                return CollectionView.this.iteratorNext(this.lastReturned);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (FastTreeMap.this.fast) {
                    FastTreeMap fastTreeMap = FastTreeMap.this;
                    synchronized (fastTreeMap) {
                        if (this.expected != FastTreeMap.this.map) {
                            throw new ConcurrentModificationException();
                        }
                        FastTreeMap.this.remove(this.lastReturned.getKey());
                        this.lastReturned = null;
                        this.expected = FastTreeMap.this.map;
                    }
                } else {
                    this.iterator.remove();
                    this.lastReturned = null;
                }
            }
        }
    }
}

