/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.api.updates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.opennms.netmgt.graph.api.Edge;
import org.opennms.netmgt.graph.api.ImmutableGraph;
import org.opennms.netmgt.graph.api.Vertex;
import org.opennms.netmgt.graph.api.focus.Focus;
import org.opennms.netmgt.graph.api.info.DefaultGraphInfo;
import org.opennms.netmgt.graph.api.info.GraphInfo;

public final class ChangeSet<G extends ImmutableGraph<V, E>, V extends Vertex, E extends Edge> {
    private final String namespace;
    private final Date changeSetDate;
    private final List<V> verticesAdded;
    private final List<V> verticesRemoved;
    private final List<V> verticesUpdated;
    private final List<E> edgesAdded;
    private final List<E> edgesRemoved;
    private final List<E> edgesUpdated;
    private final GraphInfo currentGraphInfo;
    private final Focus currentFocus;

    public ChangeSet(ChangeSetBuilder builder) {
        Objects.requireNonNull(builder);
        this.namespace = builder.namespace;
        this.changeSetDate = builder.changeSetDate == null ? new Date() : builder.changeSetDate;
        this.verticesAdded = Collections.unmodifiableList(builder.verticesAdded);
        this.verticesRemoved = Collections.unmodifiableList(builder.verticesRemoved);
        this.verticesUpdated = Collections.unmodifiableList(builder.verticesUpdated);
        this.edgesAdded = Collections.unmodifiableList(builder.edgesAdded);
        this.edgesRemoved = Collections.unmodifiableList(builder.edgesRemoved);
        this.edgesUpdated = Collections.unmodifiableList(builder.edgesUpdated);
        this.currentGraphInfo = builder.currentGraphInfo;
        this.currentFocus = builder.currentFocus;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Date getChangeSetDate() {
        return this.changeSetDate;
    }

    public GraphInfo getGraphInfo() {
        return this.currentGraphInfo;
    }

    public Focus getFocus() {
        return this.currentFocus;
    }

    public List<V> getVerticesAdded() {
        return this.verticesAdded;
    }

    public List<V> getVerticesRemoved() {
        return this.verticesRemoved;
    }

    public List<V> getVerticesUpdated() {
        return this.verticesUpdated;
    }

    public List<E> getEdgesAdded() {
        return this.edgesAdded;
    }

    public List<E> getEdgesRemoved() {
        return this.edgesRemoved;
    }

    public List<E> getEdgesUpdated() {
        return this.edgesUpdated;
    }

    public boolean hasGraphInfoChanged() {
        return this.currentGraphInfo != null;
    }

    public boolean hasFocusChanged() {
        return this.currentFocus != null;
    }

    public boolean hasChanges() {
        return this.hasGraphInfoChanged() || this.hasFocusChanged() || !this.edgesAdded.isEmpty() || !this.edgesRemoved.isEmpty() || !this.edgesUpdated.isEmpty() || !this.verticesAdded.isEmpty() || !this.verticesRemoved.isEmpty() || !this.verticesUpdated.isEmpty();
    }

    public static <G extends ImmutableGraph<V, E>, V extends Vertex, E extends Edge> ChangeSetBuilder<G, V, E> builder(G oldGraph, G newGraph) {
        return new ChangeSetBuilder(oldGraph, newGraph, null);
    }

    public static final class ChangeSetBuilder<G extends ImmutableGraph<V, E>, V extends Vertex, E extends Edge> {
        private final G newGraph;
        private final G oldGraph;
        private String namespace;
        private Date changeSetDate;
        private List<V> verticesAdded = new ArrayList<V>();
        private List<V> verticesRemoved = new ArrayList<V>();
        private List<V> verticesUpdated = new ArrayList<V>();
        private List<E> edgesAdded = new ArrayList();
        private List<E> edgesRemoved = new ArrayList();
        private List<E> edgesUpdated = new ArrayList();
        private GraphInfo currentGraphInfo;
        private Focus currentFocus;

        private ChangeSetBuilder(G oldGraph, G newGraph) {
            if (oldGraph == null && newGraph == null) {
                throw new IllegalArgumentException("Cannot create change set if both graphs are null.");
            }
            this.namespace = oldGraph == null ? newGraph.getNamespace() : oldGraph.getNamespace();
            this.oldGraph = oldGraph;
            this.newGraph = newGraph;
        }

        public ChangeSetBuilder withDate(Date changeSetDate) {
            this.changeSetDate = Objects.requireNonNull(changeSetDate);
            return this;
        }

        private ChangeSetBuilder vertexAdded(V vertex) {
            this.verticesAdded.add(vertex);
            return this;
        }

        private ChangeSetBuilder vertexRemoved(V vertex) {
            this.verticesRemoved.add(vertex);
            return this;
        }

        private ChangeSetBuilder vertexUpdated(V vertex) {
            this.verticesUpdated.add(vertex);
            return this;
        }

        private ChangeSetBuilder edgeAdded(E edge) {
            this.edgesAdded.add(edge);
            return this;
        }

        private ChangeSetBuilder edgeRemoved(E edge) {
            this.edgesRemoved.add(edge);
            return this;
        }

        private ChangeSetBuilder edgeUpdated(E edge) {
            this.edgesUpdated.add(edge);
            return this;
        }

        private ChangeSetBuilder graphInfoChanged(GraphInfo graphInfo) {
            this.currentGraphInfo = graphInfo;
            return this;
        }

        private ChangeSetBuilder focusChanged(Focus newFocus) {
            this.currentFocus = newFocus;
            return this;
        }

        private void detectChanges(G oldGraph, G newGraph) {
            if (oldGraph == null && newGraph != null) {
                newGraph.getVertices().forEach(v -> this.vertexAdded(v));
                newGraph.getEdges().forEach(e -> this.edgeAdded(e));
                this.graphInfoChanged(this.createGraphInfo(newGraph));
            }
            if (oldGraph != null && newGraph == null) {
                oldGraph.getVertices().forEach(v -> this.vertexRemoved(v));
                oldGraph.getEdges().forEach(e -> this.edgeRemoved(e));
                this.graphInfoChanged(null);
            }
            if (oldGraph == newGraph) {
                return;
            }
            if (oldGraph != null && newGraph != null) {
                if (!oldGraph.getNamespace().equals(newGraph.getNamespace())) {
                    throw new IllegalStateException("Cannot detect changes between different namespaces");
                }
                this.detectFocusChange(oldGraph, newGraph);
                this.detectGraphInfoChanges(oldGraph, newGraph);
                this.detectVertexChanges(oldGraph, newGraph);
                this.detectEdgeChanges(oldGraph, newGraph);
            }
        }

        private void detectFocusChange(G oldGraph, G newGraph) {
            Focus newFocus;
            Focus oldFocus = oldGraph.getDefaultFocus();
            if (!Objects.equals(oldFocus, newFocus = newGraph.getDefaultFocus())) {
                this.focusChanged(newFocus);
            }
        }

        private void detectGraphInfoChanges(G oldGraph, G newGraph) {
            GraphInfo newGraphInfo;
            GraphInfo oldGraphInfo = this.createGraphInfo(oldGraph);
            if (!Objects.equals(oldGraphInfo, newGraphInfo = this.createGraphInfo(newGraph))) {
                this.graphInfoChanged(newGraphInfo);
            }
        }

        private GraphInfo createGraphInfo(G graph) {
            if (graph != null) {
                DefaultGraphInfo graphInfo = new DefaultGraphInfo((GraphInfo)graph);
                return graphInfo;
            }
            return null;
        }

        private void detectVertexChanges(G oldGraph, G newGraph) {
            ArrayList<String> oldVertexIds = new ArrayList<String>(oldGraph.getVertexIds());
            ArrayList<String> newVertexIds = new ArrayList<String>(newGraph.getVertexIds());
            ArrayList<String> removedVertices = new ArrayList<String>(oldVertexIds);
            removedVertices.removeAll(newVertexIds);
            removedVertices.forEach(id -> this.vertexRemoved(oldGraph.getVertex((String)id)));
            ArrayList<String> addedVertices = new ArrayList<String>(newVertexIds);
            addedVertices.removeAll(oldVertexIds);
            addedVertices.forEach(id -> this.vertexAdded(newGraph.getVertex((String)id)));
            ArrayList<String> sharedVertcies = new ArrayList<String>(newVertexIds);
            sharedVertcies.removeAll(removedVertices);
            sharedVertcies.removeAll(addedVertices);
            sharedVertcies.stream().forEach(id -> {
                Object newVertex;
                Object oldVertex = oldGraph.getVertex((String)id);
                if (!oldVertex.equals(newVertex = newGraph.getVertex((String)id))) {
                    this.vertexUpdated(newVertex);
                }
            });
        }

        private void detectEdgeChanges(G oldGraph, G newGraph) {
            ArrayList<String> oldEdgeIds = new ArrayList<String>(oldGraph.getEdgeIds());
            ArrayList<String> newEdgeIds = new ArrayList<String>(newGraph.getEdgeIds());
            ArrayList<String> removedEdges = new ArrayList<String>(oldEdgeIds);
            removedEdges.removeAll(newEdgeIds);
            removedEdges.forEach(id -> this.edgeRemoved(oldGraph.getEdge((String)id)));
            ArrayList<String> addedEdges = new ArrayList<String>(newEdgeIds);
            addedEdges.removeAll(oldEdgeIds);
            addedEdges.forEach(id -> this.edgeAdded(newGraph.getEdge((String)id)));
            ArrayList<String> sharedEdges = new ArrayList<String>(newEdgeIds);
            sharedEdges.removeAll(removedEdges);
            sharedEdges.removeAll(addedEdges);
            sharedEdges.stream().forEach(id -> {
                Object newEdge;
                Object oldEdge = oldGraph.getEdge((String)id);
                if (!oldEdge.equals(newEdge = newGraph.getEdge((String)id))) {
                    this.edgeUpdated(newEdge);
                }
            });
        }

        public ChangeSet<G, V, E> build() {
            this.detectChanges(this.oldGraph, this.newGraph);
            return new ChangeSet(this);
        }

        /* synthetic */ ChangeSetBuilder(ImmutableGraph x0, ImmutableGraph x1, 1 x2) {
            this(x0, x1);
        }
    }
}

