/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc;

import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.events.api.model.IParm;
import org.opennms.netmgt.events.api.model.IValue;
import org.opennms.netmgt.rtc.DataManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DataUpdater
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(DataUpdater.class);
    private final IEvent m_event;
    private final DataManager m_dataManager;

    private void handleNodeGainedService(int nodeid, InetAddress ip, String svcName) {
        if (nodeid == -1 || ip == null || svcName == null) {
            LOG.warn("{} ignored - info incomplete - nodeid/ip/svc: {}/{}/{}", new Object[]{this.m_event.getUei(), nodeid, InetAddressUtils.str((InetAddress)ip), svcName});
            return;
        }
        this.m_dataManager.nodeGainedService(nodeid, ip, svcName);
        LOG.debug("{} added {}: {}: {} to data store", new Object[]{this.m_event.getUei(), nodeid, InetAddressUtils.str((InetAddress)ip), svcName});
    }

    private void handleOutageCreated(int nodeid, InetAddress ip, String svcName, long eventTime) {
        if (nodeid == -1 || ip == null || svcName == null || eventTime == -1L) {
            LOG.warn("{} ignored - info incomplete - nodeid/ip/svc/eventtime: {}/{}/{}/{}", new Object[]{this.m_event.getUei(), nodeid, InetAddressUtils.str((InetAddress)ip), svcName, eventTime});
            return;
        }
        this.m_dataManager.outageCreated(nodeid, ip, svcName, eventTime);
        LOG.debug("Added outageCreated to nodeid: {} ip: {} svcName: {}", new Object[]{svcName, nodeid, InetAddressUtils.str((InetAddress)ip)});
    }

    private void handleOutageResolved(int nodeid, InetAddress ip, String svcName, long eventTime) {
        if (nodeid == -1 || ip == null || svcName == null || eventTime == -1L) {
            LOG.warn("{} ignored - info incomplete - nodeid/ip/svc/eventtime: {}/{}/{}/{}", new Object[]{this.m_event.getUei(), nodeid, InetAddressUtils.str((InetAddress)ip), svcName, eventTime});
            return;
        }
        this.m_dataManager.outageResolved(nodeid, ip, svcName, eventTime);
        LOG.debug("Added outageResolved to nodeid: {} ip: {} svcName: {}", new Object[]{nodeid, InetAddressUtils.str((InetAddress)ip), svcName});
    }

    private void handleServiceDeleted(int nodeid, InetAddress ip, String svcName) {
        if (nodeid == -1 || ip == null || svcName == null) {
            LOG.warn("{} ignored - info incomplete - nodeid/ip/svc: {}/{}/{}", new Object[]{this.m_event.getUei(), nodeid, InetAddressUtils.str((InetAddress)ip), svcName});
            return;
        }
        this.m_dataManager.serviceDeleted(nodeid, ip, svcName);
        LOG.debug("{} deleted {}: {}: {} from data store", new Object[]{this.m_event.getUei(), nodeid, InetAddressUtils.str((InetAddress)ip), svcName});
    }

    private void handleInterfaceReparented(InetAddress ip, List<IParm> list) {
        if (ip == null || list == null) {
            LOG.warn("{} ignored - info incomplete - ip/parms: {}/{}", new Object[]{this.m_event.getUei(), InetAddressUtils.str((InetAddress)ip), list});
            return;
        }
        int oldNodeId = -1;
        int newNodeId = -1;
        String parmName = null;
        IValue parmValue = null;
        String parmContent = null;
        for (IParm parm : list) {
            String temp;
            parmName = parm.getParmName();
            parmValue = parm.getValue();
            if (parmValue == null) continue;
            parmContent = parmValue.getContent();
            if (parmName.equals("oldNodeID")) {
                temp = parmContent;
                try {
                    oldNodeId = Integer.parseInt(temp);
                }
                catch (NumberFormatException nfe) {
                    LOG.warn("Parameter {} cannot be non-numeric", (Object)"oldNodeID", (Object)nfe);
                    oldNodeId = -1;
                }
                continue;
            }
            if (!parmName.equals("newNodeID")) continue;
            temp = parmContent;
            try {
                newNodeId = Integer.parseInt(temp);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Parameter {} cannot be non-numeric", (Object)"newNodeID", (Object)nfe);
                newNodeId = -1;
            }
        }
        if (oldNodeId == -1 || newNodeId == -1) {
            LOG.warn("{} did not have all required information for {} Values contained old nodeid: {} new nodeid: {}", new Object[]{this.m_event.getUei(), InetAddressUtils.str((InetAddress)ip), oldNodeId, newNodeId});
        } else {
            this.m_dataManager.interfaceReparented(ip, oldNodeId, newNodeId);
            LOG.debug("{} reparented ip: {} from {} to {}", new Object[]{this.m_event.getUei(), InetAddressUtils.str((InetAddress)ip), oldNodeId, newNodeId});
        }
    }

    private void handleAssetInfoChangedEvent(int nodeid) {
        this.m_dataManager.assetInfoChanged(nodeid);
        LOG.debug("{} asset info changed for node {}", (Object)this.m_event.getUei(), (Object)nodeid);
    }

    private void handleNodeCategoryMembershipChanged(int nodeid) {
        this.m_dataManager.nodeCategoryMembershipChanged(nodeid);
        LOG.debug("{} surveillance category membership changed for node {}", (Object)this.m_event.getUei(), (Object)nodeid);
    }

    private void processEvent() {
        if (this.m_event == null) {
            LOG.debug("Event is null, nothing to process");
            return;
        }
        String eventUEI = this.m_event.getUei();
        if (eventUEI == null) {
            LOG.debug("Event received with null UEI, ignoring event");
            return;
        }
        int nodeid = -1;
        if (this.m_event.hasNodeid()) {
            nodeid = this.m_event.getNodeid().intValue();
        }
        InetAddress ip = this.m_event.getInterfaceAddress();
        String svcName = this.m_event.getService();
        long eventTime = this.m_event.getTime().getTime();
        LOG.debug("Event UEI: {}\tnodeid: {}\tip: {}\tsvcName: {}\teventTime: {}", new Object[]{eventUEI, nodeid, InetAddressUtils.str((InetAddress)ip), svcName, eventTime});
        if (eventUEI.equals("uei.opennms.org/nodes/nodeGainedService")) {
            this.handleNodeGainedService(nodeid, ip, svcName);
        } else if (eventUEI.equals("uei.opennms.org/internal/poller/outageCreated")) {
            this.handleOutageCreated(nodeid, ip, svcName, eventTime);
        } else if (eventUEI.equals("uei.opennms.org/internal/poller/outageResolved")) {
            this.handleOutageResolved(nodeid, ip, svcName, eventTime);
        } else if (eventUEI.equals("uei.opennms.org/nodes/serviceDeleted")) {
            this.handleServiceDeleted(nodeid, ip, svcName);
        } else if (eventUEI.equals("uei.opennms.org/nodes/serviceUnmanaged")) {
            this.handleServiceDeleted(nodeid, ip, svcName);
        } else if (eventUEI.equals("uei.opennms.org/nodes/interfaceReparented")) {
            this.handleInterfaceReparented(ip, this.m_event.getParmCollection());
        } else if (eventUEI.equals("uei.opennms.org/nodes/assetInfoChanged")) {
            this.handleAssetInfoChangedEvent(nodeid);
        } else if (eventUEI.equals("uei.opennms.org/nodes/nodeCategoryMembershipChanged")) {
            this.handleNodeCategoryMembershipChanged(nodeid);
        } else {
            LOG.debug("Event subscribed for not handled?!: {}", (Object)eventUEI);
        }
    }

    public DataUpdater(DataManager dataManager, IEvent event) {
        this.m_dataManager = dataManager;
        this.m_event = event;
    }

    @Override
    public void run() {
        Map mdc = Logging.getCopyOfContextMap();
        try {
            Logging.putPrefix((String)"rtc");
            this.processEvent();
        }
        catch (Throwable t) {
            LOG.warn("Unexpected exception processing event", t);
            Logging.setContextMap((Map)mdc);
        }
    }
}

