/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.timeseries.immutables;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.Tag;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableTag;
import org.opennms.integration.api.v1.timeseries.immutables.MetricValidator;
import org.opennms.integration.api.v1.util.ImmutableCollections;

public class ImmutableMetric
implements Metric {
    private final String key;
    private final Set<Tag> intrinsicTags;
    private final Set<Tag> metaTags;

    public ImmutableMetric(Set<Tag> intrinsicTags) {
        this(intrinsicTags, new HashSet<Tag>());
    }

    public ImmutableMetric(Set<Tag> intrinsicTags, Set<Tag> metaTags) {
        new MetricValidator(intrinsicTags, metaTags).validate();
        this.intrinsicTags = ImmutableCollections.newSetOfImmutableType(intrinsicTags);
        this.metaTags = ImmutableCollections.newSetOfImmutableType(metaTags);
        StringBuilder b = new StringBuilder();
        this.intrinsicTags.stream().sorted().forEach(tag -> b.append("_").append(tag.toString()));
        this.key = b.substring(1);
    }

    public Set<Tag> getTagsByKey(String key) {
        return Stream.concat(this.intrinsicTags.stream(), this.metaTags.stream()).filter(t -> Objects.equals(t.getKey(), key)).collect(Collectors.toSet());
    }

    public Tag getFirstTagByKey(String key) {
        List tags = Stream.concat(this.intrinsicTags.stream(), this.metaTags.stream()).filter(t -> Objects.equals(t.getKey(), key)).collect(Collectors.toList());
        return tags.size() > 0 ? (Tag)tags.get(0) : null;
    }

    public Set<Tag> getIntrinsicTags() {
        return this.intrinsicTags;
    }

    public String getKey() {
        return this.key;
    }

    public Set<Tag> getMetaTags() {
        return this.metaTags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Metric)) {
            return false;
        }
        Metric metric = (Metric)o;
        return Objects.equals(this.intrinsicTags, metric.getIntrinsicTags());
    }

    public int hashCode() {
        return Objects.hash(this.intrinsicTags);
    }

    public String toString() {
        return new StringJoiner(", ", ImmutableMetric.class.getSimpleName() + "[", "]").add("key='" + this.key + "'").add("tags=" + this.intrinsicTags).add("metaTags=" + this.metaTags).toString();
    }

    public static MetricBuilder builder() {
        return new MetricBuilder();
    }

    public static final class MetricBuilder {
        private final Set<Tag> intrinsicTags = new HashSet<Tag>();
        private final Set<Tag> metaTags = new HashSet<Tag>();

        public MetricBuilder intrinsicTag(Tag tag) {
            this.intrinsicTags.add(tag);
            return this;
        }

        public MetricBuilder intrinsicTag(String key, String value) {
            return this.intrinsicTag(new ImmutableTag(key, value));
        }

        public MetricBuilder intrinsicTag(String value) {
            return this.intrinsicTag(new ImmutableTag(value));
        }

        public MetricBuilder metaTag(Tag tag) {
            this.metaTags.add(tag);
            return this;
        }

        public MetricBuilder metaTag(String key, String value) {
            return this.metaTag(new ImmutableTag(key, value));
        }

        public MetricBuilder metaTag(String value) {
            return this.metaTag(new ImmutableTag(value));
        }

        public ImmutableMetric build() {
            return new ImmutableMetric(this.intrinsicTags, this.metaTags);
        }
    }
}

