/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.graph.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.graph.GraphInfo;

public final class ImmutableGraphInfo
implements GraphInfo {
    private final String namespace;
    private final String description;
    private final String label;

    private ImmutableGraphInfo(Builder builder) {
        this.namespace = builder.namespace;
        this.label = builder.label;
        this.description = builder.description;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableGraphInfo that = (ImmutableGraphInfo)o;
        return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.description, that.description) && Objects.equals(this.label, that.label);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.description, this.label);
    }

    public String toString() {
        return "ImmutableGraphInfo{namespace='" + this.namespace + '\'' + ", description='" + this.description + '\'' + ", label='" + this.label + '\'' + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder newBuilder(String namespace, String label, String description) {
        return new Builder().namespace(namespace).label(label).description(description);
    }

    public static Builder newBuilderFrom(GraphInfo fromGraphInfo) {
        return new Builder().graphInfo(fromGraphInfo);
    }

    public static GraphInfo immutableCopy(GraphInfo graphInfo) {
        if (graphInfo == null || graphInfo instanceof ImmutableGraphInfo) {
            return graphInfo;
        }
        return ImmutableGraphInfo.newBuilderFrom(graphInfo).build();
    }

    public static final class Builder {
        private String namespace;
        private String label;
        private String description;

        public Builder namespace(String namespace) {
            this.namespace = Objects.requireNonNull(namespace);
            return this;
        }

        public Builder label(String label) {
            this.label = Objects.requireNonNull(label);
            return this;
        }

        public Builder description(String description) {
            this.description = Objects.requireNonNull(description);
            return this;
        }

        public Builder graphInfo(GraphInfo graphInfo) {
            Objects.requireNonNull(graphInfo);
            this.namespace(graphInfo.getNamespace());
            this.label(graphInfo.getLabel());
            this.description(graphInfo.getDescription());
            return this;
        }

        public GraphInfo build() {
            return new ImmutableGraphInfo(this);
        }
    }
}

