/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.listener;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.xml.XmlFrameDecoder;
import io.netty.handler.logging.LoggingHandler;
import java.util.Objects;
import org.opennms.netmgt.config.api.EventdConfig;
import org.opennms.netmgt.eventd.listener.UdpListener;
import org.opennms.netmgt.eventd.listener.XmlEventProcessor;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpListener {
    private static final Logger LOG = LoggerFactory.getLogger(UdpListener.class);
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private ChannelFuture future;
    private final EventIpcManager eventIpcManager;
    private final EventdConfig config;

    public TcpListener(EventdConfig config, EventIpcManager eventIpcManager) {
        this.config = Objects.requireNonNull(config);
        this.eventIpcManager = Objects.requireNonNull(eventIpcManager);
    }

    public void start() throws InterruptedException {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler()});
                ch.pipeline().addLast(new ChannelHandler[]{new XmlFrameDecoder(Integer.MAX_VALUE)});
                ch.pipeline().addLast(new ChannelHandler[]{new XmlEventProcessor((EventForwarder)TcpListener.this.eventIpcManager)});
            }
        });
        this.future = b.bind(this.config.getTCPIpAddress(), this.config.getTCPPort()).sync().await();
    }

    public void stop() throws InterruptedException {
        LOG.info("Closing channel...");
        ChannelFuture cf = this.future.channel().closeFuture();
        LOG.info("Closing boss group...");
        this.workerGroup.shutdownGracefully().sync();
        this.bossGroup.shutdownGracefully().sync();
        cf.sync();
    }
}

