/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.api.model;

import java.util.Objects;
import org.opennms.netmgt.events.api.model.IOperAction;

public final class ImmutableOperAction
implements IOperAction {
    private String content;
    private String state;
    private String menutext;

    private ImmutableOperAction(Builder builder) {
        this.content = builder.content;
        this.state = builder.state;
        this.menutext = builder.menutext;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(IOperAction operAction) {
        return new Builder(operAction);
    }

    public static IOperAction immutableCopy(IOperAction operAction) {
        if (operAction == null || operAction instanceof ImmutableOperAction) {
            return operAction;
        }
        return ImmutableOperAction.newBuilderFrom(operAction).build();
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public String getMenutext() {
        return this.menutext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableOperAction that = (ImmutableOperAction)o;
        return Objects.equals(this.content, that.content) && Objects.equals(this.state, that.state) && Objects.equals(this.menutext, that.menutext);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.state, this.menutext);
    }

    public String toString() {
        return "ImmutableOperAction{content='" + this.content + '\'' + ", state='" + this.state + '\'' + ", menutext='" + this.menutext + '\'' + '}';
    }

    public static final class Builder {
        private String content;
        private String state;
        private String menutext;

        private Builder() {
        }

        public Builder(IOperAction operAction) {
            this.content = operAction.getContent();
            this.state = operAction.getState();
            this.menutext = operAction.getMenutext();
        }

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public Builder setState(String state) {
            this.state = state;
            return this;
        }

        public Builder setMenutext(String menutext) {
            this.menutext = menutext;
            return this;
        }

        public ImmutableOperAction build() {
            return new ImmutableOperAction(this);
        }
    }
}

