/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.api.model;

import java.util.Objects;
import org.opennms.netmgt.events.api.model.IManagedObject;

public final class ImmutableManagedObject
implements IManagedObject {
    private final String type;

    private ImmutableManagedObject(Builder builder) {
        this.type = builder.type;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(IManagedObject managedObject) {
        return new Builder(managedObject);
    }

    public static IManagedObject immutableCopy(IManagedObject managedObject) {
        if (managedObject == null || managedObject instanceof ImmutableManagedObject) {
            return managedObject;
        }
        return ImmutableManagedObject.newBuilderFrom(managedObject).build();
    }

    @Override
    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableManagedObject that = (ImmutableManagedObject)o;
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    public String toString() {
        return "ImmutableManagedObject{type='" + this.type + '\'' + '}';
    }

    public static final class Builder {
        private String type;

        private Builder() {
        }

        public Builder(IManagedObject managedObject) {
            this.type = managedObject.getType();
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public ImmutableManagedObject build() {
            return new ImmutableManagedObject(this);
        }
    }
}

