/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.api.model;

import java.util.Objects;
import org.opennms.netmgt.events.api.model.IAutoAction;

public final class ImmutableAutoAction
implements IAutoAction {
    private final String content;
    private final String state;

    private ImmutableAutoAction(Builder builder) {
        this.content = builder.content;
        this.state = builder.state;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(IAutoAction autoAction) {
        return new Builder(autoAction);
    }

    public static IAutoAction immutableCopy(IAutoAction autoAction) {
        if (autoAction == null || autoAction instanceof ImmutableAutoAction) {
            return autoAction;
        }
        return ImmutableAutoAction.newBuilderFrom(autoAction).build();
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public String getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableAutoAction that = (ImmutableAutoAction)o;
        return Objects.equals(this.content, that.content) && Objects.equals(this.state, that.state);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.state);
    }

    public String toString() {
        return "ImmutableAutoAction{content='" + this.content + '\'' + ", state='" + this.state + '\'' + '}';
    }

    public static final class Builder {
        private String content;
        private String state;

        private Builder() {
        }

        public Builder(IAutoAction autoAction) {
            this.content = autoAction.getContent();
            this.state = autoAction.getState();
        }

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public Builder setState(String state) {
            this.state = state;
            return this;
        }

        public ImmutableAutoAction build() {
            return new ImmutableAutoAction(this);
        }
    }
}

