/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.api.model;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.opennms.core.utils.ImmutableCollections;
import org.opennms.core.utils.MutableCollections;
import org.opennms.netmgt.events.api.model.IAlarmData;
import org.opennms.netmgt.events.api.model.IManagedObject;
import org.opennms.netmgt.events.api.model.IUpdateField;
import org.opennms.netmgt.events.api.model.ImmutableManagedObject;
import org.opennms.netmgt.events.api.model.ImmutableUpdateField;

public final class ImmutableAlarmData
implements IAlarmData {
    private final String reductionKey;
    private final Integer alarmType;
    private final String clearKey;
    private final Boolean autoClean;
    private final String x733AlarmType;
    private final Integer x733ProbableCause;
    private final List<IUpdateField> updateFieldList;
    private final IManagedObject managedObject;

    private ImmutableAlarmData(Builder builder) {
        this.reductionKey = builder.reductionKey;
        this.alarmType = builder.alarmType;
        this.clearKey = builder.clearKey;
        this.autoClean = builder.autoClean;
        this.x733AlarmType = builder.x733AlarmType;
        this.x733ProbableCause = builder.x733ProbableCause;
        this.updateFieldList = ImmutableCollections.with(ImmutableUpdateField::immutableCopyFrom).newList((Collection)builder.updateFieldList);
        this.managedObject = ImmutableManagedObject.immutableCopy(builder.managedObject);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(IAlarmData alarmData) {
        return new Builder(alarmData);
    }

    public static IAlarmData immutableCopy(IAlarmData alarmData) {
        if (alarmData == null || alarmData instanceof ImmutableAlarmData) {
            return alarmData;
        }
        return ImmutableAlarmData.newBuilderFrom(alarmData).build();
    }

    @Override
    public Integer getAlarmType() {
        return this.alarmType == null ? 0 : this.alarmType;
    }

    @Override
    public boolean hasAlarmType() {
        return this.alarmType != null;
    }

    @Override
    public Boolean getAutoClean() {
        return this.autoClean == null ? false : this.autoClean;
    }

    @Override
    public boolean hasAutoClean() {
        return this.autoClean != null;
    }

    @Override
    public String getClearKey() {
        return this.clearKey;
    }

    @Override
    public String getReductionKey() {
        return this.reductionKey;
    }

    @Override
    public String getX733AlarmType() {
        return this.x733AlarmType;
    }

    @Override
    public Integer getX733ProbableCause() {
        return this.x733ProbableCause == null ? 0 : this.x733ProbableCause;
    }

    @Override
    public boolean hasX733ProbableCause() {
        return this.x733ProbableCause != null;
    }

    @Override
    public Boolean isAutoClean() {
        return this.getAutoClean();
    }

    @Override
    public List<IUpdateField> getUpdateFieldList() {
        return this.updateFieldList;
    }

    @Override
    public Boolean hasUpdateFields() {
        return this.updateFieldList != null && !this.updateFieldList.isEmpty();
    }

    @Override
    public IManagedObject getManagedObject() {
        return this.managedObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableAlarmData that = (ImmutableAlarmData)o;
        return Objects.equals(this.reductionKey, that.reductionKey) && Objects.equals(this.alarmType, that.alarmType) && Objects.equals(this.clearKey, that.clearKey) && Objects.equals(this.autoClean, that.autoClean) && Objects.equals(this.x733AlarmType, that.x733AlarmType) && Objects.equals(this.x733ProbableCause, that.x733ProbableCause) && Objects.equals(this.updateFieldList, that.updateFieldList) && Objects.equals(this.managedObject, that.managedObject);
    }

    public int hashCode() {
        return Objects.hash(this.reductionKey, this.alarmType, this.clearKey, this.autoClean, this.x733AlarmType, this.x733ProbableCause, this.updateFieldList, this.managedObject);
    }

    public String toString() {
        return "ImmutableAlarmData{reductionKey='" + this.reductionKey + '\'' + ", alarmType=" + this.alarmType + ", clearKey='" + this.clearKey + '\'' + ", autoClean=" + this.autoClean + ", x733AlarmType='" + this.x733AlarmType + '\'' + ", x733ProbableCause=" + this.x733ProbableCause + ", updateFieldList=" + this.updateFieldList + ", managedObject=" + this.managedObject + '}';
    }

    public static final class Builder {
        private String reductionKey;
        private Integer alarmType;
        private String clearKey;
        private Boolean autoClean;
        private String x733AlarmType;
        private Integer x733ProbableCause;
        private List<IUpdateField> updateFieldList;
        private IManagedObject managedObject;

        private Builder() {
        }

        public Builder(IAlarmData alarmData) {
            this.reductionKey = alarmData.getReductionKey();
            this.alarmType = alarmData.getAlarmType();
            this.clearKey = alarmData.getClearKey();
            this.autoClean = alarmData.getAutoClean();
            this.x733AlarmType = alarmData.getX733AlarmType();
            this.x733ProbableCause = alarmData.getX733ProbableCause();
            this.updateFieldList = MutableCollections.copyListFromNullable(alarmData.getUpdateFieldList());
            this.managedObject = alarmData.getManagedObject();
        }

        public Builder setReductionKey(String reductionKey) {
            this.reductionKey = reductionKey;
            return this;
        }

        public Builder setAlarmType(Integer alarmType) {
            this.alarmType = alarmType;
            return this;
        }

        public Builder setClearKey(String clearKey) {
            this.clearKey = clearKey;
            return this;
        }

        public Builder setAutoClean(Boolean autoClean) {
            this.autoClean = autoClean;
            return this;
        }

        public Builder setX733AlarmType(String x733AlarmType) {
            this.x733AlarmType = x733AlarmType;
            return this;
        }

        public Builder setX733ProbableCause(Integer x733ProbableCause) {
            this.x733ProbableCause = x733ProbableCause;
            return this;
        }

        public Builder setUpdateFieldList(List<IUpdateField> updateFieldList) {
            this.updateFieldList = updateFieldList;
            return this;
        }

        public Builder setManagedObject(IManagedObject managedObject) {
            this.managedObject = managedObject;
            return this;
        }

        public ImmutableAlarmData build() {
            return new ImmutableAlarmData(this);
        }
    }
}

