/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.utils.mate;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.core.rpc.utils.mate.ContextKey;
import org.opennms.core.rpc.utils.mate.Scope;

public class FallbackScope
implements Scope {
    private final List<Scope> scopes;

    public FallbackScope(List<Scope> scopes) {
        this.scopes = ImmutableList.copyOf(scopes).reverse();
    }

    public FallbackScope(Scope ... scopes) {
        this.scopes = ImmutableList.copyOf((Object[])scopes).reverse();
    }

    @Override
    public Optional<String> get(ContextKey contextKey) {
        return this.scopes.stream().map(scope -> scope.get(contextKey)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @Override
    public Set<ContextKey> keys() {
        return this.scopes.stream().flatMap(scope -> scope.keys().stream()).collect(Collectors.toSet());
    }
}

