/*
 * Decompiled with CFR 0.152.
 */
package simple.http.load;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import simple.http.Request;
import simple.http.Response;
import simple.http.load.Loader;
import simple.http.load.LoaderPermission;
import simple.http.load.LoaderStub;
import simple.http.load.LoadingException;
import simple.http.load.Processor;
import simple.http.load.Profile;
import simple.http.load.Registry;
import simple.http.load.Service;
import simple.http.serve.CacheContext;
import simple.http.serve.Component;
import simple.http.serve.Context;
import simple.http.serve.Resource;
import simple.http.serve.ResourceEngine;
import simple.http.serve.StatusReport;
import simple.util.Match;
import simple.util.Resolver;

public class LoaderEngine
extends LoaderStub
implements ResourceEngine {
    protected Resolver resolver;
    protected Processor delegate;
    protected Context context;
    protected Registry registry;
    protected Profile profile;

    public LoaderEngine() throws IOException {
        this(new CacheContext());
    }

    public LoaderEngine(Context context) throws IOException {
        this(context, new File(context.getBasePath()));
    }

    protected LoaderEngine(Context context, File path) throws IOException {
        this(context, path.getCanonicalFile().toURL());
    }

    public LoaderEngine(Context context, URL codebase) throws IOException {
        this(context, new URL[]{codebase});
    }

    public LoaderEngine(Context context, URL[] codebase) throws IOException {
        this.registry = new Registry(context, codebase);
        this.resolver = new Resolver();
        this.delegate = new Processor(this);
        this.profile = new Profile(this);
        this.context = context;
    }

    public synchronized void update(String name, Loader loader) {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(new LoaderPermission("update"));
        }
        this.delegate.add(name, loader);
        this.delegate.update(this.profile);
    }

    public synchronized void remove(String name) {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(new LoaderPermission("update"));
        }
        this.delegate.remove(name);
    }

    public synchronized void load(String name, String className) throws LoadingException {
        this.load(name, className, new Object[0]);
    }

    public synchronized void load(String name, String className, Object data) throws LoadingException {
        this.load(name, className, new Object[]{data});
    }

    public synchronized void load(String name, String className, Object[] data) throws LoadingException {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(new LoaderPermission("load"));
        }
        Service service = this.registry.load(name, className);
        service.prepare(this, data);
        this.delegate.update(this.profile);
    }

    public synchronized void unload(String name) {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(new LoaderPermission("load"));
        }
        Match[] list = this.resolver.getMatches();
        int i = 0;
        while (i < list.length) {
            if (list[i].getMatch().equals(name)) {
                this.resolver.remove(list[i]);
            }
            ++i;
        }
        this.registry.remove(name);
        this.delegate.update(this.profile);
    }

    public synchronized void link(String pattern, String name) {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(new LoaderPermission("link"));
        }
        if (this.registry.contains(name)) {
            this.resolver.insert(pattern, name);
            this.delegate.update(this.profile);
        }
    }

    public synchronized void link(String pattern, String name, int pos) {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(new LoaderPermission("link"));
        }
        if (this.registry.contains(name)) {
            this.resolver.insert(pattern, name, pos);
            this.delegate.update(this.profile);
        }
    }

    public synchronized void unlink(String pattern) {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(new LoaderPermission("link"));
        }
        if (this.resolver.contains(pattern)) {
            this.resolver.remove(pattern);
            this.delegate.update(this.profile);
        }
    }

    public synchronized void unlink(Match match) {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(new LoaderPermission("link"));
        }
        if (this.resolver.contains(match)) {
            this.resolver.remove(match);
            this.delegate.update(this.profile);
        }
    }

    public synchronized Resource lookup(String name) {
        if (this.registry.contains(name)) {
            return this.registry.retrieve(name);
        }
        return new Delegate(this.context);
    }

    public synchronized Resource resolve(String target) {
        String path = this.context.getRequestPath(target);
        String name = this.resolver.resolve(path);
        if (this.registry.contains(name)) {
            return this.registry.retrieve(name);
        }
        return new Delegate(this.context);
    }

    private class Delegate
    extends Component {
        public Delegate(Context context) {
            this.context = context;
        }

        public void process(Request req, Response resp) {
            this.handle(req, resp, new StatusReport(404));
        }
    }
}

