/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.opennms.netmgt.dao.api.GenericPersistenceAccessor;
import org.opennms.netmgt.dao.hibernate.HibernateCriteriaConverter;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class GenericHibernateAccessor
extends HibernateDaoSupport
implements GenericPersistenceAccessor {
    protected final HibernateCriteriaConverter criteriaConverter = new HibernateCriteriaConverter();

    public <T> List<T> find(String query) {
        return this.getHibernateTemplate().find(query);
    }

    public <T> List<T> find(String query, Object ... values) {
        return this.getHibernateTemplate().find(query, values);
    }

    public <T> List<T> findUsingNamedParameters(String query, String[] paramNames, Object[] values) {
        return this.getHibernateTemplate().findByNamedParam(query, paramNames, values);
    }

    public <T> List<T> findUsingNamedParameters(String query, String[] paramNames, Object[] values, Integer offset, Integer limit) {
        if (limit == null && offset == null) {
            return this.findUsingNamedParameters(query, paramNames, values);
        }
        if (paramNames.length != values.length) {
            throw new IllegalArgumentException("Length of paramNames array must match length of values array");
        }
        return (List)this.getHibernateTemplate().executeWithNativeSession(session -> {
            Query queryObject = session.createQuery(query);
            this.prepareQuery(queryObject);
            if (offset != null) {
                queryObject.setFirstResult(offset.intValue());
            }
            if (limit != null) {
                queryObject.setMaxResults(limit.intValue());
            }
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    GenericHibernateAccessor.applyNamedParameterToQuery(queryObject, paramNames[i], values[i]);
                }
            }
            return queryObject.list();
        });
    }

    public <T> List<T> executeNativeQuery(String sql, Map<String, Object> parameterMap) {
        List result = (List)this.getHibernateTemplate().execute(session -> {
            SQLQuery query = session.createSQLQuery(sql);
            if (parameterMap != null) {
                parameterMap.entrySet().forEach(arg_0 -> GenericHibernateAccessor.lambda$null$1((Query)query, arg_0));
            }
            return query.list();
        });
        return result;
    }

    public <T> T get(Class<T> entityType, int entityId) {
        return (T)this.getHibernateTemplate().get(entityType, (Serializable)Integer.valueOf(entityId));
    }

    public List findMatching(final org.opennms.core.criteria.Criteria criteria) {
        HibernateCallback<List> callback = new HibernateCallback<List>(){

            public List doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria hibernateCriteria = GenericHibernateAccessor.this.criteriaConverter.convert(criteria, session);
                return hibernateCriteria.list();
            }
        };
        return (List)this.getHibernateTemplate().execute((HibernateCallback)callback);
    }

    public <T> void saveAll(Collection<T> entities) {
        for (T entity : entities) {
            this.save(entity);
        }
    }

    public <T> T save(T entity) {
        return (T)this.getHibernateTemplate().save(entity);
    }

    public <T> void deleteAll(Class<T> clazz) {
        String sql = String.format("delete from %s entity", clazz.getSimpleName());
        this.getHibernateTemplate().bulkUpdate(sql);
    }

    public <T> void deleteAll(Collection<T> entities) {
        this.getHibernateTemplate().deleteAll(entities);
    }

    public <T> List<T> findAll(Class<T> entityClass) throws DataAccessException {
        return this.getHibernateTemplate().loadAll(entityClass);
    }

    private void prepareQuery(Query queryObject) {
        if (this.getHibernateTemplate().isCacheQueries()) {
            queryObject.setCacheable(true);
            if (this.getHibernateTemplate().getQueryCacheRegion() != null) {
                queryObject.setCacheRegion(this.getHibernateTemplate().getQueryCacheRegion());
            }
        }
        if (this.getHibernateTemplate().getFetchSize() > 0) {
            queryObject.setFetchSize(this.getHibernateTemplate().getFetchSize());
        }
        if (this.getHibernateTemplate().getMaxResults() > 0) {
            queryObject.setMaxResults(this.getHibernateTemplate().getMaxResults());
        }
    }

    private static void applyNamedParameterToQuery(Query queryObject, String paramName, Object value) throws HibernateException {
        if (value instanceof Collection) {
            queryObject.setParameterList(paramName, (Collection)value);
        } else if (value instanceof Object[]) {
            queryObject.setParameterList(paramName, (Object[])value);
        } else {
            queryObject.setParameter(paramName, value);
        }
    }

    private static /* synthetic */ void lambda$null$1(Query query, Map.Entry entry) {
        if (entry.getValue() instanceof Collection) {
            query.setParameterList((String)entry.getKey(), (Collection)entry.getValue());
        } else {
            query.setParameter((String)entry.getKey(), entry.getValue());
        }
    }
}

