/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.config.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import org.opennms.core.config.api.ConfigurationProvider;
import org.opennms.core.config.api.ReloadingContainer;
import org.opennms.core.soa.Registration;
import org.opennms.core.soa.RegistrationListener;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.soa.support.DefaultServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigReloadContainer<V>
implements ReloadingContainer<V>,
RegistrationListener<ConfigurationProvider> {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigReloadContainer.class);
    private static final long DEFAULT_RELOAD_CHECK_INTERVAL_MS = 5000L;
    private static final ServiceRegistry REGISTRY = DefaultServiceRegistry.INSTANCE;
    private final Class<V> clazz;
    private long reloadCheckIntervalInMs;
    private BinaryOperator<V> folder;
    private V object;
    private long lastUpdate = -1L;
    private long lastReloadCheck = 0L;
    private boolean forceReload = false;
    private final Set<ConfigurationProviderState<V>> providers = new LinkedHashSet<ConfigurationProviderState<V>>();

    private ConfigReloadContainer(Builder<V> builder) {
        this.clazz = ((Builder)builder).clazz;
        this.object = ((Builder)builder).initialConfig;
        if (this.object != null) {
            this.lastUpdate = ((Builder)builder).lastUpdate != null ? ((Builder)builder).lastUpdate.getTime() : System.currentTimeMillis();
            this.lastReloadCheck = System.currentTimeMillis();
        }
        this.reloadCheckIntervalInMs = ((Builder)builder).reloadCheckIntervalInMs == null ? 5000L : (((Builder)builder).reloadCheckIntervalInMs <= 0L ? -1L : ((Builder)builder).reloadCheckIntervalInMs);
        ((Builder)builder).providers.forEach(p -> this.providers.add(new ConfigurationProviderState((ConfigurationProvider)p)));
        this.folder = ((Builder)builder).folder;
        REGISTRY.addListener(ConfigurationProvider.class, (RegistrationListener)this, true);
    }

    @Override
    public V getObject() {
        this.checkForUpdates();
        return this.object;
    }

    @Override
    public void reload() {
        this.object = this.providers.isEmpty() ? null : (this.providers.size() == 1 ? ((ConfigurationProviderState)this.providers.iterator().next()).load() : this.providers.stream().map(rec$ -> ((ConfigurationProviderState)rec$).load()).filter(Objects::nonNull).reduce(this.folder).orElse(null));
    }

    @Override
    public void setReloadCheckInterval(Long reloadCheckInterval) {
        this.reloadCheckIntervalInMs = reloadCheckInterval == null ? 5000L : (reloadCheckInterval <= 0L ? -1L : reloadCheckInterval);
    }

    @Override
    public Long getLastUpdate() {
        return this.lastUpdate;
    }

    private synchronized void checkForUpdates() {
        if (!(this.forceReload || this.reloadCheckIntervalInMs >= 0L && System.currentTimeMillis() >= this.lastReloadCheck + this.reloadCheckIntervalInMs)) {
            return;
        }
        this.lastReloadCheck = System.currentTimeMillis();
        if (this.providers.size() < 1) {
            return;
        }
        if (this.forceReload || this.providers.stream().anyMatch(rec$ -> ((ConfigurationProviderState)rec$).shouldReload())) {
            this.reload();
        }
    }

    public void providerRegistered(Registration registration, ConfigurationProvider provider) {
        if (this.clazz.equals(((ConfigurationProvider)registration.getProvider(ConfigurationProvider.class)).getType()) && this.providers.add(new ConfigurationProviderState(provider))) {
            LOG.debug("Registered configuration provider {} for {}.", (Object)provider, (Object)this.clazz.getCanonicalName());
            this.forceReload = true;
        }
    }

    public void providerUnregistered(Registration registration, ConfigurationProvider provider) {
        if (this.providers.remove(new ConfigurationProviderState(provider))) {
            LOG.debug("Unregistered configuration provider {} for {}.", (Object)provider, (Object)this.clazz.getCanonicalName());
            this.forceReload = true;
        }
    }

    private static class ConfigurationProviderState<V> {
        private final ConfigurationProvider provider;
        private long lastLoad;

        private ConfigurationProviderState(ConfigurationProvider provider) {
            this.provider = Objects.requireNonNull(provider);
        }

        private V load() {
            Object object = this.provider.getObject();
            this.lastLoad = System.currentTimeMillis();
            return (V)object;
        }

        private boolean shouldReload() {
            return this.lastLoad <= this.provider.getLastUpdate();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigurationProviderState that = (ConfigurationProviderState)o;
            return Objects.equals(this.provider, that.provider);
        }

        public int hashCode() {
            return Objects.hash(this.provider);
        }
    }

    public static class Builder<V> {
        private final Class<V> clazz;
        private V initialConfig;
        private Date lastUpdate;
        private Long reloadCheckIntervalInMs = 5000L;
        private List<ConfigurationProvider> providers = new ArrayList<ConfigurationProvider>();
        private BinaryOperator<V> folder;

        public Builder(Class<V> clazz) {
            this.clazz = Objects.requireNonNull(clazz);
        }

        public Builder<V> withInitialConfig(V config) {
            this.initialConfig = config;
            return this;
        }

        public Builder<V> withLastUpdate(Date lastUpdate) {
            this.lastUpdate = lastUpdate;
            return this;
        }

        public Builder<V> withProvider(ConfigurationProvider provider) {
            this.providers.add(provider);
            return this;
        }

        public Builder<V> withFolder(BiConsumer<V, V> folder) {
            this.folder = (a, b) -> {
                folder.accept(a, b);
                return a;
            };
            return this;
        }

        public Builder<V> withReloadCheckInterval(Long reloadCheckIntervalInMs) {
            this.reloadCheckIntervalInMs = reloadCheckIntervalInMs;
            return this;
        }

        public ConfigReloadContainer<V> build() {
            if (this.lastUpdate != null) {
                if (this.initialConfig == null) {
                    throw new IllegalArgumentException("Cannot set last update when no initial configuration is supplied.");
                }
                if (this.lastUpdate.compareTo(new Date()) > 0) {
                    throw new IllegalArgumentException("Last update date cannot be in the future!");
                }
            }
            return new ConfigReloadContainer(this);
        }
    }
}

