/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.daemon;

import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaemonTools {
    public static final Logger LOG = LoggerFactory.getLogger(DaemonTools.class);

    public static void handleReloadEvent(Event e, String daemonName, Consumer<Event> handleConfigurationChanged) {
        Parm daemonNameParm = e.getParm("daemonName");
        if (daemonNameParm == null || daemonNameParm.getValue() == null) {
            LOG.warn("The {} parameter has no value. Ignoring.", (Object)"daemonName");
            return;
        }
        if (daemonName.equalsIgnoreCase(daemonNameParm.getValue().getContent())) {
            LOG.info("Reloading {}.", (Object)daemonName);
            EventBuilder ebldr = null;
            try {
                handleConfigurationChanged.accept(e);
                LOG.info("Reload successful.");
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", daemonName);
                ebldr.addParam("daemonName", daemonName);
            }
            catch (Exception t) {
                LOG.error("Reload failed.", (Throwable)t);
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", daemonName);
                ebldr.addParam("reason", StringUtils.abbreviate((String)t.getLocalizedMessage(), (int)128));
            }
            ebldr.addParam("daemonName", daemonName);
            EventIpcManagerFactory.getIpcManager().sendNow(ebldr.getEvent());
        }
    }
}

