/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.scriptd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipse.persistence.oxm.annotations.XmlPath;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.scriptd.MixedContentAdapter;
import org.opennms.netmgt.config.scriptd.Uei;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="event-script")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="", propOrder={"m_language", "m_ueis", "m_content"})
@ValidateUsing(value="scriptd-configuration.xsd")
public class EventScript
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="language", required=true)
    private String m_language;
    @XmlElement(name="uei")
    private List<Uei> m_ueis = new ArrayList<Uei>();
    @XmlPath(value=".")
    @XmlJavaTypeAdapter(value=MixedContentAdapter.class)
    private String m_content;

    public String getLanguage() {
        return this.m_language;
    }

    public void setLanguage(String language) {
        this.m_language = ConfigUtils.assertNotEmpty(language, "language");
    }

    public List<Uei> getUeis() {
        return this.m_ueis;
    }

    public void setUeis(List<Uei> ueis) {
        if (ueis == this.m_ueis) {
            return;
        }
        this.m_ueis.clear();
        if (ueis != null) {
            this.m_ueis.addAll(ueis);
        }
    }

    public void addUei(Uei uei) {
        this.m_ueis.add(uei);
    }

    public boolean removeUei(Uei uei) {
        return this.m_ueis.remove(uei);
    }

    public Optional<String> getContent() {
        return Optional.ofNullable(this.m_content);
    }

    public void setContent(String content) {
        this.m_content = ConfigUtils.normalizeString(content);
    }

    public int hashCode() {
        return Objects.hash(this.m_language, this.m_content, this.m_ueis);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EventScript) {
            EventScript that = (EventScript)obj;
            return Objects.equals(this.m_language, that.m_language) && Objects.equals(this.m_content, that.m_content) && Objects.equals(this.m_ueis, that.m_ueis);
        }
        return false;
    }
}

