/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.topology;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.features.apilayer.utils.EdgeMapper;
import org.opennms.features.apilayer.utils.InterfaceMapper;
import org.opennms.features.apilayer.utils.ModelMappers;
import org.opennms.integration.api.v1.model.TopologyEdge;
import org.opennms.integration.api.v1.topology.TopologyEdgeConsumer;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyConsumer;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyEdge;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyMessage;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;
import org.opennms.netmgt.topologies.service.api.TopologyVisitor;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyEdgeConsumerManager
extends InterfaceMapper<TopologyEdgeConsumer, OnmsTopologyConsumer> {
    private static final Logger LOG = LoggerFactory.getLogger(TopologyEdgeConsumerManager.class);
    private final EdgeMapper edgeMapper;

    public TopologyEdgeConsumerManager(BundleContext bundleContext, EdgeMapper edgeMapper) {
        super(OnmsTopologyConsumer.class, bundleContext);
        this.edgeMapper = Objects.requireNonNull(edgeMapper);
    }

    @Override
    public OnmsTopologyConsumer map(final TopologyEdgeConsumer ext) {
        return new OnmsTopologyConsumer(){

            public String getName() {
                return ext.getClass().getName();
            }

            public Set<OnmsTopologyProtocol> getProtocols() {
                if (ext.getProtocols() == null) {
                    LOG.debug("Protocols was null, returning empty set");
                    return Collections.emptySet();
                }
                LOG.trace("Returning mapped protocols from {}", (Object)ext.getProtocols());
                return ext.getProtocols().stream().map(ModelMappers::toOnmsTopologyProtocol).collect(Collectors.toSet());
            }

            public void consume(final OnmsTopologyMessage message) {
                message.getMessagebody().accept(new TopologyVisitor(){

                    public void visit(OnmsTopologyEdge edge) {
                        TopologyEdge topologyEdge = TopologyEdgeConsumerManager.this.edgeMapper.toEdge(message.getProtocol(), edge);
                        switch (message.getMessagestatus()) {
                            case UPDATE: {
                                LOG.trace("Mapped topology message {} to topology edge {} for add/update", (Object)message, (Object)topologyEdge);
                                ext.onEdgeAddedOrUpdated(topologyEdge);
                                break;
                            }
                            case DELETE: {
                                LOG.trace("Mapped topology message {} to topology edge {} for delete", (Object)message, (Object)topologyEdge);
                                ext.onEdgeDeleted(topologyEdge);
                                break;
                            }
                            default: {
                                LOG.warn("Unsupported message status of {}", (Object)message.getMessagestatus());
                            }
                        }
                    }
                });
            }
        };
    }
}

