/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.model.mappers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.mapstruct.factory.Mappers;
import org.opennms.features.apilayer.model.mappers.IpInterfaceMapper;
import org.opennms.features.apilayer.model.mappers.MetaDataMapper;
import org.opennms.features.apilayer.model.mappers.NodeAssetRecordMapper;
import org.opennms.features.apilayer.model.mappers.NodeMapper;
import org.opennms.features.apilayer.model.mappers.SnmpInterfaceMapper;
import org.opennms.integration.api.v1.model.IpInterface;
import org.opennms.integration.api.v1.model.MetaData;
import org.opennms.integration.api.v1.model.NodeAssetRecord;
import org.opennms.integration.api.v1.model.SnmpInterface;
import org.opennms.integration.api.v1.model.immutables.ImmutableNode;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMetaData;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;

public class NodeMapperImpl
implements NodeMapper {
    private final NodeAssetRecordMapper nodeAssetRecordMapper = (NodeAssetRecordMapper)Mappers.getMapper(NodeAssetRecordMapper.class);
    private final IpInterfaceMapper ipInterfaceMapper = (IpInterfaceMapper)Mappers.getMapper(IpInterfaceMapper.class);
    private final SnmpInterfaceMapper snmpInterfaceMapper = (SnmpInterfaceMapper)Mappers.getMapper(SnmpInterfaceMapper.class);
    private final MetaDataMapper metaDataMapper = (MetaDataMapper)Mappers.getMapper(MetaDataMapper.class);

    @Override
    public ImmutableNode map(OnmsNode onmsNode) {
        if (onmsNode == null) {
            return null;
        }
        ImmutableNode.Builder immutableNode = ImmutableNode.newBuilder();
        if (onmsNode.getId() != null) {
            immutableNode.setId(onmsNode.getId().intValue());
        }
        immutableNode.setForeignSource(onmsNode.getForeignSource());
        immutableNode.setForeignId(onmsNode.getForeignId());
        immutableNode.setLabel(onmsNode.getLabel());
        immutableNode.setLocation(this.mapLocation(onmsNode.getLocation()));
        immutableNode.setAssetRecord((NodeAssetRecord)this.nodeAssetRecordMapper.map(onmsNode.getAssetRecord()));
        immutableNode.setIpInterfaces(this.onmsIpInterfaceSetToIpInterfaceList(onmsNode.getIpInterfaces()));
        immutableNode.setSnmpInterfaces(this.onmsSnmpInterfaceSetToSnmpInterfaceList(onmsNode.getSnmpInterfaces()));
        immutableNode.setMetaData(this.onmsMetaDataListToMetaDataList(onmsNode.getMetaData()));
        return immutableNode.build();
    }

    protected List<IpInterface> onmsIpInterfaceSetToIpInterfaceList(Set<OnmsIpInterface> set) {
        if (set == null) {
            return null;
        }
        ArrayList<IpInterface> list = new ArrayList<IpInterface>(set.size());
        for (OnmsIpInterface onmsIpInterface : set) {
            list.add((IpInterface)this.ipInterfaceMapper.map(onmsIpInterface));
        }
        return list;
    }

    protected List<SnmpInterface> onmsSnmpInterfaceSetToSnmpInterfaceList(Set<OnmsSnmpInterface> set) {
        if (set == null) {
            return null;
        }
        ArrayList<SnmpInterface> list = new ArrayList<SnmpInterface>(set.size());
        for (OnmsSnmpInterface onmsSnmpInterface : set) {
            list.add((SnmpInterface)this.snmpInterfaceMapper.map(onmsSnmpInterface));
        }
        return list;
    }

    protected List<MetaData> onmsMetaDataListToMetaDataList(List<OnmsMetaData> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MetaData> list1 = new ArrayList<MetaData>(list.size());
        for (OnmsMetaData onmsMetaData : list) {
            list1.add((MetaData)this.metaDataMapper.map(onmsMetaData));
        }
        return list1;
    }
}

