/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.alarms;

import java.util.Objects;
import org.opennms.features.apilayer.utils.InterfaceMapper;
import org.opennms.features.apilayer.utils.ModelMappers;
import org.opennms.integration.api.v1.alarms.AlarmPersisterExtension;
import org.opennms.integration.api.v1.model.Alarm;
import org.opennms.integration.api.v1.model.DatabaseEvent;
import org.opennms.integration.api.v1.model.InMemoryEvent;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.xml.event.Event;
import org.osgi.framework.BundleContext;

public class AlarmPersisterExtensionManager
extends InterfaceMapper<AlarmPersisterExtension, org.opennms.netmgt.alarmd.api.AlarmPersisterExtension> {
    private final SessionUtils sessionUtils;

    public AlarmPersisterExtensionManager(BundleContext bundleContext, SessionUtils sessionUtils) {
        super(org.opennms.netmgt.alarmd.api.AlarmPersisterExtension.class, bundleContext);
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
    }

    @Override
    public org.opennms.netmgt.alarmd.api.AlarmPersisterExtension map(final AlarmPersisterExtension ext) {
        return new org.opennms.netmgt.alarmd.api.AlarmPersisterExtension(){

            public void afterAlarmCreated(OnmsAlarm alarm, Event event, OnmsEvent dbEvent) {
                Alarm mappedAlarm = ModelMappers.toAlarm(alarm);
                InMemoryEvent inMemoryEvent = ModelMappers.toEvent(event);
                DatabaseEvent databaseEvent = ModelMappers.toEvent(dbEvent);
                Alarm updatedAlarm = ext.afterAlarmCreated(mappedAlarm, inMemoryEvent, databaseEvent);
                AlarmPersisterExtensionManager.this.maybeUpdateAlarm(alarm, updatedAlarm);
            }

            public void afterAlarmUpdated(OnmsAlarm alarm, Event event, OnmsEvent dbEvent) {
                Alarm mappedAlarm = ModelMappers.toAlarm(alarm);
                InMemoryEvent inMemoryEvent = ModelMappers.toEvent(event);
                DatabaseEvent databaseEvent = ModelMappers.toEvent(dbEvent);
                Alarm updatedAlarm = ext.afterAlarmUpdated(mappedAlarm, inMemoryEvent, databaseEvent);
                AlarmPersisterExtensionManager.this.maybeUpdateAlarm(alarm, updatedAlarm);
            }
        };
    }

    private void maybeUpdateAlarm(OnmsAlarm alarm, Alarm updatedAlarm) {
        if (updatedAlarm == null) {
            return;
        }
        this.sessionUtils.withManualFlush(() -> {
            alarm.setManagedObjectInstance(updatedAlarm.getManagedObjectInstance());
            alarm.setManagedObjectType(updatedAlarm.getManagedObjectType());
            return null;
        });
    }
}

