/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.persist.AbstractRequisitionVisitor;
import org.opennms.netmgt.provision.persist.OnmsAssetRequisition;
import org.opennms.netmgt.provision.persist.OnmsInterfaceMetaDataRequisition;
import org.opennms.netmgt.provision.persist.OnmsIpInterfaceRequisition;
import org.opennms.netmgt.provision.persist.OnmsMonitoredServiceRequisition;
import org.opennms.netmgt.provision.persist.OnmsNodeCategoryRequisition;
import org.opennms.netmgt.provision.persist.OnmsNodeMetaDataRequisition;
import org.opennms.netmgt.provision.persist.OnmsServiceMetaDataRequisition;
import org.opennms.netmgt.provision.persist.RequisitionVisitor;
import org.opennms.netmgt.provision.persist.requisition.RequisitionAsset;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnmsNodeRequisition {
    private static final Logger LOG = LoggerFactory.getLogger(OnmsNodeRequisition.class);
    private String m_foreignSource;
    private RequisitionNode m_node;
    private List<OnmsAssetRequisition> m_assetReqs;
    private List<OnmsNodeMetaDataRequisition> m_metaDataReqs;
    private List<OnmsIpInterfaceRequisition> m_ifaceReqs;
    private List<OnmsNodeCategoryRequisition> m_categoryReqs;

    public OnmsNodeRequisition() {
    }

    public OnmsNodeRequisition(String foreignSource, RequisitionNode node) {
        this.m_foreignSource = foreignSource;
        this.m_node = node;
        this.m_assetReqs = this.constructAssetRequistions();
        this.m_metaDataReqs = this.constructMetaDataRequistions();
        this.m_ifaceReqs = this.constructIpInterfaceRequistions();
        this.m_categoryReqs = this.constructCategoryRequistions();
    }

    public String getForeignSource() {
        return this.m_foreignSource;
    }

    private List<OnmsAssetRequisition> constructAssetRequistions() {
        ArrayList<OnmsAssetRequisition> reqs = new ArrayList<OnmsAssetRequisition>(this.m_node.getAssets().size());
        for (RequisitionAsset asset : this.m_node.getAssets()) {
            reqs.add(new OnmsAssetRequisition(asset));
        }
        return reqs;
    }

    private List<OnmsNodeMetaDataRequisition> constructMetaDataRequistions() {
        return this.m_node.getMetaData().stream().map(OnmsNodeMetaDataRequisition::new).collect(Collectors.toList());
    }

    private List<OnmsIpInterfaceRequisition> constructIpInterfaceRequistions() {
        ArrayList<OnmsIpInterfaceRequisition> reqs = new ArrayList<OnmsIpInterfaceRequisition>(this.m_node.getInterfaces().size());
        for (RequisitionInterface iface : this.m_node.getInterfaces()) {
            reqs.add(new OnmsIpInterfaceRequisition(iface));
        }
        return reqs;
    }

    private List<OnmsNodeCategoryRequisition> constructCategoryRequistions() {
        ArrayList<OnmsNodeCategoryRequisition> reqs = new ArrayList<OnmsNodeCategoryRequisition>(this.m_node.getCategories().size());
        for (RequisitionCategory category : this.m_node.getCategories()) {
            reqs.add(new OnmsNodeCategoryRequisition(category));
        }
        return reqs;
    }

    public void visit(RequisitionVisitor visitor) {
        visitor.visitNode(this);
        for (OnmsNodeCategoryRequisition catReq : this.m_categoryReqs) {
            catReq.visit(visitor);
        }
        for (OnmsIpInterfaceRequisition ipReq : this.m_ifaceReqs) {
            ipReq.visit(visitor);
        }
        for (OnmsAssetRequisition assetReq : this.m_assetReqs) {
            assetReq.visit(visitor);
        }
        this.m_metaDataReqs.forEach(r -> r.visit(visitor));
        visitor.completeNode(this);
    }

    public OnmsNode constructOnmsNodeFromRequisition() {
        OnmsNodeBuilder visitor = new OnmsNodeBuilder();
        this.visit(visitor);
        return visitor.getNode();
    }

    public String getNodeLabel() {
        return this.m_node.getNodeLabel();
    }

    public String getForeignId() {
        return this.m_node.getForeignId();
    }

    public String getBuilding() {
        return this.m_node.getBuilding();
    }

    public String getCity() {
        return this.m_node.getCity();
    }

    public String getParentForeignSource() {
        return this.m_node.getParentForeignSource();
    }

    public String getParentForeignId() {
        return this.m_node.getParentForeignId();
    }

    public String getParentNodeLabel() {
        return this.m_node.getParentNodeLabel();
    }

    public String getLocation() {
        return this.m_node.getLocation();
    }

    public RequisitionNode getNode() {
        return this.m_node;
    }

    private static class OnmsNodeBuilder
    extends AbstractRequisitionVisitor {
        private NetworkBuilder bldr = new NetworkBuilder();

        private OnmsNodeBuilder() {
        }

        public OnmsNode getNode() {
            return this.bldr.getCurrentNode();
        }

        @Override
        public void visitAsset(OnmsAssetRequisition assetReq) {
            this.bldr.setAssetAttribute(assetReq.getName(), assetReq.getValue());
        }

        @Override
        public void visitNodeMetaData(OnmsNodeMetaDataRequisition metaDataReq) {
            this.bldr.setNodeMetaDataEntry(metaDataReq.getContext(), metaDataReq.getKey(), metaDataReq.getValue());
        }

        @Override
        public void visitInterfaceMetaData(OnmsInterfaceMetaDataRequisition metaDataReq) {
            this.bldr.setInterfaceMetaDataEntry(metaDataReq.getContext(), metaDataReq.getKey(), metaDataReq.getValue());
        }

        @Override
        public void visitServiceMetaData(OnmsServiceMetaDataRequisition metaDataReq) {
            this.bldr.setServiceMetaDataEntry(metaDataReq.getContext(), metaDataReq.getKey(), metaDataReq.getValue());
        }

        @Override
        public void visitNodeCategory(OnmsNodeCategoryRequisition catReq) {
            this.bldr.addCategory(catReq.getName());
        }

        @Override
        public void visitInterface(OnmsIpInterfaceRequisition ifaceReq) {
            String ipAddr = ifaceReq.getIpAddr();
            if (ipAddr == null || "".equals(ipAddr)) {
                this.bldr.clearInterface();
                LOG.error("Found interface on node {} with an empty ipaddr! Ignoring!", (Object)this.bldr.getCurrentNode().getLabel());
                return;
            }
            NetworkBuilder.InterfaceBuilder ifBldr = this.bldr.addInterface(ipAddr);
            ifBldr.setIsManaged(ifaceReq.getStatus() == 3 ? "U" : "M");
            ifBldr.setIsSnmpPrimary(ifaceReq.getSnmpPrimary().getCode());
        }

        @Override
        public void visitMonitoredService(OnmsMonitoredServiceRequisition monSvcReq) {
            this.bldr.addService(monSvcReq.getServiceName());
        }

        @Override
        public void visitNode(OnmsNodeRequisition nodeReq) {
            NetworkBuilder.NodeBuilder nodeBldr = this.bldr.addNode(nodeReq.getNodeLabel());
            nodeBldr.setLabelSource(OnmsNode.NodeLabelSource.USER);
            nodeBldr.setType(OnmsNode.NodeType.ACTIVE);
            nodeBldr.setForeignSource(nodeReq.getForeignSource());
            nodeBldr.setForeignId(nodeReq.getForeignId());
            nodeBldr.setLocation(nodeReq.getLocation());
            nodeBldr.getAssetRecord().setBuilding(nodeReq.getBuilding());
            nodeBldr.getAssetRecord().getGeolocation().setCity(nodeReq.getCity());
        }
    }
}

