/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opennms.netmgt.collectd.MibPropertyAttributeType;
import org.opennms.netmgt.collectd.SnmpAttribute;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collectd.SnmpPropertyExtender;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.config.datacollection.MibObjProperty;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CiscoQoSPropertyExtender
implements SnmpPropertyExtender {
    private static final Logger LOG = LoggerFactory.getLogger(CiscoQoSPropertyExtender.class);
    private static final String OBJ_QOS_CONF_INDEX = "cbQosConfigIndex";
    private static final String OBJ_QOS_CONF_TYPE = "cbQosObjectsType";
    private static final String OBJ_QOS_PARENT_INDEX = "cbQosParentObjectsIndex";
    private static final String OBJ_QOS_INTF_INDEX = "cbQosIfIndex";
    private static final String OBJ_QOS_POLICY_NAME = "cbQosPolicyMapName";
    private static final String OBJ_QOS_CLASS_NAME = "cbQosCMName";
    private static final String OBJ_INTF_NAME = "interfaceName";
    private static final String OBJ_INTF_ALIAS = "interfaceAlias";
    private static final String TYPE_QOS_CONF_INDEX = "cbQosObjectsEntry";
    private static final String TYPE_QOS_CONF_TYPE = "cbQosObjectsEntry";
    private static final String TYPE_QOS_PARENT_INDEX = "cbQosObjectsEntry";
    private static final String TYPE_QOS_INTF_INDEX = "cbQosServicePolicyEntry";
    private static final String TYPE_QOS_POLICY_NAME = "cbQosPolicyMapCfgEntry";
    private static final String TYPE_QOS_CLASS_NAME = "cbQosCMCfgEntry";
    private static final String PARAM_TARGET_PROPERTY = "target-property";
    private static final String PARAM_POLICY_NAME = "policyName";
    private static final String PARAM_CLASSMAP_NAME = "classMapName";
    private static final String PARAM_INTERFACE__NAME = "interfaceName";
    private static final String PARAM_INTERFACE_ALIAS = "interfaceAlias";

    @Override
    public SnmpAttribute getTargetAttribute(List<CollectionAttribute> sourceAttributes, SnmpCollectionResource targetResource, MibObjProperty property) {
        String objectsIndex;
        String targetProperty = property.getParameterValue(PARAM_TARGET_PROPERTY);
        if (targetProperty == null) {
            LOG.error("CiscoQoS getTargetAttribute: parameter {} is required. Expected values: policyName, classMapName, interfaceAlias, interfaceName", (Object)PARAM_TARGET_PROPERTY);
            return null;
        }
        AttributeGroupType groupType = targetResource.getGroupType(property.getGroupName());
        if (groupType == null) {
            LOG.error("CiscoQoS getTargetAttribute: can't find the attribute type name associated with the property {}", (Object)property);
            return null;
        }
        String oidIndex = targetResource.getInstance();
        String[] indexes = oidIndex.split("\\.");
        if (indexes.length < 2) {
            LOG.warn("CiscoQoS getTargetAttribute: Malformed Cisco QoS Object Index {} for {}", (Object)oidIndex, (Object)targetResource);
            return null;
        }
        Map<String, String> parentIndices = this.getAttributeMap(sourceAttributes, property.getParameterValue("cbQosObjectsEntry", "cbQosObjectsEntry"), property.getParameterValue(OBJ_QOS_PARENT_INDEX, OBJ_QOS_PARENT_INDEX));
        if (parentIndices.isEmpty()) {
            LOG.warn("CiscoQoS getTargetAttribute: Can't find parent indexes {} for type {}", (Object)OBJ_QOS_CONF_INDEX, (Object)"cbQosObjectsEntry");
            return null;
        }
        Map<String, String> configTypes = this.getAttributeMap(sourceAttributes, property.getParameterValue("cbQosObjectsEntry", "cbQosObjectsEntry"), property.getParameterValue(OBJ_QOS_CONF_TYPE, OBJ_QOS_CONF_TYPE));
        if (configTypes.isEmpty()) {
            LOG.warn("CiscoQoS getTargetAttribute: Can't find config types {} for type {}", (Object)OBJ_QOS_CONF_TYPE, (Object)"cbQosObjectsEntry");
            return null;
        }
        String policyIndex = indexes[0];
        String parentIndex = objectsIndex = indexes[1];
        String searchIndex = null;
        boolean found = false;
        do {
            searchIndex = policyIndex + '.' + parentIndex;
            parentIndex = parentIndices.get(searchIndex);
            String type = configTypes.get(searchIndex);
            found = "1".equals(type);
            LOG.debug("CiscoQoS getTargetAttribute: parent index for {} is {}, is a policy? {}", new Object[]{searchIndex, parentIndex, found});
        } while (!found || parentIndex == null);
        LOG.debug("CiscoQoS getTargetAttribute: retrieving policy config index for {}", (Object)searchIndex);
        String targetValue = null;
        String confIndex_TP = property.getParameterValue("cbQosObjectsEntry", "cbQosObjectsEntry");
        String confIndex_ID = property.getParameterValue(OBJ_QOS_CONF_INDEX, OBJ_QOS_CONF_INDEX);
        String intfIndex_TP = property.getParameterValue(TYPE_QOS_INTF_INDEX, TYPE_QOS_INTF_INDEX);
        String intfIndex_ID = property.getParameterValue(OBJ_QOS_INTF_INDEX, OBJ_QOS_INTF_INDEX);
        switch (targetProperty) {
            case "policyName": {
                String policyConfigIndex = this.getAttributeValue(sourceAttributes, searchIndex, confIndex_TP, confIndex_ID);
                if (policyConfigIndex == null) {
                    LOG.warn("CiscoQoS getTargetAttribute: Can't find policy for index {}", (Object)searchIndex);
                    return null;
                }
                String policyName_TP = property.getParameterValue(TYPE_QOS_POLICY_NAME, TYPE_QOS_POLICY_NAME);
                String policyName_ID = property.getParameterValue(OBJ_QOS_POLICY_NAME, OBJ_QOS_POLICY_NAME);
                LOG.debug("CiscoQoS getTargetAttribute: found policy config index {}", (Object)policyConfigIndex);
                String policyName = this.getAttributeValue(sourceAttributes, policyConfigIndex, policyName_TP, policyName_ID);
                if (policyName == null) {
                    LOG.warn("CiscoQoS getTargetAttribute: Can't find policy name using index {} for resource {} using {}::{}", new Object[]{policyConfigIndex, targetResource, policyName_TP, policyName_ID});
                    return null;
                }
                LOG.debug("CiscoQoS getTargetAttribute: policyIndex={}, policyConfigIndex={}, policyName={}", new Object[]{policyIndex, policyConfigIndex, policyName});
                targetValue = policyName;
                break;
            }
            case "classMapName": {
                String classMapName_ID;
                String classMapCfgIndex = this.getAttributeValue(sourceAttributes, oidIndex, confIndex_TP, confIndex_ID);
                if (classMapCfgIndex == null) {
                    LOG.warn("CiscoQoS getTargetAttribute: Can't find class-map config index for resource {}", (Object)targetResource);
                    return null;
                }
                String classMapName_TP = property.getParameterValue(TYPE_QOS_CLASS_NAME, TYPE_QOS_CLASS_NAME);
                String classMapName = this.getAttributeValue(sourceAttributes, classMapCfgIndex, classMapName_TP, classMapName_ID = property.getParameterValue(OBJ_QOS_CLASS_NAME, OBJ_QOS_CLASS_NAME));
                if (classMapName == null) {
                    LOG.warn("CiscoQoS getTargetAttribute: Can't find class-map name using index {} for resource {} using {}::{}", new Object[]{classMapCfgIndex, targetResource, classMapName_TP, classMapName_ID});
                    return null;
                }
                LOG.debug("CiscoQoS getTargetAttribute: classMapCfgIndex={}, classMapName={}", (Object)classMapCfgIndex, (Object)classMapName);
                targetValue = classMapName;
                break;
            }
            case "interfaceName": {
                String interfaceIndex = this.getAttributeValue(sourceAttributes, policyIndex, intfIndex_TP, intfIndex_ID);
                if (interfaceIndex == null) {
                    LOG.warn("CiscoQoS getTargetAttribute: Can't find interface ifIndex for resource {}", (Object)targetResource);
                    return null;
                }
                String intfName_ID = property.getParameterValue("interfaceName", "interfaceName");
                String ifName = this.getAttributeValue(sourceAttributes, interfaceIndex, "if", intfName_ID);
                if (ifName == null) {
                    LOG.warn("CiscoQoS getTargetAttribute: Can't find ifName using ifIndex {} for resource {} using {}::{}", new Object[]{interfaceIndex, targetResource, "if", intfName_ID});
                    return null;
                }
                targetValue = ifName;
                break;
            }
            case "interfaceAlias": {
                String interfaceIndex = this.getAttributeValue(sourceAttributes, policyIndex, intfIndex_TP, intfIndex_ID);
                if (interfaceIndex == null) {
                    LOG.warn("CiscoQoS getTargetAttribute: Can't find interface ifIndex for resource {}", (Object)targetResource);
                    return null;
                }
                String intfAlias_ID = property.getParameterValue("interfaceAlias", "interfaceAlias");
                String ifAlias = this.getAttributeValue(sourceAttributes, interfaceIndex, "if", intfAlias_ID);
                if (ifAlias == null) {
                    LOG.warn("CiscoQoS getTargetAttribute: Can't find ifAlias using ifIndex {} for resource {} using {}::{}", new Object[]{interfaceIndex, targetResource, "if", intfAlias_ID});
                    return null;
                }
                targetValue = ifAlias;
            }
        }
        if (targetValue == null) {
            LOG.warn("CiscoQoS getTargetAttribute: an unexpected error has happened. Check the parameters on your datacollection-configuration for the property {}", (Object)property.getAlias());
            return null;
        }
        MibPropertyAttributeType type = new MibPropertyAttributeType(targetResource.getResourceType(), property, groupType);
        SnmpValue value = SnmpUtils.getValueFactory().getOctetString(targetValue.getBytes());
        return new SnmpAttribute(targetResource, type, value);
    }

    private Map<String, String> getAttributeMap(List<CollectionAttribute> sourceAttributes, String type, String objName) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        sourceAttributes.stream().filter(a -> objName.equals(a.getAttributeType().getName()) && type.equals(a.getResource().getResourceTypeName())).forEach(a -> attributes.put(a.getResource().getInstance(), a.getStringValue()));
        return attributes;
    }

    private String getAttributeValue(List<CollectionAttribute> sourceAttributes, String index, String type, String attrName) {
        Optional<CollectionAttribute> attr = sourceAttributes.stream().filter(a -> attrName.equals(a.getAttributeType().getName()) && type.equals(a.getResource().getResourceTypeName()) && index.equals(a.getResource().getInstance())).findFirst();
        return attr.isPresent() ? attr.get().getStringValue() : null;
    }
}

