/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.NodeLabel;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeLabelJDBCImpl
implements NodeLabel {
    private static final Logger LOG = LoggerFactory.getLogger(NodeLabelJDBCImpl.class);
    private static final String SQL_DB_UPDATE_NODE_LABEL = "UPDATE node SET nodelabel=?,nodelabelsource=? WHERE nodeid=?";
    private static final String SQL_DB_RETRIEVE_NETBIOS_NAME = "SELECT nodenetbiosname FROM node WHERE nodeid=?";
    private static final String SQL_DB_RETRIEVE_MANAGED_INTERFACES = "SELECT ipaddr,iphostname FROM ipinterface WHERE nodeid=? AND ismanaged='M'";
    private static final String SQL_DB_RETRIEVE_NON_MANAGED_INTERFACES = "SELECT ipaddr,iphostname FROM ipinterface WHERE nodeid=? AND ismanaged!='M'";
    private static final String SQL_DB_RETRIEVE_SYSNAME = "SELECT nodesysname FROM node WHERE nodeid=?";
    private static final String SQL_DB_RETRIEVE_NODELABEL = "SELECT nodelabel,nodelabelsource FROM node WHERE nodeid=?";
    private final String m_nodeLabel;
    private final OnmsNode.NodeLabelSource m_nodeLabelSource;

    public NodeLabelJDBCImpl() {
        this.m_nodeLabel = null;
        this.m_nodeLabelSource = OnmsNode.NodeLabelSource.UNKNOWN;
    }

    public NodeLabelJDBCImpl(String nodeLabel, OnmsNode.NodeLabelSource nodeLabelSource) {
        switch (nodeLabelSource) {
            case ADDRESS: 
            case HOSTNAME: 
            case NETBIOS: 
            case SYSNAME: 
            case UNKNOWN: 
            case USER: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for node label source: " + nodeLabelSource);
            }
        }
        this.m_nodeLabel = nodeLabel;
        this.m_nodeLabelSource = nodeLabelSource;
    }

    public String getLabel() {
        return this.m_nodeLabel;
    }

    public OnmsNode.NodeLabelSource getSource() {
        return this.m_nodeLabelSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeLabel retrieveLabel(int nodeID) throws SQLException {
        Connection dbConnection = DataSourceFactory.getInstance().getConnection();
        DBUtils d = new DBUtils(NodeLabelJDBCImpl.class, new Object[]{dbConnection});
        try {
            NodeLabel nodeLabel = this.retrieveLabel(nodeID, dbConnection);
            return nodeLabel;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeLabel retrieveLabel(int nodeID, Connection dbConnection) throws SQLException {
        String nodeLabel = null;
        String nodeLabelSource = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(NodeLabelJDBCImpl.class);
        LOG.debug("NodeLabel.retrieveLabel: sql: {} node id: {}", (Object)SQL_DB_RETRIEVE_NODELABEL, (Object)nodeID);
        try {
            stmt = dbConnection.prepareStatement(SQL_DB_RETRIEVE_NODELABEL);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                nodeLabel = rs.getString(1);
                nodeLabelSource = rs.getString(2);
            }
        }
        finally {
            d.cleanUp();
        }
        if (OnmsNode.NodeLabelSource.ADDRESS.toString().equals(nodeLabelSource)) {
            return new NodeLabelJDBCImpl(nodeLabel, OnmsNode.NodeLabelSource.ADDRESS);
        }
        if (OnmsNode.NodeLabelSource.HOSTNAME.toString().equals(nodeLabelSource)) {
            return new NodeLabelJDBCImpl(nodeLabel, OnmsNode.NodeLabelSource.HOSTNAME);
        }
        if (OnmsNode.NodeLabelSource.NETBIOS.toString().equals(nodeLabelSource)) {
            return new NodeLabelJDBCImpl(nodeLabel, OnmsNode.NodeLabelSource.NETBIOS);
        }
        if (OnmsNode.NodeLabelSource.SYSNAME.toString().equals(nodeLabelSource)) {
            return new NodeLabelJDBCImpl(nodeLabel, OnmsNode.NodeLabelSource.SYSNAME);
        }
        if (OnmsNode.NodeLabelSource.UNKNOWN.toString().equals(nodeLabelSource)) {
            return new NodeLabelJDBCImpl(nodeLabel, OnmsNode.NodeLabelSource.UNKNOWN);
        }
        if (OnmsNode.NodeLabelSource.USER.toString().equals(nodeLabelSource)) {
            return new NodeLabelJDBCImpl(nodeLabel, OnmsNode.NodeLabelSource.USER);
        }
        return new NodeLabelJDBCImpl(nodeLabel, OnmsNode.NodeLabelSource.UNKNOWN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignLabel(int nodeID, NodeLabel nodeLabel) throws SQLException {
        Connection dbConnection = DataSourceFactory.getInstance().getConnection();
        DBUtils d = new DBUtils(NodeLabelJDBCImpl.class, new Object[]{dbConnection});
        try {
            this.assignLabel(nodeID, nodeLabel, dbConnection);
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignLabel(int nodeID, NodeLabel nodeLabel, Connection dbConnection) throws SQLException {
        DBUtils d = new DBUtils(NodeLabelJDBCImpl.class);
        try {
            PreparedStatement stmt = dbConnection.prepareStatement(SQL_DB_UPDATE_NODE_LABEL);
            d.watch((Object)stmt);
            int column = 1;
            LOG.debug("NodeLabel.assignLabel: Node label: {} source: {}", (Object)nodeLabel.getLabel(), (Object)nodeLabel.getSource());
            if (nodeLabel.getLabel() != null) {
                String label = nodeLabel.getLabel();
                if (label.length() > 256) {
                    label = label.substring(0, 256);
                }
                stmt.setString(column++, label);
            } else {
                stmt.setNull(column++, 12);
            }
            stmt.setString(column++, String.valueOf(nodeLabel.getSource()));
            stmt.setInt(column++, nodeID);
            stmt.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeLabel computeLabel(int nodeID) throws SQLException {
        Connection dbConnection = DataSourceFactory.getInstance().getConnection();
        DBUtils d = new DBUtils(NodeLabelJDBCImpl.class, new Object[]{dbConnection});
        try {
            NodeLabel nodeLabel = this.computeLabel(nodeID, dbConnection);
            return nodeLabel;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeLabel computeLabel(int nodeID, Connection dbConnection) throws SQLException {
        String netbiosName = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(NodeLabelJDBCImpl.class);
        try {
            stmt = dbConnection.prepareStatement(SQL_DB_RETRIEVE_NETBIOS_NAME);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                netbiosName = rs.getString(1);
            }
            if (netbiosName != null) {
                if (netbiosName.length() > 256) {
                    netbiosName = netbiosName.substring(0, 256);
                }
                LOG.debug("NodeLabel.computeLabel: returning NetBIOS name as nodeLabel: {}", (Object)netbiosName);
                NodeLabelJDBCImpl nodeLabelJDBCImpl = new NodeLabelJDBCImpl(netbiosName, OnmsNode.NodeLabelSource.NETBIOS);
                return nodeLabelJDBCImpl;
            }
        }
        finally {
            d.cleanUp();
        }
        String method = System.getProperty("org.opennms.bluebird.dp.primaryInterfaceSelectMethod");
        if (method == null) {
            method = "min";
        }
        if (!method.equals("min") && !method.equals("max")) {
            LOG.warn("Interface selection method is '{}'.  Valid values are 'min' & 'max'.  Will use default value: {}", (Object)method, (Object)"min");
            method = "min";
        }
        ArrayList<InetAddress> ipv4AddrList = new ArrayList<InetAddress>();
        ArrayList<String> ipHostNameList = new ArrayList<String>();
        try {
            stmt = dbConnection.prepareStatement(SQL_DB_RETRIEVE_MANAGED_INTERFACES);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            NodeLabelJDBCImpl.loadAddressList(rs, ipv4AddrList, ipHostNameList);
        }
        catch (Throwable e) {
            LOG.warn("Exception thrown while fetching managed interfaces: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            d.cleanUp();
        }
        InetAddress primaryAddr = NodeLabelJDBCImpl.selectPrimaryAddress(ipv4AddrList, method);
        if (primaryAddr == null) {
            LOG.debug("NodeLabel.computeLabel: unable to find a primary address for node {}, returning null", (Object)nodeID);
            ipv4AddrList.clear();
            ipHostNameList.clear();
            try {
                stmt = dbConnection.prepareStatement(SQL_DB_RETRIEVE_NON_MANAGED_INTERFACES);
                d.watch((Object)stmt);
                stmt.setInt(1, nodeID);
                rs = stmt.executeQuery();
                d.watch((Object)rs);
                NodeLabelJDBCImpl.loadAddressList(rs, ipv4AddrList, ipHostNameList);
            }
            catch (Throwable e) {
                LOG.warn("Exception thrown while fetching managed interfaces: {}", (Object)e.getMessage(), (Object)e);
            }
            finally {
                d.cleanUp();
            }
            primaryAddr = NodeLabelJDBCImpl.selectPrimaryAddress(ipv4AddrList, method);
        }
        if (primaryAddr == null) {
            LOG.warn("Could not find primary interface for node {}, cannot compute nodelabel", (Object)nodeID);
            return new NodeLabelJDBCImpl("Unknown", OnmsNode.NodeLabelSource.UNKNOWN);
        }
        int index = ipv4AddrList.indexOf(primaryAddr);
        String primaryHostName = (String)ipHostNameList.get(index);
        if (primaryHostName.length() != 0) {
            if (primaryHostName.length() > 256) {
                primaryHostName = primaryHostName.substring(0, 256);
            }
            return new NodeLabelJDBCImpl(primaryHostName, OnmsNode.NodeLabelSource.HOSTNAME);
        }
        String primarySysName = null;
        try {
            stmt = dbConnection.prepareStatement(SQL_DB_RETRIEVE_SYSNAME);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                primarySysName = rs.getString(1);
            }
        }
        finally {
            d.cleanUp();
        }
        if (primarySysName != null && primarySysName.length() > 0) {
            if (primarySysName.length() > 256) {
                primarySysName = primarySysName.substring(0, 256);
            }
            return new NodeLabelJDBCImpl(primarySysName, OnmsNode.NodeLabelSource.SYSNAME);
        }
        return new NodeLabelJDBCImpl(InetAddressUtils.str((InetAddress)primaryAddr), OnmsNode.NodeLabelSource.ADDRESS);
    }

    private static void loadAddressList(ResultSet rs, List<InetAddress> ipv4AddrList, List<String> ipHostNameList) throws SQLException {
        while (rs.next()) {
            InetAddress inetAddr = InetAddressUtils.getInetAddress((String)rs.getString(1));
            ipv4AddrList.add(inetAddr);
            String hostName = rs.getString(2);
            if (hostName == null || hostName.equals(inetAddr.toString())) {
                ipHostNameList.add("");
            } else {
                ipHostNameList.add(hostName);
            }
            LOG.debug("NodeLabel.computeLabel: adding address {} with hostname: {}", (Object)inetAddr, (Object)hostName);
        }
    }

    private static InetAddress selectPrimaryAddress(List<InetAddress> ipv4AddrList, String method) {
        InetAddress primaryAddr = null;
        Iterator<InetAddress> iter = ipv4AddrList.iterator();
        while (iter.hasNext()) {
            if (primaryAddr == null) {
                primaryAddr = iter.next();
                continue;
            }
            InetAddress currentAddr = iter.next();
            byte[] current = currentAddr.getAddress();
            byte[] primary = primaryAddr.getAddress();
            if (method.equals("min")) {
                if (new ByteArrayComparator().compare(current, primary) >= 0) continue;
                primaryAddr = currentAddr;
                continue;
            }
            if (new ByteArrayComparator().compare(current, primary) <= 0) continue;
            primaryAddr = currentAddr;
        }
        return primaryAddr;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.m_nodeLabel);
        buffer.append(":");
        buffer.append(this.m_nodeLabelSource);
        return buffer.toString();
    }
}

