/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.collectd.AliasedResource;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdInitializationException;
import org.opennms.netmgt.threshd.ThresholdingSet;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectorThresholdingSet
extends ThresholdingSet {
    private static final Logger LOG = LoggerFactory.getLogger(CollectorThresholdingSet.class);
    private final ResourceStorageDao m_resourceStorageDao;
    boolean storeByIfAlias = false;
    boolean counterReset = false;
    ServiceParameters svcParams;

    public CollectorThresholdingSet(int nodeId, String hostAddress, String serviceName, RrdRepository repository, ServiceParameters svcParams, ResourceStorageDao resourceStorageDao) throws ThresholdInitializationException {
        super(nodeId, hostAddress, serviceName, repository);
        this.m_resourceStorageDao = resourceStorageDao;
        String storeByIfAliasString = svcParams.getStoreByIfAlias();
        this.storeByIfAlias = storeByIfAliasString != null && "true".equalsIgnoreCase(storeByIfAliasString);
        this.svcParams = svcParams;
    }

    public void setCounterReset(boolean counterReset) {
        this.counterReset = counterReset;
    }

    public boolean hasThresholds(CollectionAttribute attribute) {
        CollectionResource resource = attribute.getResource();
        if (!this.isCollectionEnabled(attribute.getResource())) {
            return false;
        }
        if (resource instanceof AliasedResource && !this.storeByIfAlias) {
            return false;
        }
        return this.hasThresholds(resource.getResourceTypeName(), attribute.getName());
    }

    public List<Event> applyThresholds(CollectionResource resource, Map<String, CollectionAttribute> attributesMap, Date collectionTimestamp) {
        if (!this.isCollectionEnabled(resource)) {
            LOG.debug("applyThresholds: Ignoring resource {} because data collection is disabled for this resource.", (Object)resource);
            return new LinkedList<Event>();
        }
        CollectionResourceWrapper resourceWrapper = new CollectionResourceWrapper(collectionTimestamp, this.m_nodeId, this.m_hostAddress, this.m_serviceName, this.m_repository, resource, attributesMap, this.m_resourceStorageDao);
        resourceWrapper.setCounterReset(this.counterReset);
        return this.applyThresholds(resourceWrapper, attributesMap);
    }

    @Override
    protected boolean passedThresholdFilters(CollectionResourceWrapper resource, ThresholdEntity thresholdEntity) {
        if (resource.isAnInterfaceResource() && !resource.isValidInterfaceResource()) {
            LOG.info("passedThresholdFilters: Could not get data interface information for '{}' or this interface has an invalid ifIndex.  Not evaluating threshold.", (Object)resource.getIfLabel());
            return false;
        }
        return super.passedThresholdFilters(resource, thresholdEntity);
    }

    protected boolean isCollectionEnabled(CollectionResource resource) {
        return resource.shouldPersist(this.svcParams);
    }
}

