/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.pollables.LockUnavailable;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollEvent;
import org.opennms.netmgt.poller.pollables.PollableContainer;
import org.opennms.netmgt.poller.pollables.PollableVisitor;
import org.opennms.netmgt.poller.pollables.Scope;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PollableElement {
    private static final Logger LOG = LoggerFactory.getLogger(PollableElement.class);
    private final Scope m_scope;
    private volatile PollableContainer m_parent;
    private volatile PollStatus m_status = PollStatus.unknown();
    private volatile boolean m_statusChanged = false;
    private volatile PollEvent m_cause;
    private volatile boolean m_deleted;

    protected PollableElement(PollableContainer parent, Scope scope) {
        this.m_parent = parent;
        if (parent != null) {
            this.m_cause = parent.getCause();
        }
        this.m_scope = scope;
    }

    public PollableContainer getParent() {
        return this.m_parent;
    }

    protected void setParent(PollableContainer newParent) {
        this.m_parent = newParent;
    }

    public Scope getScope() {
        return this.m_scope;
    }

    public void visit(PollableVisitor v) {
        this.visitThis(v);
    }

    protected void visitThis(PollableVisitor v) {
        v.visitElement(this);
    }

    public PollStatus getStatus() {
        return this.m_status;
    }

    private void setStatus(PollStatus status) {
        this.m_status = status;
    }

    public boolean isStatusChanged() {
        return this.m_statusChanged;
    }

    private void setStatusChanged(boolean statusChanged) {
        this.m_statusChanged = statusChanged;
    }

    public void updateStatus(PollStatus newStatus) {
        PollStatus oldStatus = this.getStatus();
        if (!oldStatus.equals(newStatus)) {
            LOG.info("Changing status of PollableElement {} from {} to {}", new Object[]{this, oldStatus, newStatus});
            this.setStatus(newStatus);
            this.setStatusChanged(true);
        }
    }

    public void resetStatusChanged() {
        this.setStatusChanged(false);
    }

    public void recalculateStatus() {
    }

    public abstract PollContext getContext();

    public PollStatus doPoll(PollableElement elem) {
        if (this.getParent() == null) {
            this.resetStatusChanged();
            return this.poll(elem);
        }
        return this.getParent().doPoll(elem);
    }

    protected PollableElement getLockRoot() {
        PollableContainer parent = this.getParent();
        return parent == null ? this : parent.getLockRoot();
    }

    protected void obtainTreeLock() {
        this.getLockRoot().obtainTreeLock();
    }

    protected void obtainTreeLock(long timeout) throws LockUnavailable {
        this.getLockRoot().obtainTreeLock(timeout);
    }

    protected void releaseTreeLock() {
        this.getLockRoot().releaseTreeLock();
    }

    public final void withTreeLock(Runnable r) {
        this.withTreeLock(Executors.callable(r));
    }

    protected final <T> T withTreeLock(Callable<T> c) {
        try {
            this.obtainTreeLock();
            T t = c.call();
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            this.releaseTreeLock();
        }
    }

    protected final void withTreeLock(Runnable r, long timeout) throws LockUnavailable {
        this.withTreeLock(Executors.callable(r), timeout);
    }

    protected final <T> T withTreeLock(Callable<T> c, long timeout) throws LockUnavailable {
        boolean locked = false;
        try {
            this.obtainTreeLock(timeout);
            locked = true;
            T t = c.call();
            return t;
        }
        catch (LockUnavailable e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            if (locked) {
                this.releaseTreeLock();
            }
        }
    }

    public abstract PollStatus poll();

    protected PollStatus poll(PollableElement elem) {
        if (elem != this) {
            throw new IllegalArgumentException("Invalid parameter to poll on " + this + ": " + elem);
        }
        return this.poll();
    }

    public PollableElement selectPollElement() {
        return this;
    }

    public abstract Event createDownEvent(Date var1);

    public abstract Event createUpEvent(Date var1);

    protected void createOutage(PollEvent cause) {
        this.setCause(cause);
    }

    protected void resolveOutage(PollEvent resolution) {
        this.setCause(null);
    }

    public boolean hasOpenOutage() {
        return this.m_cause != null;
    }

    public void setCause(PollEvent cause) {
        this.m_cause = cause;
    }

    public PollEvent getCause() {
        return this.m_cause;
    }

    public void processStatusChange(Date date) {
        if (this.getStatus().isDown() && this.isStatusChanged()) {
            this.processGoingDown(date);
        } else if (this.getStatus().isUp() && this.isStatusChanged()) {
            this.processComingUp(date);
        }
    }

    protected void processComingUp(Date date) {
        if (this.getCause() != null) {
            PollEvent resolution = this.getContext().sendEvent(this.createUpEvent(date));
            this.processResolution(this.getCause(), resolution);
        }
    }

    protected void processResolution(PollEvent cause, PollEvent resolution) {
        this.resolveOutage(resolution);
    }

    protected void processGoingDown(Date date) {
        PollEvent cause = this.getContext().sendEvent(this.createDownEvent(date));
        this.processCause(cause);
    }

    protected void processCause(PollEvent cause) {
        if (!this.hasOpenOutage()) {
            this.createOutage(cause);
        }
    }

    protected void resolveAllOutages(PollEvent resolvedCause, PollEvent resolution) {
        if (resolvedCause.equals(this.getCause())) {
            this.resolveOutage(resolution);
        }
    }

    public boolean isDeleted() {
        return this.m_deleted;
    }

    public void delete() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                PollableElement.this.m_deleted = true;
                if (PollableElement.this.m_parent != null) {
                    PollableElement.this.getParent().deleteMember(PollableElement.this);
                    PollableElement.this.getParent().recalculateStatus();
                }
            }
        };
        this.withTreeLock(r);
    }

    protected void processLingeringCauses(PollEvent resolvedCause, PollEvent resolution) {
        if (this.getStatus().isDown() && resolvedCause.equals(this.getCause())) {
            this.resolveAllOutages(resolvedCause, resolution);
            this.processGoingDown(resolution.getDate());
        } else if (this.getStatus().isUp() && resolvedCause.equals(this.getCause())) {
            this.processResolution(resolvedCause, resolution);
        } else if (this.getStatus().isUp() && !resolvedCause.equals(this.getCause())) {
            this.processComingUp(resolution.getDate());
        }
    }

    public PollEvent extrapolateCause() {
        return this.withTreeLock(new Callable<PollEvent>(){

            @Override
            public PollEvent call() throws Exception {
                return PollableElement.this.doExtrapolateCause();
            }
        });
    }

    protected PollEvent doExtrapolateCause() {
        return this.getCause();
    }

    public void inheritParentalCause() {
        this.withTreeLock(new Runnable(){

            @Override
            public void run() {
                PollableElement.this.doInheritParentalCause();
            }
        });
    }

    protected void doInheritParentalCause() {
        if (this.getParent() == null) {
            return;
        }
        PollEvent parentalCause = this.getParent().getCause();
        PollStatus parentalStatus = this.getParent().getStatus();
        if (parentalCause == null) {
            return;
        }
        if (this.getCause() == null || this.getCause().hasScopeLargerThan(this.getScope())) {
            this.setCause(parentalCause);
            this.updateStatus(parentalStatus);
        }
    }
}

