/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.enlinkd.snmp.LldpLocalGroupTracker;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LldpRemTableTracker
extends TableTracker {
    private static final Logger LOG = LoggerFactory.getLogger(LldpRemTableTracker.class);
    public static final SnmpObjId LLDP_REM_TABLE_ENTRY = SnmpObjId.get((String)".1.0.8802.1.1.2.1.4.1.1");
    public static final SnmpObjId LLDP_REM_CHASSIS_ID_SUBTYPE = SnmpObjId.get((SnmpObjId)LLDP_REM_TABLE_ENTRY, (String)"4");
    public static final SnmpObjId LLDP_REM_CHASSIS_ID = SnmpObjId.get((SnmpObjId)LLDP_REM_TABLE_ENTRY, (String)"5");
    public static final SnmpObjId LLDP_REM_PORT_ID_SUBTYPE = SnmpObjId.get((SnmpObjId)LLDP_REM_TABLE_ENTRY, (String)"6");
    public static final SnmpObjId LLDP_REM_PORT_ID = SnmpObjId.get((SnmpObjId)LLDP_REM_TABLE_ENTRY, (String)"7");
    public static final SnmpObjId LLDP_REM_PORT_DESCR = SnmpObjId.get((SnmpObjId)LLDP_REM_TABLE_ENTRY, (String)"8");
    public static final SnmpObjId LLDP_REM_SYSNAME = SnmpObjId.get((SnmpObjId)LLDP_REM_TABLE_ENTRY, (String)"9");
    public static final SnmpObjId[] s_lldpremtable_elemList = new SnmpObjId[]{LLDP_REM_CHASSIS_ID_SUBTYPE, LLDP_REM_CHASSIS_ID, LLDP_REM_PORT_ID_SUBTYPE, LLDP_REM_PORT_ID, LLDP_REM_PORT_DESCR, LLDP_REM_SYSNAME};

    public static String decodeLldpPortId(Integer lldpPortIdSubType, SnmpValue lldpportid) {
        if (lldpPortIdSubType == null) {
            if (lldpportid.isDisplayable()) {
                return lldpportid.toDisplayString();
            }
            return lldpportid.toHexString();
        }
        try {
            LldpUtils.LldpPortIdSubType type = LldpUtils.LldpPortIdSubType.get((Integer)lldpPortIdSubType);
            switch (type) {
                case LLDP_PORTID_SUBTYPE_PORTCOMPONENT: 
                case LLDP_PORTID_SUBTYPE_AGENTCIRCUITID: 
                case LLDP_PORTID_SUBTYPE_INTERFACEALIAS: 
                case LLDP_PORTID_SUBTYPE_INTERFACENAME: 
                case LLDP_PORTID_SUBTYPE_LOCAL: {
                    if (lldpportid.isDisplayable()) {
                        return lldpportid.toDisplayString();
                    }
                    return lldpportid.toHexString();
                }
                case LLDP_PORTID_SUBTYPE_MACADDRESS: {
                    return lldpportid.toHexString();
                }
                case LLDP_PORTID_SUBTYPE_NETWORKADDRESS: {
                    LldpUtils.decodeNetworkAddress((String)lldpportid.toDisplayString());
                }
            }
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
        }
        catch (IndexOutOfBoundsException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lldpportid.toHexString();
    }

    public LldpRemTableTracker() {
        super(s_lldpremtable_elemList);
    }

    public LldpRemTableTracker(RowCallback rowProcessor) {
        super(rowProcessor, s_lldpremtable_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new LldpRemRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processLldpRemRow((LldpRemRow)row);
    }

    public void processLldpRemRow(LldpRemRow row) {
    }

    public static class LldpRemRow
    extends SnmpRowResult {
        public LldpRemRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
            LOG.debug("column count = {}, instance = {}", (Object)columnCount, (Object)instance);
        }

        public Integer getLldpRemLocalPortNum() {
            return this.getInstance().getSubIdAt(1);
        }

        public Integer getLldpRemChassisidSubtype() {
            return this.getValue(LLDP_REM_CHASSIS_ID_SUBTYPE).toInt();
        }

        public SnmpValue getLldpRemChassisId() {
            return this.getValue(LLDP_REM_CHASSIS_ID);
        }

        public Integer getLldpRemPortidSubtype() {
            return this.getValue(LLDP_REM_PORT_ID_SUBTYPE).toInt();
        }

        public String getLldpRemPortid() {
            return LldpRemTableTracker.decodeLldpPortId(this.getLldpRemPortidSubtype(), this.getValue(LLDP_REM_PORT_ID));
        }

        public String getLldpRemPortDescr() {
            if (this.getValue(LLDP_REM_PORT_DESCR) != null) {
                return this.getValue(LLDP_REM_PORT_DESCR).toDisplayString();
            }
            return "";
        }

        public String getLldpRemSysname() {
            return this.getValue(LLDP_REM_SYSNAME).toDisplayString();
        }

        public LldpLink getLldpLink() {
            LldpLink lldpLink = new LldpLink();
            lldpLink.setLldpLocalPortNum(this.getLldpRemLocalPortNum());
            lldpLink.setLldpRemChassisId(LldpLocalGroupTracker.decodeLldpChassisId(this.getLldpRemChassisId(), this.getLldpRemChassisidSubtype()));
            lldpLink.setLldpRemChassisIdSubType(LldpUtils.LldpChassisIdSubType.get((Integer)this.getLldpRemChassisidSubtype()));
            lldpLink.setLldpRemSysname(this.getLldpRemSysname());
            lldpLink.setLldpRemPortId(this.getLldpRemPortid());
            lldpLink.setLldpRemPortIdSubType(LldpUtils.LldpPortIdSubType.get((Integer)this.getLldpRemPortidSubtype()));
            lldpLink.setLldpRemPortDescr(this.getLldpRemPortDescr());
            LOG.debug("getLldpLink: local port num: {}, identifier: {}, chassis subtype: {}, \n rem sysname: {}, rem port: {}, rem port subtype: {}", new Object[]{this.getLldpRemLocalPortNum(), lldpLink.getLldpRemChassisId(), LldpUtils.LldpChassisIdSubType.getTypeString((Integer)this.getLldpRemChassisidSubtype()), lldpLink.getLldpRemSysname(), lldpLink.getLldpRemPortId(), LldpUtils.LldpPortIdSubType.getTypeString((Integer)this.getLldpRemPortidSubtype())});
            return lldpLink;
        }
    }
}

