/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.opennms.netmgt.enlinkd.Discovery;
import org.opennms.netmgt.enlinkd.DiscoveryBridgeTopology;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.model.topology.BridgeForwardingTableEntry;
import org.opennms.netmgt.model.topology.BridgeTopologyException;
import org.opennms.netmgt.model.topology.BroadcastDomain;
import org.opennms.netmgt.model.topology.Topology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryBridgeDomains
extends Discovery {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryBridgeDomains.class);
    final int m_maxthreads;

    public DiscoveryBridgeDomains(EnhancedLinkd linkd) {
        super(linkd, linkd.getBridgeTopologyInterval(), linkd.getInitialSleepTime() + linkd.getBridgeTopologyInterval());
        this.m_maxthreads = linkd.getDiscoveryBridgeThreads();
    }

    private BroadcastDomain find(Set<Integer> nodes, Set<String> setA) throws BridgeTopologyException {
        BroadcastDomain domain = null;
        for (BroadcastDomain curBDomain : this.m_linkd.getQueryManager().getAllBroadcastDomains()) {
            if (!BroadcastDomain.checkMacSets(setA, (Set)curBDomain.getMacsOnSegments())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("find: node:{}, domain:{}", nodes, (Object)curBDomain.getBridgeNodesOnDomain());
            }
            if (domain != null) {
                throw new BridgeTopologyException("at least two domains found", (Topology)domain);
            }
            domain = curBDomain;
        }
        if (domain == null) {
            LOG.debug("find: nodes: [{}]. No domain found, creating new Domain", nodes);
            domain = new BroadcastDomain();
            this.m_linkd.getQueryManager().save(domain);
        }
        for (Integer nodeid : nodes) {
            BroadcastDomain olddomain = this.m_linkd.getQueryManager().getBroadcastDomain(nodeid);
            if (olddomain == null || domain == olddomain) continue;
            this.m_linkd.getQueryManager().reconcileTopologyForDeleteNode(olddomain, nodeid);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("find: node:[{}]. Removed from Old Domain \n{}", (Object)nodeid, (Object)olddomain.printTopology());
        }
        return domain;
    }

    @Override
    public void runDiscovery() {
        LOG.info("run: calculate topology on broadcast domains. Start");
        HashMap nodeondomainbft = new HashMap();
        HashMap<Integer, Set<BridgeForwardingTableEntry>> nodeBft = new HashMap<Integer, Set<BridgeForwardingTableEntry>>();
        HashMap nodeMacs = new HashMap();
        HashSet<Integer> nodeids = new HashSet<Integer>(this.m_linkd.getQueryManager().getUpdateBftMap().keySet());
        LOG.debug("run: nodes with updated bft {}", nodeids);
        for (Integer n : nodeids) {
            Set<BridgeForwardingTableEntry> links = this.m_linkd.getQueryManager().useBridgeTopologyUpdateBFT(n);
            if (links == null || links.size() == 0) {
                LOG.warn("run: node:[{}]. no updated bft. Return", (Object)n);
                continue;
            }
            nodeBft.put(n, links);
            HashSet<String> macs = new HashSet<String>();
            for (BridgeForwardingTableEntry link : links) {
                macs.add(link.getMacAddress());
            }
            LOG.debug("run: node:[{}]. macs:{}", (Object)n, macs);
            nodeMacs.put(n, macs);
        }
        HashSet<Object> parsed = new HashSet<Object>();
        for (Object nodeidA : nodeBft.keySet()) {
            if (parsed.contains(nodeidA)) continue;
            nodeondomainbft.put(nodeidA, new HashMap());
            ((Map)nodeondomainbft.get(nodeidA)).put(nodeidA, nodeBft.get(nodeidA));
            parsed.add(nodeidA);
            for (Integer nodeidB : nodeBft.keySet()) {
                if (parsed.contains(nodeidB) || !BroadcastDomain.checkMacSets((Set)((Set)nodeMacs.get(nodeidA)), (Set)((Set)nodeMacs.get(nodeidB)))) continue;
                ((Map)nodeondomainbft.get(nodeidA)).put(nodeidB, nodeBft.get(nodeidB));
                parsed.add(nodeidB);
            }
        }
        ArrayList<Callable<String>> arrayList = new ArrayList<Callable<String>>();
        for (Integer nodeid : nodeondomainbft.keySet()) {
            LOG.debug("run: nodes are on same domain {}", ((Map)nodeondomainbft.get(nodeid)).keySet());
            try {
                BroadcastDomain domain = this.find(((Map)nodeondomainbft.get(nodeid)).keySet(), (Set)nodeMacs.get(nodeid));
                DiscoveryBridgeTopology nodebridgetopology = this.m_linkd.getNodeBridgeDiscoveryTopology(domain);
                for (Integer bridgeId : ((Map)nodeondomainbft.get(nodeid)).keySet()) {
                    nodebridgetopology.addUpdatedBFT(bridgeId, (Set)((Map)nodeondomainbft.get(nodeid)).get(bridgeId));
                }
                Callable<String> task = () -> {
                    nodebridgetopology.runDiscovery();
                    return "executed Task: " + nodebridgetopology.getInfo();
                };
                arrayList.add(task);
                LOG.info("run: added Task {}", (Object)nodebridgetopology.getInfo());
            }
            catch (BridgeTopologyException e) {
                LOG.error("run: node: [{}], getting broadcast domain. Failed {}", (Object)nodeid, (Object)e.getMessage());
            }
        }
        int n = arrayList.size();
        if (n > this.m_maxthreads) {
            n = this.m_maxthreads;
        }
        if (n > 0) {
            LOG.debug("run: creating executorService with {} Threads", (Object)n);
            ExecutorService executorService = Executors.newFixedThreadPool(n);
            LOG.debug("run: created executorService with {} Threads", (Object)n);
            try {
                for (Future future : executorService.invokeAll(arrayList)) {
                    LOG.info("run: {}", future.get());
                }
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("run: executing task {}", (Object)e.getMessage(), (Object)e);
            }
            executorService.shutdown();
        } else {
            LOG.info("run: no updates on broadcast domains");
        }
        LOG.info("run: calculate topology on broadcast domains. End");
    }

    @Override
    public String getName() {
        return "DiscoveryBridgeDomain";
    }
}

