/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.enlinkd.scheduler.Scheduler;
import org.opennms.netmgt.model.events.EventBuilder;

public abstract class Discovery
implements ReadyRunnable {
    private Scheduler m_scheduler;
    protected long m_poll_interval = 1800000L;
    protected long m_initial_sleep_time = 600000L;
    private boolean m_runned = false;
    protected boolean m_suspendCollection = false;
    protected final EnhancedLinkd m_linkd;

    public Discovery(EnhancedLinkd linkd, long interval, long initial) {
        this.m_linkd = linkd;
        this.m_poll_interval = interval;
        this.m_initial_sleep_time = initial;
    }

    public abstract String getName();

    public abstract void runDiscovery();

    @Override
    public void run() {
        this.runDiscovery();
        this.m_runned = true;
        this.reschedule();
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    @Override
    public void schedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.m_initial_sleep_time, this);
    }

    @Override
    public void unschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("rescedule: Cannot schedule a service whose scheduler is set to null");
        }
        if (this.m_runned) {
            this.m_scheduler.unschedule(this, this.m_poll_interval);
        } else {
            this.m_scheduler.unschedule(this, this.m_initial_sleep_time);
        }
    }

    public void reschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.m_poll_interval, this);
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public boolean isSuspended() {
        return this.m_suspendCollection;
    }

    @Override
    public void suspend() {
        this.m_suspendCollection = true;
    }

    @Override
    public void wakeUp() {
        this.m_suspendCollection = false;
    }

    @Override
    public String getInfo() {
        return this.getName();
    }

    public long getPollInterval() {
        return this.m_poll_interval;
    }

    public void setPollInterval(long interval) {
        this.m_poll_interval = interval;
    }

    public long getInitialSleepTime() {
        return this.m_initial_sleep_time;
    }

    public void setInitialSleepTime(long initial_sleep_time) {
        this.m_initial_sleep_time = initial_sleep_time;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.m_initial_sleep_time ^ this.m_initial_sleep_time >>> 32);
        result = 31 * result + (int)(this.m_poll_interval ^ this.m_poll_interval >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Discovery other = (Discovery)obj;
        if (this.m_initial_sleep_time != other.m_initial_sleep_time) {
            return false;
        }
        return this.m_poll_interval == other.m_poll_interval;
    }

    protected void sendSuspendedEvent(int nodeid) {
        EventBuilder builder = new EventBuilder("uei.opennms.org/internal/linkd/nodeLinkDiscoverySuspended", "EnhancedLinkd");
        builder.setNodeid((long)nodeid);
        builder.addParam("runnable", this.getName());
        this.m_linkd.getEventForwarder().sendNow(builder.getEvent());
    }

    protected void sendStartEvent(int nodeid) {
        EventBuilder builder = new EventBuilder("uei.opennms.org/internal/linkd/nodeLinkDiscoveryStarted", "EnhancedLinkd");
        builder.setNodeid((long)nodeid);
        builder.addParam("runnable", this.getName());
        this.m_linkd.getEventForwarder().sendNow(builder.getEvent());
    }

    protected void sendCompletedEvent(int nodeid) {
        EventBuilder builder = new EventBuilder("uei.opennms.org/internal/linkd/nodeLinkDiscoveryCompleted", "EnhancedLinkd");
        builder.setNodeid((long)nodeid);
        builder.addParam("runnable", this.getName());
        this.m_linkd.getEventForwarder().sendNow(builder.getEvent());
    }
}

