/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.jmx;

import java.util.concurrent.ThreadPoolExecutor;
import org.opennms.netmgt.collectd.jmx.CollectdMBean;
import org.opennms.netmgt.daemon.AbstractSpringContextJmxServiceDaemon;
import org.opennms.netmgt.scheduler.LegacyScheduler;

public class Collectd
extends AbstractSpringContextJmxServiceDaemon<org.opennms.netmgt.collectd.Collectd>
implements CollectdMBean {
    protected String getLoggingPrefix() {
        return org.opennms.netmgt.collectd.Collectd.getLoggingCategory();
    }

    protected String getSpringContext() {
        return "collectdContext";
    }

    @Override
    public long getActiveThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getActiveCount();
        }
        return 0L;
    }

    @Override
    public long getTasksTotal() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getTaskCount();
        }
        return 0L;
    }

    @Override
    public long getTasksCompleted() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getCompletedTaskCount();
        }
        return 0L;
    }

    @Override
    public double getTaskCompletionRatio() {
        if (this.getThreadPoolStatsStatus()) {
            if (this.getExecutor().getTaskCount() > 0L) {
                return new Double((double)this.getExecutor().getCompletedTaskCount() / new Double(this.getExecutor().getTaskCount()));
            }
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public long getNumPoolThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getPoolSize();
        }
        return 0L;
    }

    @Override
    public long getMaxPoolThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getMaximumPoolSize();
        }
        return 0L;
    }

    @Override
    public long getPeakPoolThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getLargestPoolSize();
        }
        return 0L;
    }

    @Override
    public long getTaskQueuePendingCount() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getQueue().size();
        }
        return 0L;
    }

    @Override
    public long getTaskQueueRemainingCapacity() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getQueue().remainingCapacity();
        }
        return 0L;
    }

    @Override
    public long getCollectableServiceCount() {
        return ((org.opennms.netmgt.collectd.Collectd)this.getDaemon()).getCollectableServiceCount();
    }

    private ThreadPoolExecutor getExecutor() {
        return (ThreadPoolExecutor)((LegacyScheduler)((org.opennms.netmgt.collectd.Collectd)this.getDaemon()).getScheduler()).getRunner();
    }

    private boolean getThreadPoolStatsStatus() {
        return ((org.opennms.netmgt.collectd.Collectd)this.getDaemon()).getScheduler() instanceof LegacyScheduler;
    }
}

