/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.opennms.core.rpc.api.RpcExceptionHandler;
import org.opennms.core.rpc.api.RpcExceptionUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collectd.IfAliasResourceType;
import org.opennms.netmgt.collectd.IfNumberTracker;
import org.opennms.netmgt.collectd.IfResourceType;
import org.opennms.netmgt.collectd.NodeInfo;
import org.opennms.netmgt.collectd.NodeResourceType;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.ResourceVisitor;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collectd.SnmpIfCollector;
import org.opennms.netmgt.collectd.SnmpNodeCollector;
import org.opennms.netmgt.collectd.SnmpPropertyExtenderProcessor;
import org.opennms.netmgt.collectd.SysUpTimeTracker;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.collection.api.CollectionTimedOut;
import org.opennms.netmgt.collection.api.CollectionUnknown;
import org.opennms.netmgt.collection.api.CollectionWarning;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpAgentTimeoutException;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpCollectionSet
implements Collectable,
CollectionSet {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpCollectionSet.class);
    private final SnmpCollectionAgent m_agent;
    private final OnmsSnmpCollection m_snmpCollection;
    private final LocationAwareSnmpClient m_client;
    private SnmpIfCollector m_ifCollector;
    private IfNumberTracker m_ifNumber;
    private SysUpTimeTracker m_sysUpTime;
    private SnmpNodeCollector m_nodeCollector;
    private CollectionStatus m_status = CollectionStatus.FAILED;
    private boolean m_ignorePersist;
    private Date m_timestamp;

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("CollectionAgent: ");
        buffer.append(this.m_agent);
        buffer.append("\n");
        buffer.append("OnmsSnmpCollection: ");
        buffer.append(this.m_snmpCollection);
        buffer.append("\n");
        buffer.append("SnmpIfCollector: ");
        buffer.append((Object)this.m_ifCollector);
        buffer.append("\n");
        buffer.append("IfNumberTracker: ");
        buffer.append((Object)this.m_ifNumber);
        buffer.append("\n");
        buffer.append("SysUpTimeTracker: ");
        buffer.append((Object)this.m_sysUpTime);
        buffer.append("\n");
        buffer.append("SnmpNodeCollector: ");
        buffer.append((Object)this.m_nodeCollector);
        buffer.append("\n");
        return buffer.toString();
    }

    public SnmpCollectionSet(SnmpCollectionAgent agent, OnmsSnmpCollection snmpCollection, LocationAwareSnmpClient client) {
        this.m_agent = agent;
        this.m_snmpCollection = snmpCollection;
        this.m_client = Objects.requireNonNull(client);
    }

    public SnmpIfCollector getIfCollector() {
        if (this.m_ifCollector == null) {
            this.m_ifCollector = this.createIfCollector();
        }
        return this.m_ifCollector;
    }

    public IfNumberTracker getIfNumber() {
        if (this.m_ifNumber == null) {
            this.m_ifNumber = this.createIfNumberTracker();
        }
        return this.m_ifNumber;
    }

    public SysUpTimeTracker getSysUpTime() {
        if (this.m_sysUpTime == null) {
            this.m_sysUpTime = this.createSysUpTimeTracker();
        }
        return this.m_sysUpTime;
    }

    public SnmpNodeCollector getNodeCollector() {
        if (this.m_nodeCollector == null) {
            this.m_nodeCollector = this.createNodeCollector();
        }
        return this.m_nodeCollector;
    }

    private SnmpNodeCollector createNodeCollector() {
        SnmpNodeCollector nodeCollector = null;
        if (!this.getAttributeList().isEmpty()) {
            nodeCollector = new SnmpNodeCollector(this.m_agent.getAddress(), this.getAttributeList(), this);
        }
        return nodeCollector;
    }

    private IfNumberTracker createIfNumberTracker() {
        IfNumberTracker ifNumber = null;
        if (this.hasInterfaceDataToCollect()) {
            ifNumber = new IfNumberTracker();
        }
        return ifNumber;
    }

    private SysUpTimeTracker createSysUpTimeTracker() {
        return new SysUpTimeTracker();
    }

    private SnmpIfCollector createIfCollector() {
        SnmpIfCollector ifCollector = null;
        if (this.hasInterfaceDataToCollect() || this.hasGenericIndexResourceDataToCollect()) {
            ifCollector = new SnmpIfCollector(this.m_agent.getAddress(), this.getCombinedIndexedAttributes(), this);
        }
        return ifCollector;
    }

    public NodeInfo getNodeInfo() {
        return this.getNodeResourceType().getNodeInfo();
    }

    boolean hasDataToCollect() {
        return this.getNodeResourceType().hasDataToCollect() || this.getIfResourceType().hasDataToCollect() || this.hasGenericIndexResourceDataToCollect();
    }

    boolean hasInterfaceDataToCollect() {
        return this.getIfResourceType().hasDataToCollect();
    }

    boolean hasGenericIndexResourceDataToCollect() {
        return !this.getGenericIndexResourceTypes().isEmpty();
    }

    public SnmpCollectionAgent getCollectionAgent() {
        return this.m_agent;
    }

    Collection<SnmpAttributeType> getAttributeList() {
        return this.m_snmpCollection.getNodeResourceType(this.m_agent).getAttributeTypes();
    }

    List<SnmpAttributeType> getCombinedIndexedAttributes() {
        LinkedList<SnmpAttributeType> attributes = new LinkedList<SnmpAttributeType>();
        attributes.addAll(this.getIfResourceType().getAttributeTypes());
        attributes.addAll(this.getIfAliasResourceType().getAttributeTypes());
        attributes.addAll(this.getGenericIndexAttributeTypes());
        return attributes;
    }

    protected Collection<SnmpAttributeType> getGenericIndexAttributeTypes() {
        LinkedList<SnmpAttributeType> attributeTypes = new LinkedList<SnmpAttributeType>();
        Collection<ResourceType> resourceTypes = this.getGenericIndexResourceTypes();
        for (ResourceType resourceType : resourceTypes) {
            attributeTypes.addAll(resourceType.getAttributeTypes());
        }
        return attributeTypes;
    }

    private Collection<ResourceType> getGenericIndexResourceTypes() {
        return this.m_snmpCollection.getGenericIndexResourceTypes(this.m_agent);
    }

    public CollectionTracker getCollectionTracker() {
        return new AggregateTracker(SnmpAttributeType.getCollectionTrackers(this.getAttributeTypes()));
    }

    private Collection<SnmpAttributeType> getAttributeTypes() {
        return this.m_snmpCollection.getAttributeTypes(this.m_agent);
    }

    public Collection<? extends CollectionResource> getResources() {
        return this.m_snmpCollection.getResources(this.m_agent);
    }

    public void visit(CollectionSetVisitor visitor) {
        visitor.visitCollectionSet((CollectionSet)this);
        for (CollectionResource collectionResource : this.getResources()) {
            collectionResource.visit(visitor);
        }
        visitor.completeCollectionSet((CollectionSet)this);
    }

    CollectionTracker getTracker() {
        ArrayList<Object> trackers = new ArrayList<Object>(4);
        if (this.getIfNumber() != null) {
            trackers.add((Object)this.getIfNumber());
        }
        if (this.getSysUpTime() != null) {
            trackers.add((Object)this.getSysUpTime());
        }
        if (this.getNodeCollector() != null) {
            trackers.add((Object)this.getNodeCollector());
        }
        if (this.getIfCollector() != null) {
            trackers.add((Object)this.getIfCollector());
        }
        return new AggregateTracker(trackers);
    }

    protected SnmpWalker createWalker() {
        SnmpCollectionAgent agent = this.getCollectionAgent();
        return SnmpUtils.createWalker((SnmpAgentConfig)this.getAgentConfig(), (String)("SnmpCollectors for " + agent.getHostAddress()), (CollectionTracker)this.getTracker());
    }

    private void logStartedWalker() {
        LOG.debug("collect: successfully instantiated SnmpNodeCollector() for {} at location {}", (Object)this.getCollectionAgent().getHostAddress(), (Object)this.getCollectionAgent().getLocationName());
    }

    private void logFinishedWalker() {
        LOG.info("collect: node SNMP query for address {} at location {} complete.", (Object)this.getCollectionAgent().getHostAddress(), (Object)this.getCollectionAgent().getLocationName());
    }

    void collect() throws CollectionException {
        try {
            SnmpCollectionAgent agent = this.getCollectionAgent();
            this.logStartedWalker();
            CompletableFuture future = this.m_client.walk(this.getAgentConfig(), this.getTracker()).withDescription("SnmpCollectors for " + agent.getHostAddress()).withLocation(this.getCollectionAgent().getLocationName()).withTimeToLive(this.m_snmpCollection.getServiceParameters().getServiceInterval()).execute();
            try {
                future.get();
            }
            finally {
                this.logFinishedWalker();
            }
            SnmpPropertyExtenderProcessor processor = new SnmpPropertyExtenderProcessor();
            processor.process(this, this.m_snmpCollection.getName(), this.m_agent.getSysObjectId(), this.m_agent.getHostAddress());
            this.m_status = CollectionStatus.SUCCEEDED;
        }
        catch (InterruptedException | ExecutionException e) {
            throw (CollectionException)((Object)RpcExceptionUtils.handleException((Throwable)e, (RpcExceptionHandler)new RpcExceptionHandler<CollectionException>(){

                public CollectionException onInterrupted(Throwable t) {
                    Thread.currentThread().interrupt();
                    return new CollectionUnknown(String.format("Collection of SNMP data for interface %s at location %s was interrupted.", SnmpCollectionSet.this.getCollectionAgent().getHostAddress(), SnmpCollectionSet.this.getCollectionAgent().getLocationName()), t);
                }

                public CollectionException onTimedOut(Throwable t) {
                    return new CollectionUnknown(String.format("No response received when remotely collecting SNMP data for interface %s at location %s.", SnmpCollectionSet.this.getCollectionAgent().getHostAddress(), SnmpCollectionSet.this.getCollectionAgent().getLocationName()), t);
                }

                public CollectionException onRejected(Throwable t) {
                    return new CollectionUnknown(String.format("The request to remotely collect SNMP data for interface %s at location %s was rejected.", SnmpCollectionSet.this.getCollectionAgent().getHostAddress(), SnmpCollectionSet.this.getCollectionAgent().getLocationName()), t);
                }

                public CollectionException onUnknown(Throwable t) {
                    if (t instanceof SnmpAgentTimeoutException) {
                        return new CollectionTimedOut(t.getMessage());
                    }
                    if (t.getCause() != null && t.getCause() instanceof SnmpAgentTimeoutException) {
                        return new CollectionTimedOut(t.getCause().getMessage());
                    }
                    return new CollectionWarning(String.format("Unexpected exception when collecting SNMP data for interface %s at location %s.", SnmpCollectionSet.this.getCollectionAgent().getHostAddress(), SnmpCollectionSet.this.getCollectionAgent().getLocationName()), t);
                }
            }));
        }
    }

    boolean checkDisableForceRescan(String disabledString) {
        Map parameters = this.m_snmpCollection.getServiceParameters().getParameters();
        String src = ParameterMap.getKeyedString((Map)parameters, (String)"disableForceRescan", null);
        return src != null && (src.toLowerCase().equals("all") || src.toLowerCase().equals(disabledString));
    }

    void checkForNewInterfaces(RescanNeeded rescanNeeded) {
        if (!this.hasInterfaceDataToCollect()) {
            return;
        }
        if (this.checkDisableForceRescan("ifnumber")) {
            LOG.info("checkForNewInterfaces: check rescan is disabled for node {}", (Object)this.m_agent.getNodeId());
            return;
        }
        this.logIfCounts();
        if (this.getIfNumber().isChanged(this.getCollectionAgent().getSavedIfCount())) {
            LOG.info("Sending rescan event because the number of interfaces on primary SNMP interface {} has changed, generating 'ForceRescan' event.", (Object)this.getCollectionAgent().getHostAddress());
            rescanNeeded.rescanIndicated();
        }
        this.getCollectionAgent().setSavedIfCount(this.getIfNumber().getIntValue());
    }

    void checkForSystemRestart(RescanNeeded rescanNeeded) {
        if (!this.hasInterfaceDataToCollect()) {
            return;
        }
        if (this.checkDisableForceRescan("sysuptime")) {
            LOG.info("checkForSystemRestart: check rescan is disabled for node {}", (Object)this.m_agent.getNodeId());
            return;
        }
        this.checkForSystemRestart();
        if (this.m_ignorePersist) {
            LOG.info("Sending rescan event because sysUpTime has changed on primary SNMP interface {}, generating 'ForceRescan' event.", (Object)this.getCollectionAgent().getHostAddress());
            rescanNeeded.rescanIndicated();
        }
    }

    void checkForSystemRestart() {
        this.logSysUpTime();
        this.m_ignorePersist = false;
        if (this.getSysUpTime().isChanged(this.getCollectionAgent().getSavedSysUpTime())) {
            this.m_ignorePersist = true;
            this.getCollectionAgent().setSavedSysUpTime(-1L);
        } else {
            this.getCollectionAgent().setSavedSysUpTime(this.getSysUpTime().getLongValue());
        }
    }

    private void logIfCounts() {
        if (LOG.isDebugEnabled()) {
            SnmpCollectionAgent agent = this.getCollectionAgent();
            LOG.debug("collect: nodeId: {} interface: {} ifCount: {} savedIfCount: {}", new Object[]{agent.getNodeId(), agent.getHostAddress(), this.getIfNumber().getIntValue(), agent.getSavedIfCount()});
        }
    }

    private void logSysUpTime() {
        if (LOG.isDebugEnabled()) {
            SnmpCollectionAgent agent = this.getCollectionAgent();
            LOG.debug("collect: nodeId: {} interface: {} sysUpTime: {} savedSysUpTime: {}", new Object[]{agent.getNodeId(), agent.getHostAddress(), this.getSysUpTime().getLongValue(), agent.getSavedSysUpTime()});
        }
    }

    public boolean rescanNeeded() {
        final RescanNeeded rescanNeeded = new RescanNeeded();
        this.visit((CollectionSetVisitor)new ResourceVisitor(){

            @Override
            public void visitResource(CollectionResource resource) {
                LOG.debug("rescanNeeded: Visiting resource {}", (Object)resource);
                if (resource.rescanNeeded()) {
                    LOG.debug("Sending rescan event for {} because resource {} indicated it was needed", (Object)SnmpCollectionSet.this.getCollectionAgent(), (Object)resource);
                    rescanNeeded.rescanIndicated();
                }
            }
        });
        this.checkForNewInterfaces(rescanNeeded);
        this.checkForSystemRestart(rescanNeeded);
        return rescanNeeded.rescanIsNeeded();
    }

    public SnmpAgentConfig getAgentConfig() {
        SnmpAgentConfig agentConfig = this.getCollectionAgent().getAgentConfig();
        agentConfig.setPort(this.m_snmpCollection.getSnmpPort(agentConfig.getPort()));
        agentConfig.setRetries(this.m_snmpCollection.getSnmpRetries(agentConfig.getRetries()));
        agentConfig.setTimeout(this.m_snmpCollection.getSnmpTimeout(agentConfig.getTimeout()));
        agentConfig.setReadCommunity(this.m_snmpCollection.getSnmpReadCommunity(agentConfig.getReadCommunity()));
        agentConfig.setWriteCommunity(this.m_snmpCollection.getSnmpWriteCommunity(agentConfig.getWriteCommunity()));
        agentConfig.setProxyFor(this.m_snmpCollection.getSnmpProxyFor(agentConfig.getProxyFor()));
        agentConfig.setVersion(this.m_snmpCollection.getSnmpVersion(agentConfig.getVersion()));
        agentConfig.setMaxVarsPerPdu(this.m_snmpCollection.getSnmpMaxVarsPerPdu(agentConfig.getMaxVarsPerPdu()));
        agentConfig.setMaxRepetitions(this.m_snmpCollection.getSnmpMaxRepetitions(agentConfig.getMaxRepetitions()));
        agentConfig.setMaxRequestSize(this.m_snmpCollection.getSnmpMaxRequestSize(agentConfig.getMaxRequestSize()));
        agentConfig.setSecurityName(this.m_snmpCollection.getSnmpSecurityName(agentConfig.getSecurityName()));
        agentConfig.setAuthPassPhrase(this.m_snmpCollection.getSnmpAuthPassPhrase(agentConfig.getAuthPassPhrase()));
        agentConfig.setAuthProtocol(this.m_snmpCollection.getSnmpAuthProtocol(agentConfig.getAuthProtocol()));
        agentConfig.setPrivPassPhrase(this.m_snmpCollection.getSnmpPrivPassPhrase(agentConfig.getPrivPassPhrase()));
        agentConfig.setPrivProtocol(this.m_snmpCollection.getSnmpPrivProtocol(agentConfig.getPrivProtocol()));
        return agentConfig;
    }

    public void notifyIfNotFound(CollectionAttributeType attrType, SnmpResult res) {
        String baseOID = res.getBase().toString();
        if (baseOID.startsWith(".1.3.6.1.2.1.2.2.1") || baseOID.startsWith(".1.3.6.1.2.1.31.1.1.1")) {
            LOG.debug("Unable to locate interface with ifIndex {} for agent {} while collecting attribute {}. Perhaps a DO_NOT_PERSIST policy excluded this interface?", new Object[]{this.getCollectionAgent(), res.getInstance(), attrType});
        } else {
            LOG.info("Unable to locate resource for agent {} with instance id {} while collecting attribute {}", new Object[]{this.getCollectionAgent(), res.getInstance(), attrType});
        }
    }

    private NodeResourceType getNodeResourceType() {
        return this.m_snmpCollection.getNodeResourceType(this.getCollectionAgent());
    }

    private IfResourceType getIfResourceType() {
        return this.m_snmpCollection.getIfResourceType(this.getCollectionAgent());
    }

    private IfAliasResourceType getIfAliasResourceType() {
        return this.m_snmpCollection.getIfAliasResourceType(this.getCollectionAgent());
    }

    public CollectionStatus getStatus() {
        return this.m_status;
    }

    public boolean ignorePersist() {
        return this.m_ignorePersist;
    }

    public Date getCollectionTimestamp() {
        return this.m_timestamp;
    }

    public void setCollectionTimestamp(Date m_timestamp) {
        this.m_timestamp = m_timestamp;
    }

    public static class RescanNeeded {
        boolean rescanNeeded = false;

        public void rescanIndicated() {
            this.rescanNeeded = true;
        }

        public boolean rescanIsNeeded() {
            return this.rescanNeeded;
        }
    }
}

