/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.Type;
import org.opennms.netmgt.model.IsIsElement;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.topology.Topology;

@Entity
@Table(name="isisLink")
public class IsIsLink
implements Serializable,
Topology {
    private static final long serialVersionUID = 3813247749765614567L;
    private Integer m_id;
    private OnmsNode m_node;
    private Integer m_isisCircIndex;
    private Integer m_isisISAdjIndex;
    private Integer m_isisCircIfIndex;
    private IsIsElement.IsisAdminState m_isisCircAdminState;
    private IsisISAdjState m_isisISAdjState;
    private String m_isisISAdjNeighSNPAAddress;
    private IsisISAdjNeighSysType m_isisISAdjNeighSysType;
    private String m_isisISAdjNeighSysID;
    private Integer m_isisISAdjNbrExtendedCircID;
    private Date m_isisLinkCreateTime = new Date();
    private Date m_isisLinkLastPollTime;

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @Column(name="isisCircIndex", nullable=false)
    public Integer getIsisCircIndex() {
        return this.m_isisCircIndex;
    }

    public void setIsisCircIndex(Integer isisCircIndex) {
        this.m_isisCircIndex = isisCircIndex;
    }

    @Column(name="isisISAdjIndex", nullable=false)
    public Integer getIsisISAdjIndex() {
        return this.m_isisISAdjIndex;
    }

    public void setIsisISAdjIndex(Integer isisISAdjIndex) {
        this.m_isisISAdjIndex = isisISAdjIndex;
    }

    @Column(name="isisCircIfIndex", nullable=true)
    public Integer getIsisCircIfIndex() {
        return this.m_isisCircIfIndex;
    }

    public void setIsisCircIfIndex(Integer isisIfCircIndex) {
        this.m_isisCircIfIndex = isisIfCircIndex;
    }

    @Column(name="isisCircAdminState", nullable=true)
    @Type(type="org.opennms.netmgt.model.IsIsAdminStateUserType")
    public IsIsElement.IsisAdminState getIsisCircAdminState() {
        return this.m_isisCircAdminState;
    }

    public void setIsisCircAdminState(IsIsElement.IsisAdminState isisCircAdminState) {
        this.m_isisCircAdminState = isisCircAdminState;
    }

    @Column(name="isisISAdjState", nullable=false)
    @Type(type="org.opennms.netmgt.model.IsIsISAdjStateUserType")
    public IsisISAdjState getIsisISAdjState() {
        return this.m_isisISAdjState;
    }

    public void setIsisISAdjState(IsisISAdjState isisISAdjState) {
        this.m_isisISAdjState = isisISAdjState;
    }

    @Column(name="isisISAdjNeighSNPAAddress", length=80, nullable=false)
    public String getIsisISAdjNeighSNPAAddress() {
        return this.m_isisISAdjNeighSNPAAddress;
    }

    public void setIsisISAdjNeighSNPAAddress(String isisISAdjNeighSNPAAddress) {
        this.m_isisISAdjNeighSNPAAddress = isisISAdjNeighSNPAAddress;
    }

    @Column(name="isisISAdjNeighSysType", nullable=false)
    @Type(type="org.opennms.netmgt.model.IsIsISAdjNeighSysTypeUserType")
    public IsisISAdjNeighSysType getIsisISAdjNeighSysType() {
        return this.m_isisISAdjNeighSysType;
    }

    public void setIsisISAdjNeighSysType(IsisISAdjNeighSysType isisISAdjNeighSysType) {
        this.m_isisISAdjNeighSysType = isisISAdjNeighSysType;
    }

    @Column(name="isisISAdjNeighSysID", length=32, nullable=false)
    public String getIsisISAdjNeighSysID() {
        return this.m_isisISAdjNeighSysID;
    }

    public void setIsisISAdjNeighSysID(String isisISAdjNeighSysID) {
        this.m_isisISAdjNeighSysID = isisISAdjNeighSysID;
    }

    @Column(name="isisISAdjNbrExtendedCircID", nullable=false)
    public Integer getIsisISAdjNbrExtendedCircID() {
        return this.m_isisISAdjNbrExtendedCircID;
    }

    public void setIsisISAdjNbrExtendedCircID(Integer isisISAdjNbrExtendedCircID) {
        this.m_isisISAdjNbrExtendedCircID = isisISAdjNbrExtendedCircID;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="isisLinkCreateTime", nullable=false)
    public Date getIsisLinkCreateTime() {
        return this.m_isisLinkCreateTime;
    }

    public void setIsisLinkCreateTime(Date isisLinkCreateTime) {
        this.m_isisLinkCreateTime = isisLinkCreateTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="isisLinkLastPollTime", nullable=false)
    public Date getIsisLinkLastPollTime() {
        return this.m_isisLinkLastPollTime;
    }

    public void setIsisLinkLastPollTime(Date isisLinkLastPollTime) {
        this.m_isisLinkLastPollTime = isisLinkLastPollTime;
    }

    public void merge(IsIsLink link) {
        this.setIsisCircIfIndex(link.getIsisCircIfIndex());
        this.setIsisCircAdminState(link.getIsisCircAdminState());
        this.setIsisISAdjState(link.getIsisISAdjState());
        this.setIsisISAdjNeighSNPAAddress(link.getIsisISAdjNeighSNPAAddress());
        this.setIsisISAdjNeighSysType(link.getIsisISAdjNeighSysType());
        this.setIsisISAdjNeighSysID(link.getIsisISAdjNeighSysID());
        this.setIsisISAdjNbrExtendedCircID(link.getIsisISAdjNbrExtendedCircID());
        this.setIsisLinkLastPollTime(link.getIsisLinkCreateTime());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("NodeId", (Object)this.m_node.getId()).append("isisCircIndex", (Object)this.m_isisCircIndex).append("isisISAdjIndex", (Object)this.m_isisISAdjIndex).append("isisCircIfIndex", (Object)this.m_isisCircIfIndex).append("isisCircAdminState", (Object)IsIsElement.IsisAdminState.getTypeString(this.m_isisCircAdminState.getValue())).append("isisISAdjState", (Object)IsisISAdjState.getTypeString(this.m_isisISAdjState.getValue())).append("isisISAdjNeighSNPAAddress", (Object)this.m_isisISAdjNeighSNPAAddress).append("isisISAdjNeighSysType", (Object)IsisISAdjNeighSysType.getTypeString(this.m_isisISAdjNeighSysType.getValue())).append("isisISAdjNeighSysID", (Object)this.m_isisISAdjNeighSysID).append("isisISAdjNbrExtendedCircID", (Object)this.m_isisISAdjNbrExtendedCircID).append("createTime", (Object)this.m_isisLinkCreateTime).append("lastPollTime", (Object)this.m_isisLinkLastPollTime).toString();
    }

    @Override
    @Transient
    public String printTopology() {
        StringBuffer strb = new StringBuffer();
        strb.append("isislink: nodeid:[");
        strb.append(this.getNode().getId());
        strb.append("]. circIndex:[ ");
        strb.append(this.getIsisCircIndex());
        strb.append("], ifindex:[");
        strb.append(this.getIsisCircIfIndex());
        strb.append("], AdminState:[");
        strb.append(IsIsElement.IsisAdminState.getTypeString(this.getIsisCircAdminState().getValue()));
        strb.append("], ISAdjNeighSysID:[");
        strb.append(this.getIsisISAdjNeighSysID());
        strb.append("], ISAdjNeighSNPAAddress:[");
        strb.append(this.getIsisISAdjNeighSNPAAddress());
        strb.append("], ISAdjState:[");
        strb.append(IsisISAdjState.getTypeString(this.getIsisISAdjState().getValue()));
        strb.append("]");
        return strb.toString();
    }

    public static enum IsisISAdjNeighSysType {
        l1_IntermediateSystem(1),
        l2IntermediateSystem(2),
        l1L2IntermediateSystem(3),
        unknown(4);

        private int m_value;
        protected static final Map<Integer, String> s_typeMap;

        private IsisISAdjNeighSysType(int value) {
            this.m_value = value;
        }

        public static String getTypeString(Integer code) {
            if (s_typeMap.containsKey(code)) {
                return s_typeMap.get(code);
            }
            return null;
        }

        public static IsisISAdjNeighSysType get(Integer code) {
            if (code == null) {
                throw new IllegalArgumentException("Cannot create IsisISAdjNeighSysType from null code");
            }
            switch (code) {
                case 1: {
                    return l1_IntermediateSystem;
                }
                case 2: {
                    return l2IntermediateSystem;
                }
                case 3: {
                    return l1L2IntermediateSystem;
                }
                case 4: {
                    return unknown;
                }
            }
            throw new IllegalArgumentException("Cannot create IsisISAdjNeighSysType from code " + code);
        }

        public Integer getValue() {
            return this.m_value;
        }

        static {
            s_typeMap = new HashMap<Integer, String>();
            s_typeMap.put(1, "l1_IntermediateSystem");
            s_typeMap.put(2, "l2IntermediateSystem");
            s_typeMap.put(3, "l1L2IntermediateSystem");
            s_typeMap.put(4, "unknown");
        }
    }

    public static enum IsisISAdjState {
        down(1),
        initializing(2),
        up(3),
        failed(4);

        private int m_value;
        protected static final Map<Integer, String> s_typeMap;

        private IsisISAdjState(int value) {
            this.m_value = value;
        }

        public static String getTypeString(Integer code) {
            if (s_typeMap.containsKey(code)) {
                return s_typeMap.get(code);
            }
            return null;
        }

        public static IsisISAdjState get(Integer code) {
            if (code == null) {
                throw new IllegalArgumentException("Cannot create IsisISAdjState from null code");
            }
            switch (code) {
                case 1: {
                    return down;
                }
                case 2: {
                    return initializing;
                }
                case 3: {
                    return up;
                }
                case 4: {
                    return failed;
                }
            }
            throw new IllegalArgumentException("Cannot create IsisISAdjState from code " + code);
        }

        public Integer getValue() {
            return this.m_value;
        }

        static {
            s_typeMap = new HashMap<Integer, String>();
            s_typeMap.put(1, "down");
            s_typeMap.put(2, "initializing");
            s_typeMap.put(3, "up");
            s_typeMap.put(4, "failed");
        }
    }
}

