/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors.nrpe;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.zip.CRC32;
import org.opennms.netmgt.poller.monitors.nrpe.NrpeException;

public class NrpePacket {
    public static final short QUERY_PACKET = 1;
    public static final short RESPONSE_PACKET = 2;
    public static final String HELLO_COMMAND = "_NRPE_CHECK";
    public static final short PACKET_VERSION_2 = 2;
    public static final int MAX_PACKETBUFFER_LENGTH = 1024;
    public static final int PACKET_SIZE = 1034;
    public static final int DEFAULT_PADDING = 2;
    private short m_version = (short)2;
    private short m_type;
    private short m_resultCode;
    private String m_buffer;

    public NrpePacket() {
    }

    public NrpePacket(short type, short resultCode, String buffer) {
        this.m_type = type;
        this.m_resultCode = resultCode;
        this.m_buffer = buffer;
    }

    public short getVersion() {
        return this.m_version;
    }

    public void setVersion(short version) {
        this.m_version = version;
    }

    public short getType() {
        return this.m_type;
    }

    public void setType(short type) {
        this.m_type = type;
    }

    public short getResultCode() {
        return this.m_resultCode;
    }

    public void setResultCode(short resultCode) {
        this.m_resultCode = resultCode;
    }

    public String getBuffer() {
        return this.m_buffer;
    }

    public void setBuffer(String buffer) {
        this.m_buffer = buffer;
    }

    public static NrpePacket receivePacket(InputStream i, int padding) throws NrpeException, IOException {
        int j;
        NrpePacket p = new NrpePacket();
        byte[] packet = new byte[1034 + padding];
        int k = 0;
        while ((j = i.read()) != -1) {
            packet[k] = (byte)j;
            ++k;
        }
        if (k < 1034) {
            throw new NrpeException("Received packet is too small.  Received " + k + ", expected at least " + 1034);
        }
        p.m_version = (short)((NrpePacket.positive(packet[0]) << 8) + NrpePacket.positive(packet[1]));
        p.m_type = (short)((NrpePacket.positive(packet[2]) << 8) + NrpePacket.positive(packet[3]));
        long crc_l = ((long)NrpePacket.positive(packet[4]) << 24) + ((long)NrpePacket.positive(packet[5]) << 16) + ((long)NrpePacket.positive(packet[6]) << 8) + (long)NrpePacket.positive(packet[7]);
        p.m_resultCode = (short)((NrpePacket.positive(packet[8]) << 8) + NrpePacket.positive(packet[9]));
        packet[4] = 0;
        packet[5] = 0;
        packet[6] = 0;
        packet[7] = 0;
        CRC32 crc = new CRC32();
        crc.update(packet);
        long crc_calc = crc.getValue();
        if (crc_calc != crc_l) {
            throw new NrpeException("CRC mismatch: " + crc_calc + " vs. " + crc_l);
        }
        byte[] buffer = new byte[1024];
        System.arraycopy(packet, 10, buffer, 0, buffer.length);
        p.m_buffer = new String(buffer);
        j = p.m_buffer.indexOf(0);
        if (j > 0) {
            p.m_buffer = p.m_buffer.substring(0, j);
        }
        return p;
    }

    public static int positive(byte b) {
        if (b < 0) {
            return b + 256;
        }
        return b;
    }

    public String toString() {
        return "Version: " + this.m_version + "\nType: " + this.m_type + "\nResult Code: " + this.m_resultCode + "\nBuffer: " + this.m_buffer;
    }

    public byte[] buildPacket(int padding) {
        SecureRandom random;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            random = null;
        }
        return this.buildPacket(padding, random);
    }

    public byte[] buildPacket(int padding, SecureRandom random) {
        byte[] packet = new byte[1034 + padding];
        byte[] buffer = this.m_buffer.getBytes();
        if (random != null) {
            random.nextBytes(packet);
        } else {
            for (int i = 10 + buffer.length; i < packet.length; ++i) {
                packet[i] = 0;
            }
        }
        packet[0] = (byte)(this.m_version >> 8 & 0xFF);
        packet[1] = (byte)(this.m_version & 0xFF);
        packet[2] = (byte)(this.m_type >> 8 & 0xFF);
        packet[3] = (byte)(this.m_type & 0xFF);
        packet[4] = 0;
        packet[5] = 0;
        packet[6] = 0;
        packet[7] = 0;
        packet[8] = (byte)(this.m_resultCode >> 8 & 0xFF);
        packet[9] = (byte)(this.m_resultCode & 0xFF);
        System.arraycopy(buffer, 0, packet, 10, buffer.length);
        if (10 + buffer.length < 1033) {
            packet[10 + buffer.length] = 0;
        }
        packet[1033] = 0;
        CRC32 crc = new CRC32();
        crc.update(packet);
        long crc_l = crc.getValue();
        packet[4] = (byte)(crc_l >> 24 & 0xFFL);
        packet[5] = (byte)(crc_l >> 16 & 0xFFL);
        packet[6] = (byte)(crc_l >> 8 & 0xFFL);
        packet[7] = (byte)(crc_l & 0xFFL);
        return packet;
    }
}

