/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.remote.OnmsPollModel;

public class PolledService
implements MonitoredService,
Serializable,
Comparable<PolledService> {
    private static final long serialVersionUID = 3L;
    private final InetAddress m_address;
    private final Map<String, Object> m_monitorConfiguration;
    private final OnmsPollModel m_pollModel;
    private final Integer m_serviceId;
    private final Integer m_nodeId;
    private final String m_nodeLabel;
    private final String m_nodeLocation;
    private final String m_svcName;
    private final Set<String> m_applications;

    public PolledService(OnmsMonitoredService monitoredService, Map<String, Object> monitorConfiguration, OnmsPollModel pollModel) {
        this.m_serviceId = monitoredService.getId();
        this.m_nodeId = monitoredService.getNodeId();
        this.m_nodeLabel = monitoredService.getIpInterface().getNode().getLabel();
        this.m_nodeLocation = monitoredService.getIpInterface().getNode().getLocation().getLocationName();
        this.m_svcName = monitoredService.getServiceName();
        this.m_address = monitoredService.getIpInterface().getIpAddress();
        this.m_monitorConfiguration = monitorConfiguration;
        this.m_pollModel = pollModel;
        this.m_applications = monitoredService.getApplications().stream().map(OnmsApplication::getName).collect(Collectors.toSet());
    }

    public Integer getServiceId() {
        return this.m_serviceId;
    }

    public InetAddress getAddress() {
        return this.m_address;
    }

    public String getIpAddr() {
        return InetAddressUtils.str((InetAddress)this.m_address);
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public String getNodeLabel() {
        return this.m_nodeLabel;
    }

    public String getNodeLocation() {
        return this.m_nodeLocation;
    }

    public Set<String> getApplications() {
        return this.m_applications;
    }

    public String getSvcName() {
        return this.m_svcName;
    }

    public Map<String, Object> getMonitorConfiguration() {
        return this.m_monitorConfiguration;
    }

    public OnmsPollModel getPollModel() {
        return this.m_pollModel;
    }

    public String toString() {
        return this.getNodeId() + ":" + this.getIpAddr() + ":" + this.getSvcName();
    }

    public int hashCode() {
        return new HashCodeBuilder(3, 57).append(this.getNodeId()).append((Object)this.getIpAddr()).append((Object)this.getServiceId()).toHashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof PolledService)) {
            return false;
        }
        PolledService that = (PolledService)o;
        return new EqualsBuilder().append(this.getNodeId(), that.getNodeId()).append((Object)this.getIpAddr(), (Object)that.getIpAddr()).append((Object)this.getServiceId(), (Object)that.getServiceId()).isEquals();
    }

    @Override
    public int compareTo(PolledService that) {
        if (that == null) {
            return -1;
        }
        return new CompareToBuilder().append(this.getNodeId(), that.getNodeId()).append((Object)this.getNodeLabel(), (Object)that.getNodeLabel()).append((Object)this.getIpAddr(), (Object)that.getIpAddr()).append((Object)this.getSvcName(), (Object)that.getSvcName()).append((Object)this.getServiceId(), (Object)that.getServiceId()).toComparison();
    }
}

