/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public final class MemcachedMonitor
extends AbstractServiceMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(MemcachedMonitor.class);
    private static final int DEFAULT_PORT = 11211;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final String[] m_keys = new String[]{"uptime", "rusageuser", "rusagesystem", "curritems", "totalitems", "bytes", "limitmaxbytes", "currconnections", "totalconnections", "connectionstructure", "cmdget", "cmdset", "gethits", "getmisses", "evictions", "bytesread", "byteswritten", "threads"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        TimeoutTracker timeoutTracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)11211);
        InetAddress ipv4Addr = svc.getAddress();
        String host = InetAddressUtils.str((InetAddress)ipv4Addr);
        LOG.debug("polling interface: {} {}", (Object)host, (Object)timeoutTracker);
        PollStatus serviceStatus = PollStatus.unavailable();
        timeoutTracker.reset();
        while (timeoutTracker.shouldRetry() && !serviceStatus.isAvailable()) {
            String reason;
            Socket socket = null;
            try {
                timeoutTracker.startAttempt();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipv4Addr, port), timeoutTracker.getConnectionTimeout());
                socket.setSoTimeout(timeoutTracker.getSoTimeout());
                LOG.debug("connected to host: {} on port: {}", (Object)host, (Object)port);
                serviceStatus = PollStatus.unresponsive();
                OutputStreamWriter osw = new OutputStreamWriter(socket.getOutputStream(), "UTF-8");
                osw.write("stats\n");
                osw.flush();
                BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                LinkedHashMap<String, Number> statProps = new LinkedHashMap<String, Number>();
                for (String key : m_keys) {
                    statProps.put(key, null);
                }
                String line = null;
                while ((line = reader.readLine()) != null) {
                    String[] statEntry = line.trim().split("\\s", 3);
                    if (statEntry[0].equals("STAT")) {
                        try {
                            String key;
                            Number value = statEntry[2].contains(".") ? (Number)Double.parseDouble(statEntry[2]) : (Number)Long.parseLong(statEntry[2]);
                            key = statEntry[1].toLowerCase();
                            key = key.replaceAll("_", "");
                            if (key.length() > 19) {
                                key = key.substring(0, 19);
                            }
                            if (statProps.containsKey(key)) {
                                statProps.put(key, value);
                            }
                        }
                        catch (Throwable throwable) {}
                    } else if (statEntry[0].equals("END")) {
                        serviceStatus = PollStatus.available();
                        osw.write("quit\n");
                        osw.flush();
                        break;
                    }
                    if (line != null) continue;
                }
                serviceStatus.setProperties(statProps);
                serviceStatus.setResponseTime(timeoutTracker.elapsedTimeInMillis());
            }
            catch (ConnectException e) {
                reason = "Connection refused by host " + host;
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable(reason);
            }
            catch (NoRouteToHostException e) {
                reason = "Unable to test host " + host + ", no route available";
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable(reason);
            }
            catch (InterruptedIOException e) {
                reason = "did not connect to host " + host + " within timeout: " + timeoutTracker;
                LOG.debug(reason);
                serviceStatus = PollStatus.unavailable(reason);
            }
            catch (IOException e) {
                reason = "Error communicating with host " + host;
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable(reason);
            }
            catch (Throwable t) {
                reason = "Undeclared throwable exception caught contacting host " + host;
                LOG.debug(reason, t);
                serviceStatus = PollStatus.unavailable(reason);
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                        socket = null;
                    }
                }
                catch (IOException e) {}
            }
            timeoutTracker.nextAttempt();
        }
        return serviceStatus;
    }
}

