/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import com.google.common.collect.Maps;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.api.TimeKeeper;
import org.opennms.netmgt.dao.api.MonitoringLocationUtils;
import org.opennms.netmgt.model.ResourcePath;

public class LatencyCollectionResource
implements CollectionResource {
    private final String m_serviceName;
    private final String m_ipAddress;
    private final String m_location;
    private final Map<AttributeGroupType, AttributeGroup> m_attributeGroups = Maps.newLinkedHashMap();

    public LatencyCollectionResource(String serviceName, String ipAddress, String location) {
        this.m_serviceName = serviceName;
        this.m_ipAddress = ipAddress;
        this.m_location = location;
    }

    public String getInstance() {
        return this.m_ipAddress + "[" + this.m_serviceName + "]";
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public String getIpAddress() {
        return this.m_ipAddress;
    }

    public String getInterfaceLabel() {
        return this.m_serviceName;
    }

    public String getResourceTypeName() {
        return "if";
    }

    public boolean rescanNeeded() {
        return false;
    }

    public boolean shouldPersist(ServiceParameters params) {
        return true;
    }

    public void addAttribute(CollectionAttribute attr) {
        AttributeGroup group = this.getGroup(attr.getAttributeType().getGroupType());
        group.addAttribute(attr);
    }

    public final AttributeGroup getGroup(AttributeGroupType groupType) {
        AttributeGroup group = this.m_attributeGroups.get(groupType);
        if (group == null) {
            group = new AttributeGroup((CollectionResource)this, groupType);
            this.m_attributeGroups.put(groupType, group);
        }
        return group;
    }

    public void visit(CollectionSetVisitor visitor) {
        visitor.visitResource((CollectionResource)this);
        for (AttributeGroup group : this.m_attributeGroups.values()) {
            group.visit(visitor);
        }
        visitor.completeResource((CollectionResource)this);
    }

    public String getOwnerName() {
        return this.m_ipAddress;
    }

    public Path getPath() {
        if (MonitoringLocationUtils.isDefaultLocationName((String)this.m_location)) {
            return Paths.get(this.m_ipAddress, new String[0]);
        }
        return Paths.get(ResourcePath.sanitize((String)this.m_location), this.m_ipAddress);
    }

    public String toString() {
        return String.format("%s on %s at %s", this.m_serviceName, this.m_ipAddress, this.m_location);
    }

    public String getParent() {
        return this.m_ipAddress;
    }

    public TimeKeeper getTimeKeeper() {
        return null;
    }
}

