/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OspfLink;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OspfIfTableTracker
extends TableTracker {
    private static final Logger LOG = LoggerFactory.getLogger(OspfIfTableTracker.class);
    public static final SnmpObjId OSPF_IF_TABLE_ENTRY = SnmpObjId.get((String)".1.3.6.1.2.1.14.7.1");
    public static final SnmpObjId OSPF_IF_IPADDRESS = SnmpObjId.get((String)".1.3.6.1.2.1.14.7.1.1");
    public static final SnmpObjId OSPF_ADDRESS_LESS_IF = SnmpObjId.get((String)".1.3.6.1.2.1.14.7.1.2");
    public static final SnmpObjId[] s_ospfiftable_elemList = new SnmpObjId[]{OSPF_IF_IPADDRESS, OSPF_ADDRESS_LESS_IF};

    public OspfIfTableTracker() {
        super(s_ospfiftable_elemList);
    }

    public OspfIfTableTracker(RowCallback rowProcessor) {
        super(rowProcessor, s_ospfiftable_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new OspfIfRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processOspfIfRow((OspfIfRow)row);
    }

    public void processOspfIfRow(OspfIfRow row) {
    }

    public static class OspfIfRow
    extends SnmpRowResult {
        public OspfIfRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
            LOG.debug("column count = {}, instance = {}", (Object)columnCount, (Object)instance);
        }

        public InetAddress getOspfIpAddress() {
            return this.getValue(OSPF_IF_IPADDRESS).toInetAddress();
        }

        public Integer getOspfAddressLessIf() {
            return this.getValue(OSPF_ADDRESS_LESS_IF).toInt();
        }

        public OspfLink getOspfLink() {
            LOG.info("getOspfLink: row ospf ip address: {}", (Object)InetAddressUtils.str((InetAddress)this.getOspfIpAddress()));
            LOG.info("getOspfLink: row ospf address less ifindex: {}", (Object)this.getOspfAddressLessIf());
            OspfLink link = new OspfLink();
            link.setOspfIpAddr(this.getOspfIpAddress());
            link.setOspfAddressLessIndex(this.getOspfAddressLessIf());
            return link;
        }
    }
}

