/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.enlinkd.snmp.OspfGeneralGroupTracker;
import org.opennms.netmgt.enlinkd.snmp.OspfIfTableTracker;
import org.opennms.netmgt.enlinkd.snmp.OspfIpAddrTableGetter;
import org.opennms.netmgt.enlinkd.snmp.OspfNbrTableTracker;
import org.opennms.netmgt.model.OspfElement;
import org.opennms.netmgt.model.OspfLink;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryOspf
extends NodeDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryOspf.class);

    public NodeDiscoveryOspf(EnhancedLinkd linkd, Node node) {
        super(linkd, node);
    }

    @Override
    protected void runCollection() {
        Date now = new Date();
        LOG.debug("run: collecting : {}", (Object)this.getPeer());
        OspfIpAddrTableGetter ipAddrTableGetter = new OspfIpAddrTableGetter(this.getPeer(), this.m_linkd.getLocationAwareSnmpClient(), this.getLocation());
        OspfGeneralGroupTracker ospfGeneralGroup = new OspfGeneralGroupTracker();
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(this.getPeer(), (CollectionTracker)ospfGeneralGroup).withDescription("ospfGeneralGroup").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: Agent error while scanning the ospfGeneralGroup table", (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            LOG.error("run: Ospf Linkd node collection interrupted, exiting", (Throwable)e);
            return;
        }
        if (ospfGeneralGroup.getOspfRouterId() == null) {
            LOG.info("ospf mib not supported on: {}", (Object)InetAddressUtils.str((InetAddress)this.getPeer().getAddress()));
            return;
        }
        if (ospfGeneralGroup.getOspfRouterId().equals(InetAddressUtils.addr((String)"0.0.0.0"))) {
            LOG.info("ospf not supported, ospf identifier 0.0.0.0 is not valid on: {}", (Object)InetAddressUtils.str((InetAddress)this.getPeer().getAddress()));
            return;
        }
        if (OspfElement.Status.get((Integer)ospfGeneralGroup.getOspfAdminStat()) == OspfElement.Status.disabled) {
            LOG.info("ospf status disabled on: {}", (Object)InetAddressUtils.str((InetAddress)this.getPeer().getAddress()));
            return;
        }
        this.m_linkd.getQueryManager().store(this.getNodeId(), ipAddrTableGetter.get(ospfGeneralGroup.getOspfElement()));
        final ArrayList links = new ArrayList();
        OspfNbrTableTracker ospfNbrTableTracker = new OspfNbrTableTracker(){

            @Override
            public void processOspfNbrRow(OspfNbrTableTracker.OspfNbrRow row) {
                links.add(row.getOspfLink());
            }
        };
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(this.getPeer(), (CollectionTracker)ospfNbrTableTracker).withDescription("ospfNbrTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.error("run: collection execution failed, exiting", (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        final ArrayList localOspfPorts = new ArrayList();
        OspfIfTableTracker ospfIfTableTracker = new OspfIfTableTracker(){

            @Override
            public void processOspfIfRow(OspfIfTableTracker.OspfIfRow row) {
                localOspfPorts.add(row.getOspfLink());
            }
        };
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(this.getPeer(), (CollectionTracker)ospfIfTableTracker).withDescription("ospfIfTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.error("run: collection execution failed, exiting", (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        for (OspfLink link : links) {
            for (OspfLink localospfport : localOspfPorts) {
                if (!InetAddressUtils.inSameNetwork((InetAddress)(localospfport = ipAddrTableGetter.get(localospfport)).getOspfIpAddr(), (InetAddress)link.getOspfRemIpAddr(), (InetAddress)localospfport.getOspfIpMask())) continue;
                link.setOspfIpAddr(localospfport.getOspfIpAddr());
                link.setOspfAddressLessIndex(localospfport.getOspfAddressLessIndex());
                link.setOspfIpMask(localospfport.getOspfIpMask());
                link.setOspfIfIndex(localospfport.getOspfIfIndex());
            }
            this.m_linkd.getQueryManager().store(this.getNodeId(), link);
        }
        this.m_linkd.getQueryManager().reconcileOspf(this.getNodeId(), now);
    }

    @Override
    public String getInfo() {
        return "ReadyRunnable:OspfLinkNodeDiscovery node: " + this.getNodeId() + " ip:" + InetAddressUtils.str((InetAddress)this.getTarget()) + " package:" + this.getPackageName();
    }

    @Override
    public String getName() {
        return "OspfLinkDiscovery";
    }
}

