/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.enlinkd.snmp.LldpLocPortGetter;
import org.opennms.netmgt.enlinkd.snmp.LldpLocalGroupTracker;
import org.opennms.netmgt.enlinkd.snmp.LldpRemTableTracker;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryLldp
extends NodeDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryLldp.class);
    private static final String DW_SYSOID = ".1.3.6.1.4.1.7262.2.4";
    private static final String DW_NULL_CHASSIS_ID = "cf";
    private static final String DW_NULL_SYSOID_ID = "NuDesign";

    public NodeDiscoveryLldp(EnhancedLinkd linkd, Node node) {
        super(linkd, node);
    }

    @Override
    protected void runCollection() {
        Date now = new Date();
        LOG.debug("run: collecting : {}", (Object)this.getPeer());
        LldpLocalGroupTracker lldpLocalGroup = new LldpLocalGroupTracker();
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(this.getPeer(), (CollectionTracker)lldpLocalGroup).withDescription("lldpLocalGroup").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: Agent error while scanning the lldpLocalGroup table", (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            LOG.info("run: Lldp Linkd lldpLocalGroup table collection interrupted", (Throwable)e);
            return;
        }
        if (lldpLocalGroup.getLldpLocChassisid() == null) {
            LOG.info("lldp mib not supported on: {}", (Object)InetAddressUtils.str((InetAddress)this.getPeer().getAddress()));
            return;
        }
        LOG.info("found lldp identifier : {}", (Object)lldpLocalGroup.getLldpElement());
        this.m_linkd.getQueryManager().store(this.getNodeId(), lldpLocalGroup.getLldpElement());
        if (this.getSysoid() == null || this.getSysoid().equals(DW_SYSOID)) {
            if (lldpLocalGroup.getLldpLocChassisid().toHexString().equals(DW_NULL_CHASSIS_ID) && lldpLocalGroup.getLldpLocChassisidSubType() == LldpUtils.LldpChassisIdSubType.LLDP_CHASSISID_SUBTYPE_CHASSISCOMPONENT.getValue()) {
                LOG.info("lldp not active for Dragon Wave Device identifier : {}", (Object)lldpLocalGroup.getLldpElement());
                return;
            }
            if (lldpLocalGroup.getLldpLocSysname().equals(DW_NULL_SYSOID_ID)) {
                LOG.info("lldp not active for Dragon Wave Device identifier : {}", (Object)lldpLocalGroup.getLldpElement());
                return;
            }
        }
        final ArrayList links = new ArrayList();
        LldpRemTableTracker lldpRemTable = new LldpRemTableTracker(){

            @Override
            public void processLldpRemRow(LldpRemTableTracker.LldpRemRow row) {
                links.add(row.getLldpLink());
            }
        };
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(this.getPeer(), (CollectionTracker)lldpRemTable).withDescription("lldpRemTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.error("run: collection execution failed, exiting", (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            LOG.error("run: collection interrupted, exiting", (Throwable)e);
            return;
        }
        LldpLocPortGetter lldpLocPort = new LldpLocPortGetter(this.getPeer(), this.m_linkd.getLocationAwareSnmpClient(), this.getLocation());
        for (LldpLink link : links) {
            this.m_linkd.getQueryManager().store(this.getNodeId(), lldpLocPort.getLldpLink(link));
        }
        this.m_linkd.getQueryManager().reconcileLldp(this.getNodeId(), now);
    }

    @Override
    public String getInfo() {
        return "ReadyRunnable:LldpLinkNodeDiscovery node: " + this.getNodeId() + " ip:" + InetAddressUtils.str((InetAddress)this.getTarget()) + " package:" + this.getPackageName();
    }

    @Override
    public String getName() {
        return "LldpLinkDiscovery";
    }
}

