/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForceRescanState {
    private static final Logger LOG = LoggerFactory.getLogger(ForceRescanState.class);
    private CollectionAgent m_agent;
    private EventProxy m_eventProxy;
    private boolean m_forceRescanSent = false;

    public ForceRescanState(CollectionAgent agent, EventProxy eventProxy) {
        this.m_agent = agent;
        this.m_eventProxy = eventProxy;
    }

    public EventProxy getEventProxy() {
        return this.m_eventProxy;
    }

    public Event createForceResanEvent() {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/capsd/forceRescan", "SnmpCollector");
        bldr.setNodeid((long)this.m_agent.getNodeId());
        bldr.setInterface((InetAddress)this.m_agent.getAddress());
        bldr.setService("SNMP");
        bldr.setHost(InetAddressUtils.getLocalHostName());
        return bldr.getEvent();
    }

    public CollectionAgent getAgent() {
        return this.m_agent;
    }

    void sendForceRescanEvent() {
        LOG.debug("generateForceRescanEvent: interface = {}", (Object)this.getAgent().getHostAddress());
        try {
            this.getEventProxy().send(this.createForceResanEvent());
        }
        catch (EventProxyException e) {
            LOG.error("generateForceRescanEvent: Unable to send forceRescan event.", (Throwable)e);
        }
    }

    void rescanIndicated() {
        if (!this.m_forceRescanSent) {
            this.sendForceRescanEvent();
            this.m_forceRescanSent = true;
        }
    }
}

