/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.db;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.beans.PropertyVetoException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import javax.sql.DataSource;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.db.BaseConnectionFactory;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.opennms.netmgt.config.opennmsDataSources.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariCPConnectionFactory
extends BaseConnectionFactory {
    public static final Logger LOG = LoggerFactory.getLogger(HikariCPConnectionFactory.class);
    private HikariDataSource m_pool;

    public HikariCPConnectionFactory(JdbcDataSource dataSource) throws MarshalException, ValidationException, PropertyVetoException, SQLException {
        super(dataSource);
    }

    @Override
    protected void initializePool(JdbcDataSource dataSource) throws SQLException {
        Properties properties = new Properties();
        for (Param parameter : dataSource.getParamCollection()) {
            properties.setProperty(parameter.getName(), parameter.getValue());
        }
        HikariConfig config = new HikariConfig(properties);
        config.setPoolName(dataSource.getName());
        config.setJdbcUrl(dataSource.getUrl());
        config.setUsername(dataSource.getUserName());
        config.setPassword(dataSource.getPassword());
        config.setDriverClassName(dataSource.getClassName());
        config.setRegisterMbeans(true);
        config.validate();
        this.m_pool = new HikariDataSource(config);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.m_pool.getConnection();
    }

    @Override
    public String getUrl() {
        return this.m_pool.getJdbcUrl();
    }

    @Override
    public void setUrl(String url) {
        HikariCPConnectionFactory.validateJdbcUrl(url);
        this.m_pool.setJdbcUrl(url);
    }

    @Override
    public String getUser() {
        return this.m_pool.getUsername();
    }

    @Override
    public void setUser(String user) {
        this.m_pool.setUsername(user);
    }

    @Override
    public DataSource getDataSource() {
        return this.m_pool;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.m_pool.getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.m_pool.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.m_pool.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.m_pool.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.m_pool.getLoginTimeout();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger not supported");
    }

    @Override
    public void close() {
        super.close();
        LOG.info("Closing HikariCP pool.");
        this.m_pool.close();
    }

    @Override
    public void setIdleTimeout(int idleTimeout) {
        this.m_pool.setIdleTimeout((long)idleTimeout * 1000L);
    }

    public void setMaxLifetime(int maxLifetimeMs) {
        this.m_pool.setMaxLifetime((long)maxLifetimeMs);
    }

    @Override
    public void setMinPool(int minPool) {
        LOG.debug("Hikari has no equivalent to setMinPool(). Ignoring.");
    }

    @Override
    public void setMaxPool(int maxPool) {
        this.m_pool.setMaximumPoolSize(maxPool);
    }

    @Override
    public void setMaxSize(int maxSize) {
        LOG.debug("Hikari has no equivalent to setMaxSize(). Ignoring.");
    }
}

