/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;

final class DisruptorUtil {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int RINGBUFFER_MIN_SIZE = 128;
    private static final int RINGBUFFER_DEFAULT_SIZE = 262144;

    private DisruptorUtil() {
    }

    static WaitStrategy createWaitStrategy(String propertyName) {
        String strategy = PropertiesUtil.getProperties().getStringProperty(propertyName);
        if (strategy != null) {
            LOGGER.trace("property {}={}", new Object[]{propertyName, strategy});
            if ("Sleep".equalsIgnoreCase(strategy)) {
                return new SleepingWaitStrategy();
            }
            if ("Yield".equalsIgnoreCase(strategy)) {
                return new YieldingWaitStrategy();
            }
            if ("Block".equalsIgnoreCase(strategy)) {
                return new BlockingWaitStrategy();
            }
        }
        return new BlockingWaitStrategy();
    }

    static int calculateRingBufferSize(String propertyName) {
        int ringBufferSize = 262144;
        String userPreferredRBSize = PropertiesUtil.getProperties().getStringProperty(propertyName, String.valueOf(ringBufferSize));
        try {
            int size = Integer.parseInt(userPreferredRBSize);
            if (size < 128) {
                size = 128;
                LOGGER.warn("Invalid RingBufferSize {}, using minimum size {}.", new Object[]{userPreferredRBSize, 128});
            }
            ringBufferSize = size;
        }
        catch (Exception ex) {
            LOGGER.warn("Invalid RingBufferSize {}, using default size {}.", new Object[]{userPreferredRBSize, ringBufferSize});
        }
        return Integers.ceilingNextPowerOfTwo(ringBufferSize);
    }

    static <T> ExceptionHandler<T> getExceptionHandler(String propertyName, Class<T> type) {
        String cls = PropertiesUtil.getProperties().getStringProperty(propertyName);
        if (cls == null) {
            return null;
        }
        try {
            Class<?> klass = Class.forName(cls);
            return (ExceptionHandler)klass.newInstance();
        }
        catch (Exception ignored) {
            LOGGER.debug("Invalid {} value: error creating {}: ", new Object[]{propertyName, cls, ignored});
            return null;
        }
    }

    public static long getExecutorThreadId(ExecutorService executor) {
        Future<Long> result = executor.submit(new Callable<Long>(){

            @Override
            public Long call() {
                return Thread.currentThread().getId();
            }
        });
        try {
            return result.get();
        }
        catch (Exception ex) {
            String msg = "Could not obtain executor thread Id. Giving up to avoid the risk of application deadlock.";
            throw new IllegalStateException("Could not obtain executor thread Id. Giving up to avoid the risk of application deadlock.", ex);
        }
    }
}

