/*
 * Decompiled with CFR 0.152.
 */
package simple.util.schedule;

import simple.util.schedule.Scheduler;

public class PulseScheduler
extends Scheduler {
    protected static final long DEFAULT_FREQ = 100L;
    protected long pulse;
    protected long half;

    public PulseScheduler() {
        this(120000L, 100L);
    }

    public PulseScheduler(long max) {
        this(max, 100L);
    }

    public PulseScheduler(long max, long freq) {
        super(max);
        this.pulse = freq > 0L ? freq : 1L;
        this.half = this.pulse >> 1;
    }

    protected void enqueue(Scheduler.Entry entry) {
        long over = entry.timeout % this.pulse;
        entry.timeout -= over;
        if (over > this.half) {
            entry.timeout += this.pulse;
        }
        super.enqueue(entry);
    }
}

