/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jmx.impl.connection.connectors;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionWrapper;
import org.opennms.netmgt.jmx.impl.connection.connectors.Jsr160ConnectionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Jsr160ConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(Jsr160ConnectionFactory.class);
    private static final long DEFAULT_TIMEOUT = 30000L;
    private static final ExecutorService executor = Executors.newCachedThreadPool();

    public static JmxServerConnectionWrapper getMBeanServerConnection(Map<String, ?> propertiesMap, InetAddress address) throws MalformedURLException, IOException {
        String factory = ParameterMap.getKeyedString(propertiesMap, (String)"factory", (String)"STANDARD");
        int port = ParameterMap.getKeyedInteger(propertiesMap, (String)"port", (int)1099);
        String protocol = ParameterMap.getKeyedString(propertiesMap, (String)"protocol", (String)"rmi");
        String urlPath = ParameterMap.getKeyedString(propertiesMap, (String)"urlPath", (String)"/jmxrmi");
        String username = ParameterMap.getKeyedString(propertiesMap, (String)"username", null);
        String password = ParameterMap.getKeyedString(propertiesMap, (String)"password", null);
        long timeout = ParameterMap.getKeyedLong(propertiesMap, (String)"timeout", (long)30000L);
        String hostAddress = InetAddressUtils.toUrlIpAddress((InetAddress)address);
        LOG.debug("JMX: {} - service:{}//{}:{}{}", new Object[]{factory, protocol, hostAddress, port, urlPath});
        if (factory == null || factory.equals("STANDARD")) {
            final JMXServiceURL url = Jsr160ConnectionFactory.getUrl(address, port, protocol, urlPath);
            Callable<JMXConnector> task = new Callable<JMXConnector>(){

                @Override
                public JMXConnector call() throws IOException {
                    return JMXConnectorFactory.connect(url);
                }
            };
            Future<JMXConnector> future = executor.submit(task);
            JMXConnector connector = null;
            try {
                connector = future.get(timeout, TimeUnit.MILLISECONDS);
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                return new Jsr160ConnectionWrapper(connector, connection);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LOG.info("Exception connecting JMXConnectorFactory url {} , Error: {}", (Object)url, (Object)e.getMessage());
                if (!future.isDone()) {
                    future.cancel(true);
                    LOG.info(" the task {}", (Object)(future.isCancelled() ? "was cancelled" : "could not be cancelled"));
                }
                throw new ConnectException("Error connecting JMXConnectionFactory  " + url);
            }
        }
        if (factory.equals("PASSWORD-CLEAR")) {
            final HashMap<String, String[]> env = new HashMap<String, String[]>();
            String[] credentials = new String[]{username, password};
            env.put("jmx.remote.credentials", credentials);
            JMXServiceURL url = Jsr160ConnectionFactory.getUrl(address, port, protocol, urlPath);
            final JMXConnector connector = JMXConnectorFactory.newJMXConnector(url, null);
            Callable<Void> task = new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    connector.connect(env);
                    return null;
                }
            };
            Future<Void> future = executor.submit(task);
            try {
                future.get(timeout, TimeUnit.MILLISECONDS);
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                return new Jsr160ConnectionWrapper(connector, connection);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LOG.info("Exception connecting JMXConnectorFactory url {} , Error: {}", (Object)url, (Object)e.getMessage());
                if (!future.isDone()) {
                    future.cancel(true);
                    LOG.info(" the task {}", (Object)(future.isCancelled() ? "was cancelled" : "could not be cancelled"));
                }
                throw new ConnectException("Error connecting JMXConnectionFactory  " + url);
            }
        }
        throw new IOException("Unsupported connection factory: " + factory);
    }

    public static JMXServiceURL getUrl(InetAddress address, int port, String protocol, String urlPath) throws MalformedURLException {
        if (protocol.equalsIgnoreCase("jmxmp") || protocol.equalsIgnoreCase("remoting-jmx")) {
            return new JMXServiceURL(protocol, InetAddressUtils.toUrlIpAddress((InetAddress)address), port, urlPath);
        }
        return new JMXServiceURL("service:jmx:" + protocol + ":///jndi/" + protocol + "://" + InetAddressUtils.toUrlIpAddress((InetAddress)address) + ":" + port + urlPath);
    }
}

