/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Spliterators;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.IteratorUtils;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.api.DiscoveryConfigurationFactory;
import org.opennms.netmgt.config.discovery.DiscoveryConfiguration;
import org.opennms.netmgt.config.discovery.ExcludeRange;
import org.opennms.netmgt.config.discovery.IncludeRange;
import org.opennms.netmgt.config.discovery.IncludeUrl;
import org.opennms.netmgt.config.discovery.Specific;
import org.opennms.netmgt.model.discovery.IPPollAddress;
import org.opennms.netmgt.model.discovery.IPPollRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class DiscoveryConfigFactory
implements DiscoveryConfigurationFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryConfigFactory.class);
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    public static final String COMMENT_STR = "#";
    public static final char COMMENT_CHAR = '#';
    public static final double DEFAULT_PACKETS_PER_SECOND = 1.0;
    public static final int DEFAULT_INITIAL_SLEEP_TIME = 30000;
    public static final int DEFAULT_RESTART_SLEEP_TIME = 86400000;
    public static final int DEFAULT_RETRIES = 1;
    public static final long DEFAULT_TIMEOUT = 2000L;
    public static final int DEFAULT_CHUNK_SIZE = 100;
    private DiscoveryConfiguration m_config;

    public static DiscoveryConfigFactory getInstance() {
        return (DiscoveryConfigFactory)BeanUtils.getBean((String)"commonContext", (String)"discoveryFactory", DiscoveryConfigFactory.class);
    }

    public DiscoveryConfigFactory() throws MarshalException, ValidationException, IOException {
        this.reload();
    }

    public DiscoveryConfigFactory(DiscoveryConfiguration config) {
        this.m_config = config;
    }

    public Lock getReadLock() {
        return this.m_readLock;
    }

    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    public synchronized void reload() throws MarshalException, ValidationException, IOException {
        try {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.DISCOVERY_CONFIG_FILE_NAME);
            LOG.debug("reload: config file path {}", (Object)cfgFile.getPath());
            FileSystemResource resource = new FileSystemResource(cfgFile);
            this.m_config = (DiscoveryConfiguration)CastorUtils.unmarshal(DiscoveryConfiguration.class, (Resource)resource);
            try {
                this.getInitialSleepTime();
                this.getRestartSleepTime();
                this.getIntraPacketDelay();
                this.getConfiguredAddresses();
            }
            catch (Throwable e) {
                throw new ValidationException("An error occurred while validating the configuration: " + e.getMessage(), e);
            }
        }
        catch (IOException | MarshalException | ValidationException e) {
            LOG.error("Could not unmarshal configuration file: " + ConfigFileConstants.getFileName((int)ConfigFileConstants.DISCOVERY_CONFIG_FILE_NAME), e);
            throw e;
        }
    }

    public synchronized DiscoveryConfiguration getConfiguration() {
        return this.m_config;
    }

    protected void saveXml(String xml) throws IOException {
        if (xml != null) {
            block4: {
                OutputStreamWriter fileWriter = null;
                this.getWriteLock().lock();
                try {
                    fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.DISCOVERY_CONFIG_FILE_NAME)), "UTF-8");
                    fileWriter.write(xml);
                    ((Writer)fileWriter).flush();
                    if (fileWriter == null) break block4;
                }
                catch (Throwable throwable) {
                    if (fileWriter != null) {
                        IOUtils.closeQuietly(fileWriter);
                    }
                    this.getWriteLock().unlock();
                    throw throwable;
                }
                IOUtils.closeQuietly((Writer)fileWriter);
            }
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfiguration(DiscoveryConfiguration configuration) throws MarshalException, ValidationException, IOException {
        this.getWriteLock().lock();
        try {
            StringWriter stringWriter = new StringWriter();
            Marshaller.marshal((Object)configuration, (Writer)stringWriter);
            String xml = stringWriter.toString();
            LOG.debug("saving configuration...");
            this.saveXml(xml);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addToSpecificsFromURL(List<IPPollAddress> specifics, String url, String foreignSource, String location, long timeout, int retries) {
        boolean bl;
        URL fileURL;
        InputStream is;
        block5: {
            is = null;
            fileURL = new URL(url);
            is = fileURL.openStream();
            if (is != null) break block5;
            LOG.warn("URL does not exist: {}", (Object)url);
            boolean bl2 = true;
            IOUtils.closeQuietly((InputStream)is);
            return bl2;
        }
        try {
            bl = DiscoveryConfigFactory.addToSpecificsFromURL(specifics, fileURL.openStream(), foreignSource, location, timeout, retries);
        }
        catch (IOException e) {
            boolean bl3;
            try {
                LOG.error("Error reading URL: {}", (Object)url);
                bl3 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            return bl3;
        }
        IOUtils.closeQuietly((InputStream)is);
        return bl;
    }

    public static boolean addToSpecificsFromURL(List<IPPollAddress> specifics, InputStream is, String foreignSource, String location, long timeout, int retries) throws IOException {
        boolean bRet = true;
        try {
            BufferedReader buffer = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String ipLine = null;
            String specIP = null;
            while ((ipLine = buffer.readLine()) != null) {
                if ((ipLine = ipLine.trim()).length() == 0 || ipLine.charAt(0) == '#') continue;
                int comIndex = ipLine.indexOf(COMMENT_STR);
                if (comIndex == -1) {
                    specIP = ipLine;
                } else {
                    specIP = ipLine.substring(0, comIndex);
                    specIP = specIP.trim();
                }
                try {
                    specifics.add(new IPPollAddress(foreignSource, location, InetAddressUtils.addr((String)specIP), timeout, retries));
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Unknown host '{}' inside discovery include file: address ignored", (Object)specIP);
                }
                specIP = null;
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Your JVM doesn't support UTF-8");
            return false;
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IPPollAddress> getURLSpecifics() {
        LinkedList<IPPollAddress> specifics = new LinkedList<IPPollAddress>();
        this.getReadLock().lock();
        try {
            Long defaultTimeout = null;
            Integer defaultRetries = null;
            if (this.getConfiguration().hasTimeout()) {
                defaultTimeout = this.getConfiguration().getTimeout();
            }
            if (this.getConfiguration().hasRetries()) {
                defaultRetries = this.getConfiguration().getRetries();
            }
            for (IncludeUrl url : this.getConfiguration().getIncludeUrlCollection()) {
                long timeout = 2000L;
                if (url.hasTimeout()) {
                    timeout = url.getTimeout();
                } else if (defaultTimeout != null) {
                    timeout = this.getConfiguration().getTimeout();
                }
                int retries = 1;
                if (url.hasRetries()) {
                    retries = url.getRetries();
                } else if (defaultRetries != null) {
                    retries = defaultRetries;
                }
                DiscoveryConfigFactory.addToSpecificsFromURL(specifics, url.getContent(), url.getForeignSource(), url.getLocation(), timeout, retries);
            }
            LinkedList<IPPollAddress> linkedList = specifics;
            return linkedList;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IPPollRange> getRanges() {
        LinkedList<IPPollRange> includes = new LinkedList<IPPollRange>();
        this.getReadLock().lock();
        try {
            Long defaultTimeout = null;
            Integer defaultRetries = null;
            if (this.getConfiguration().hasTimeout()) {
                defaultTimeout = this.getConfiguration().getTimeout();
            }
            if (this.getConfiguration().hasRetries()) {
                defaultRetries = this.getConfiguration().getRetries();
            }
            for (IncludeRange ir : this.getConfiguration().getIncludeRangeCollection()) {
                try {
                    InetAddressUtils.toIpAddrBytes((String)ir.getBegin());
                }
                catch (Throwable e) {
                    LOG.warn("Begin address of discovery range is invalid, discarding: {}", (Object)ir.getBegin());
                    continue;
                }
                try {
                    InetAddressUtils.toIpAddrBytes((String)ir.getEnd());
                }
                catch (Throwable e) {
                    LOG.warn("End address of discovery range is invalid, discarding: {}", (Object)ir.getEnd());
                    continue;
                }
                long timeout = 2000L;
                if (ir.hasTimeout()) {
                    timeout = ir.getTimeout();
                } else if (defaultTimeout != null) {
                    timeout = defaultTimeout;
                }
                int retries = 1;
                if (ir.hasRetries()) {
                    retries = ir.getRetries();
                } else if (defaultRetries != null) {
                    retries = defaultRetries;
                }
                try {
                    includes.add(new IPPollRange(ir.getForeignSource(), ir.getLocation(), ir.getBegin(), ir.getEnd(), timeout, retries));
                }
                catch (UnknownHostException uhE) {
                    LOG.warn("Failed to convert address range ({}, {})", new Object[]{ir.getBegin(), ir.getEnd(), uhE});
                }
            }
            LinkedList<IPPollRange> linkedList = includes;
            return linkedList;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IPPollAddress> getSpecifics() {
        LinkedList<IPPollAddress> specifics = new LinkedList<IPPollAddress>();
        this.getReadLock().lock();
        try {
            Long defaultTimeout = null;
            Integer defaultRetries = null;
            if (this.getConfiguration().hasTimeout()) {
                defaultTimeout = this.getConfiguration().getTimeout();
            }
            if (this.getConfiguration().hasRetries()) {
                defaultRetries = this.getConfiguration().getRetries();
            }
            for (Specific s : this.getConfiguration().getSpecificCollection()) {
                long timeout = 2000L;
                if (s.hasTimeout()) {
                    timeout = s.getTimeout();
                } else if (defaultTimeout != null) {
                    timeout = defaultTimeout;
                }
                int retries = 1;
                if (s.hasRetries()) {
                    retries = s.getRetries();
                } else if (defaultRetries != null) {
                    retries = defaultRetries;
                }
                String address = s.getContent();
                try {
                    specifics.add(new IPPollAddress(s.getForeignSource(), s.getLocation(), InetAddressUtils.addr((String)address), timeout, retries));
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Failed to convert address {}", (Object)address, (Object)e);
                }
            }
            LinkedList<IPPollAddress> linkedList = specifics;
            return linkedList;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExcluded(InetAddress address) {
        this.getReadLock().lock();
        try {
            List excludeRange = this.getConfiguration().getExcludeRangeCollection();
            if (excludeRange != null) {
                byte[] laddr = address.getAddress();
                for (ExcludeRange range : excludeRange) {
                    if (!InetAddressUtils.isInetAddressInRange((byte[])laddr, (String)range.getBegin(), (String)range.getEnd())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getForeignSource(InetAddress address) {
        this.getReadLock().lock();
        try {
            LOG.debug("Looking for matching foreign source specific IP or IP range with address: {}...", (Object)address);
            List specificCollection = this.getConfiguration().getSpecificCollection();
            for (Specific specific : specificCollection) {
                String ipAddr = specific.getContent();
                if (!ipAddr.equals(InetAddressUtils.str((InetAddress)address))) continue;
                String foreignSource = specific.getForeignSource();
                LOG.debug("Matched foreign source {} matching address: {} against specific {}.", new Object[]{foreignSource, address, ipAddr});
                String string = foreignSource;
                return string;
            }
            byte[] laddr = address.getAddress();
            List includeRangeCollection = this.getConfiguration().getIncludeRangeCollection();
            for (IncludeRange range : includeRangeCollection) {
                if (!InetAddressUtils.isInetAddressInRange((byte[])laddr, (String)range.getBegin(), (String)range.getEnd())) continue;
                String foreignSource = range.getForeignSource();
                LOG.debug("Found foreign source {} with address {} in the range begin: {} and end: {}.", new Object[]{foreignSource, address, range.getBegin(), range.getEnd()});
                String string = foreignSource;
                return string;
            }
            List includeUrlCollection = this.getConfiguration().getIncludeUrlCollection();
            for (IncludeUrl includeUrl : includeUrlCollection) {
                String ipAddr = includeUrl.getContent();
                if (!ipAddr.equals(InetAddressUtils.str((InetAddress)address))) continue;
                String foreignSource = includeUrl.getForeignSource();
                LOG.debug("Matched foreign source {} matching address: {} in specified URL.", (Object)foreignSource, (Object)address);
                String string = foreignSource;
                return string;
            }
            String string = this.getConfiguration().getForeignSource();
            return string;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public double getPacketsPerSecond() {
        this.getReadLock().lock();
        try {
            double d = this.getConfiguration().getPacketsPerSecond();
            return d;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public long getIntraPacketDelay() {
        this.getReadLock().lock();
        try {
            long l = Math.round(1000.0 / this.getConfiguration().getPacketsPerSecond());
            return l;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public Iterator<IPPollAddress> getExcludingInterator(Iterator<IPPollAddress> it) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 1040), false).filter(item -> !this.isExcluded(item.getAddress())).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<IPPollAddress> getConfiguredAddresses() {
        this.getReadLock().lock();
        try {
            List<IPPollAddress> specifics = this.getSpecifics();
            List<IPPollRange> ranges = this.getRanges();
            specifics.addAll(this.getURLSpecifics());
            ArrayList<Iterator<IPPollAddress>> iters = new ArrayList<Iterator<IPPollAddress>>();
            iters.add(specifics.iterator());
            for (IPPollRange range : ranges) {
                iters.add(this.getExcludingInterator(range.iterator()));
            }
            Iterable iterable = IteratorUtils.concatIterators(iters);
            return iterable;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRestartSleepTime() {
        this.getReadLock().lock();
        try {
            long l = this.getConfiguration().getRestartSleepTime();
            return l;
        }
        catch (NullPointerException e) {
            long l = 86400000L;
            return l;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getInitialSleepTime() {
        this.getReadLock().lock();
        try {
            long l = this.getConfiguration().getInitialSleepTime();
            return l;
        }
        catch (NullPointerException e) {
            long l = 30000L;
            return l;
        }
        finally {
            this.getReadLock().unlock();
        }
    }
}

